\
    # Tema de Documentação – Livewire + Flux (Somente Views)

    Este pacote contém **apenas o tema de interface** para uma documentação
    baseada em **Livewire + Flux**, usando apenas componentes gratuitos
    (incluindo Heroicons através da prop `icon` do Flux).

    ## Estrutura

    - `resources/views/layouts/docs.blade.php`  
      Layout principal da documentação (sidebar, header, conteúdo).

    - `resources/views/docs/show.blade.php`  
      View que recebe os dados da página (título, descrição, conteúdo).

    - `resources/views/docs/pages/*.blade.php`  
      Exemplos de páginas de documentação (introdução, instalação, etc.).

    ## Uso com Livewire (exemplo)

    Crie um componente Livewire que carregue as views de `docs/pages` e use
    o layout `layouts.docs`:

    ```php
    // app/Livewire/Docs/Show.php
    namespace App\Livewire\Docs;

    use Livewire\Component;

    class Show extends Component
    {
        public string $slug;

        public function mount(string $slug = 'introducao')
        {
            $this->slug = $slug;
        }

        public function render()
        {
            $pageTitle       = ucfirst(str_replace('-', ' ', $this->slug));
            $pageDescription = null;
            $section         = 'Documentação';

            $content = view("docs.pages.{$this->slug}")->render();

            return view('docs.show', compact('pageTitle', 'pageDescription', 'content', 'section'))
                ->layout('layouts.docs', [
                    'pageTitle' => $pageTitle,
                ]);
        }
    }
    ```

    Depois basta criar rotas apontando para esse componente, por exemplo:

    ```php
    // routes/web.php
    use App\Livewire\Docs\Show;

    Route::get('/docs/{slug?}', Show::class)->name('docs.show');
    Route::get('/docs', fn () => redirect()->route('docs.show', 'introducao'))->name('docs.index');
    ```

    Ajuste os nomes conforme o seu projeto.
