\
    {{-- resources/views/docs/show.blade.php --}}
    <x-layouts.docs :title="$pageTitle ?? 'Documentação'">
        <div class="max-w-3xl">
            @if (! empty($section))
                <flux:badge
                    size="sm"
                    variant="soft"
                    icon="book-open"
                    class="mb-4"
                >
                    {{ $section }}
                </flux:badge>
            @endif

            <flux:heading level="1" size="xl" class="mb-2">
                {{ $pageTitle ?? 'Título da página' }}
            </flux:heading>

            @if (! empty($pageDescription))
                <flux:text class="text-zinc-300 mb-6">
                    {{ $pageDescription }}
                </flux:text>
            @endif

            <flux:separator variant="subtle" class="mb-8" />

            <article class="prose prose-invert max-w-none">
                {!! $content !!}
            </article>
        </div>
    </x-layouts.docs>
