<?php
// Diagnóstico detalhado de erro - REMOVA APÓS VERIFICAR

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<h1>Diagnóstico Detalhado</h1>";

$base = dirname(__DIR__);

echo "<h2>1. Verificando estrutura de pastas storage</h2>";

// Verificar se as pastas existem
$storageFolders = [
    'storage',
    'storage/app',
    'storage/app/public',
    'storage/framework',
    'storage/framework/cache',
    'storage/framework/cache/data',
    'storage/framework/sessions',
    'storage/framework/views',
    'storage/logs',
    'bootstrap/cache',
];

echo "<table border='1' cellpadding='5'>";
echo "<tr><th>Pasta</th><th>Existe</th><th>Gravável</th><th>Permissão</th></tr>";
foreach ($storageFolders as $folder) {
    $path = $base . '/' . $folder;
    $exists = file_exists($path);
    $writable = is_writable($path);
    $perms = $exists ? substr(sprintf('%o', fileperms($path)), -4) : 'N/A';
    echo "<tr>";
    echo "<td>$folder</td>";
    echo "<td style='color:" . ($exists ? 'green' : 'red') . "'>" . ($exists ? '✅' : '❌') . "</td>";
    echo "<td style='color:" . ($writable ? 'green' : 'red') . "'>" . ($writable ? '✅' : '❌') . "</td>";
    echo "<td>$perms</td>";
    echo "</tr>";
}
echo "</table>";

echo "<h2>2. Tentando carregar Laravel</h2>";

try {
    require $base . '/vendor/autoload.php';
    echo "<p style='color:green'>✅ Autoloader carregado com sucesso</p>";
    
    try {
        $app = require_once $base . '/bootstrap/app.php';
        echo "<p style='color:green'>✅ App bootstrap carregado</p>";
        
        try {
            $kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
            echo "<p style='color:green'>✅ HTTP Kernel criado</p>";
        } catch (Exception $e) {
            echo "<p style='color:red'>❌ Erro ao criar Kernel: " . htmlspecialchars($e->getMessage()) . "</p>";
            echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
        }
        
    } catch (Exception $e) {
        echo "<p style='color:red'>❌ Erro ao carregar bootstrap/app.php:</p>";
        echo "<pre style='background:#ffe0e0; padding:10px'>" . htmlspecialchars($e->getMessage()) . "</pre>";
        echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
    }
    
} catch (Exception $e) {
    echo "<p style='color:red'>❌ Erro ao carregar autoloader:</p>";
    echo "<pre style='background:#ffe0e0; padding:10px'>" . htmlspecialchars($e->getMessage()) . "</pre>";
}

echo "<h2>3. Verificando .env</h2>";
$envPath = $base . '/.env';
if (file_exists($envPath)) {
    $env = file_get_contents($envPath);
    // Mostrar apenas configurações não sensíveis
    preg_match('/APP_ENV=(.+)/', $env, $appEnv);
    preg_match('/APP_DEBUG=(.+)/', $env, $appDebug);
    preg_match('/APP_URL=(.+)/', $env, $appUrl);
    preg_match('/DB_CONNECTION=(.+)/', $env, $dbConn);
    
    echo "<table border='1' cellpadding='5'>";
    echo "<tr><td>APP_ENV</td><td>" . ($appEnv[1] ?? 'não definido') . "</td></tr>";
    echo "<tr><td>APP_DEBUG</td><td>" . ($appDebug[1] ?? 'não definido') . "</td></tr>";
    echo "<tr><td>APP_URL</td><td>" . ($appUrl[1] ?? 'não definido') . "</td></tr>";
    echo "<tr><td>DB_CONNECTION</td><td>" . ($dbConn[1] ?? 'não definido') . "</td></tr>";
    echo "</table>";
}

echo "<h2>4. Verificando arquivos de cache</h2>";
$cacheFiles = [
    'bootstrap/cache/packages.php' => $base . '/bootstrap/cache/packages.php',
    'bootstrap/cache/services.php' => $base . '/bootstrap/cache/services.php', 
    'bootstrap/cache/config.php' => $base . '/bootstrap/cache/config.php',
    'bootstrap/cache/routes-v7.php' => $base . '/bootstrap/cache/routes-v7.php',
];

echo "<table border='1' cellpadding='5'>";
echo "<tr><th>Arquivo</th><th>Existe</th></tr>";
foreach ($cacheFiles as $name => $path) {
    $exists = file_exists($path);
    echo "<tr>";
    echo "<td>$name</td>";
    echo "<td style='color:" . ($exists ? 'green' : 'orange') . "'>" . ($exists ? '✅' : '⚠️') . "</td>";
    echo "</tr>";
}
echo "</table>";

echo "<hr>";
echo "<p><strong>IMPORTANTE:</strong> Remova este arquivo após verificar!</p>";
