<?php
// Arquivo de diagnóstico - REMOVA APÓS VERIFICAR
// Acesse: https://docs.frameworkdocs.guisoft.net/info.php

echo "<h1>Diagnóstico do Servidor</h1>";
echo "<hr>";

// Versão do PHP
echo "<h2>Versão do PHP</h2>";
echo "<p><strong>PHP Version:</strong> " . PHP_VERSION . "</p>";
echo "<p><strong>Mínimo requerido:</strong> 8.2</p>";

// Verificar extensões necessárias
echo "<h2>Extensões PHP</h2>";
$required_extensions = [
    'openssl', 'pdo', 'pdo_mysql', 'pdo_sqlite', 'mbstring', 
    'tokenizer', 'xml', 'ctype', 'json', 'bcmath', 'curl', 'fileinfo'
];

echo "<table border='1' cellpadding='5'>";
echo "<tr><th>Extensão</th><th>Status</th></tr>";
foreach ($required_extensions as $ext) {
    $loaded = extension_loaded($ext);
    $status = $loaded ? '✅ OK' : '❌ Faltando';
    $color = $loaded ? 'green' : 'red';
    echo "<tr><td>$ext</td><td style='color:$color'>$status</td></tr>";
}
echo "</table>";

// Permissões de pastas
echo "<h2>Permissões de Pastas</h2>";
$base = dirname(__DIR__);
$folders = [
    'storage' => $base . '/storage',
    'storage/logs' => $base . '/storage/logs',
    'storage/framework' => $base . '/storage/framework',
    'storage/framework/cache' => $base . '/storage/framework/cache',
    'storage/framework/sessions' => $base . '/storage/framework/sessions',
    'storage/framework/views' => $base . '/storage/framework/views',
    'bootstrap/cache' => $base . '/bootstrap/cache',
];

echo "<table border='1' cellpadding='5'>";
echo "<tr><th>Pasta</th><th>Existe</th><th>Gravável</th></tr>";
foreach ($folders as $name => $path) {
    $exists = file_exists($path);
    $writable = is_writable($path);
    echo "<tr>";
    echo "<td>$name</td>";
    echo "<td>" . ($exists ? '✅' : '❌') . "</td>";
    echo "<td>" . ($writable ? '✅' : '❌') . "</td>";
    echo "</tr>";
}
echo "</table>";

// Verificar .env
echo "<h2>Arquivo .env</h2>";
$envFile = $base . '/.env';
if (file_exists($envFile)) {
    echo "<p style='color:green'>✅ Arquivo .env existe</p>";
    
    // Verificar APP_KEY
    $envContent = file_get_contents($envFile);
    if (preg_match('/APP_KEY=base64:.+/', $envContent)) {
        echo "<p style='color:green'>✅ APP_KEY está definida</p>";
    } else {
        echo "<p style='color:red'>❌ APP_KEY NÃO está definida - Execute: php artisan key:generate</p>";
    }
} else {
    echo "<p style='color:red'>❌ Arquivo .env NÃO existe - Copie o .env.example para .env</p>";
}

// Testar autoloader
echo "<h2>Autoloader</h2>";
$autoload = $base . '/vendor/autoload.php';
if (file_exists($autoload)) {
    echo "<p style='color:green'>✅ vendor/autoload.php existe</p>";
} else {
    echo "<p style='color:red'>❌ vendor/autoload.php NÃO existe - Execute: composer install</p>";
}

// Document Root
echo "<h2>Document Root</h2>";
echo "<p>Document Root atual: " . $_SERVER['DOCUMENT_ROOT'] . "</p>";
echo "<p>Script atual: " . __FILE__ . "</p>";

if (strpos(__FILE__, 'public') !== false) {
    echo "<p style='color:green'>✅ Document Root parece correto (aponta para /public)</p>";
} else {
    echo "<p style='color:orange'>⚠️ Verifique se o Document Root aponta para a pasta /public</p>";
}

echo "<hr>";
echo "<p><strong>IMPORTANTE:</strong> Remova este arquivo após verificar!</p>";
