# QueueMaster - Referência da API

## Base URL

```
https://{tenant}.test:{port}/api/queue-master
```

Exemplo:
```
https://og-tenant1.test:8003/api/queue-master
```

## Autenticação

A API usa a mesma autenticação da aplicação principal. Certifique-se de estar autenticado.

## Formato de Resposta

Todas as respostas seguem o formato padrão:

```json
{
    "success": true|false,
    "data": { ... },
    "message": "Optional message"
}
```

---

### 8. Scaling API (Experimental)

As rotas abaixo expõem o motor de autoscaling para integrações externas. A aba **Autoscale** atual consome apenas `GET /v2/queue-master/autoscale/status`; as rotas `/scaling/*` continuam disponíveis para scripts e futuros controles UI.

| Endpoint | Método | Descrição |
| --- | --- | --- |
| `/v2/queue-master/scaling/decision` | `POST` | Calcula uma decisão de scale-up/down para `queue`/`vhost` informados sem executar nada. |
| `/v2/queue-master/scaling/apply` | `POST` | Publica um comando manual (`scale_up`, `scale_down` ou `restart_worker`). Use `auto=true` para deixar o sistema escolher o host. |
| `/v2/queue-master/scaling/status` | `GET` | Quando sem parâmetros retorna todas as decisões pendentes; com `queue` retorna detalhes e cooldown em vigor. |
| `/v2/queue-master/scaling/history` | `GET` | Lista os últimos comandos publicados (limite padrão 50). |
| `/v2/queue-master/scaling/thresholds` | `GET` | Informa os limites atuais (`scale_up`, `scale_down`, `min_workers`, `max_workers`, `cooldown_seconds`). |
| `/v2/queue-master/scaling/cooldown` | `POST` | Atualiza o cooldown global (10–600s). Requer `cooldown_seconds` no corpo. |

**Exemplo – verificar decisão sem executar**

```bash
curl -X POST https://og-tenant1.test:8003/api/v2/queue-master/scaling/decision \
  -H 'Content-Type: application/json' \
  -d '{"queue":"critical","vhost":"/tenant1"}'
```

Resposta resumida:

```json
{
  "success": true,
  "decision": {
    "action": "scale_up",
    "amount": 2,
    "queue": "critical",
    "vhost": "/tenant1",
    "current_workers": 1,
    "current_pressure": 5.4,
    "queue_size": 27,
    "reason": "Pressure 5.4 > 3"
  },
  "timestamp": 1730067600
}
```

> **Importante:** Como o dashboard ainda não dispara `POST /scaling/apply`, qualquer automação que utilizar essas rotas deve registrar no Jira/Runbook para que futuras alterações no frontend não quebrem integrações existentes.

---

## Endpoints

### 1. Overview

Retorna visão geral do sistema QueueMaster.

**Endpoint**: `GET /api/queue-master/overview`

**Parâmetros**: Nenhum

**Response**:

```json
{
    "success": true,
    "data": {
        "vhost": "all",
        "total_workers": 10,
        "processing_workers": 3,
        "idle_workers": 7,
        "error_workers": 0,
        "total_jobs_processed": 1542,
        "total_memory_usage": 536870912,
        "total_memory_mb": 512.0,
        "queues_count": 3,
        "total_queue_size": 42,
        "total_consumers": 10,
        "avg_queue_pressure": 4.2,
        "last_updated": 1704067200,
        "uptime": 3600,
        "rabbitmq_healthy": true
    }
}
```

**Campos**:

| Campo | Tipo | Descrição |
|-------|------|-----------|
| `vhost` | string | VHost sendo monitorado |
| `total_workers` | int | Total de workers ativos |
| `processing_workers` | int | Workers processando jobs |
| `idle_workers` | int | Workers ociosos |
| `error_workers` | int | Workers em estado de erro |
| `total_jobs_processed` | int | Total de jobs processados |
| `total_memory_mb` | float | Memória total usada (MB) |
| `queues_count` | int | Número de filas |
| `total_queue_size` | int | Total de mensagens em filas |
| `avg_queue_pressure` | float | Pressão média (messages/consumer) |
| `uptime` | int | Uptime do sistema mais antigo (segundos) |
| `rabbitmq_healthy` | bool | RabbitMQ está saudável |

**Exemplo**:

```bash
curl https://og-tenant1.test:8003/api/queue-master/overview
```

---

### 2. Workers

Lista todos os workers ativos.

**Endpoint**: `GET /api/queue-master/workers`

**Parâmetros**: Nenhum

**Response**:

```json
{
    "success": true,
    "data": {
        "workers": [
            {
                "pid": 12345,
                "hostname": "server1",
                "name": "default:worker-12345",
                "supervisor": "default",
                "connection": "rabbitmq",
                "queue": "default",
                "vhost": "/tenant1",
                "started_at": 1704067200,
                "memory_usage": 47185920,
                "memory_usage_mb": 45.0,
                "memory_limit": 536870912,
                "max_time": 300,
                "max_jobs": 0,
                "status": "processing",
                "jobs_processed": 67,
                "current_job": "App\\Jobs\\SendEmailJob",
                "last_heartbeat": 1704067500,
                "last_heartbeat_ago": 5,
                "uptime": 1530,
                "uptime_human": "25m 30s",
                "is_expired": false,
                "status_color": "success",
                "manager": "queue-master",
                "is_queuemaster": true,
                "managed_by": "QueueMaster"
            }
        ],
        "total": 10
    }
}
```

**Campos do Worker**:

| Campo | Tipo | Descrição |
|-------|------|-----------|
| `pid` | int | Process ID |
| `hostname` | string | Nome do servidor |
| `name` | string | Nome do worker |
| `supervisor` | string | Nome do supervisor |
| `queue` | string | Fila sendo processada |
| `vhost` | string | VHost RabbitMQ |
| `status` | string | `'processing'`, `'idle'`, `'active'`, `'error'` |
| `jobs_processed` | int | Jobs processados desde início |
| `current_job` | string\|null | Job atual sendo executado |
| `memory_usage_mb` | float | Memória em uso (MB) |
| `uptime` | int | Tempo de vida (segundos) |
| `uptime_human` | string | Uptime formatado (ex: "25m 30s") |
| `last_heartbeat_ago` | int | Segundos desde último heartbeat |
| `is_expired` | bool | Worker expirou (sem heartbeat > 90s) |
| `manager` | string | Gerenciador (`'queue-master'` ou `null`) |

**Exemplo**:

```bash
curl https://og-tenant1.test:8003/api/queue-master/workers
```

---

### 3. Queues

Lista todas as filas RabbitMQ e suas métricas.

**Endpoint**: `GET /api/queue-master/queues`

**Parâmetros**: Nenhum

**Response**:

```json
{
    "success": true,
    "data": {
        "queues": [
            {
                "name": "default",
                "vhost": "/tenant1",
                "messages": 42,
                "consumers": 5,
                "message_rate": 2.5,
                "pressure": 8.4,
                "pressure_status": "high",
                "state": "running",
                "consumer_utilisation": 0.95
            }
        ],
        "total": 3
    }
}
```

**Campos da Queue**:

| Campo | Tipo | Descrição |
|-------|------|-----------|
| `name` | string | Nome da fila |
| `vhost` | string | VHost |
| `messages` | int | Mensagens pendentes |
| `consumers` | int | Número de consumers |
| `message_rate` | float | Taxa de mensagens/segundo |
| `pressure` | float | Pressão (messages / consumers) |
| `pressure_status` | string | `'low'`, `'medium'`, `'high'`, `'critical'` |
| `state` | string | Estado da fila |
| `consumer_utilisation` | float | Utilização dos consumers (0-1) |

**Pressure Status**:

- `low`: pressure < 2.0
- `medium`: 2.0 ≤ pressure < 5.0
- `high`: 5.0 ≤ pressure < 10.0
- `critical`: pressure ≥ 10.0

**Exemplo**:

```bash
curl https://og-tenant1.test:8003/api/queue-master/queues
```

---

### 4. Jobs Overview

Retorna overview de jobs.

**Endpoint**: `GET /api/queue-master/jobs/overview`

**Parâmetros**:

| Parâmetro | Tipo | Padrão | Descrição |
|-----------|------|--------|-----------|
| `hours` | int | `24` | Período em horas |
| `vhost` | string | - | Filtrar por vhost |
| `queue` | string | - | Filtrar por queue |

**Response**:

```json
{
    "success": true,
    "data": {
        "total_jobs": 1542,
        "active_jobs": 3,
        "pending_jobs": 42,
        "completed_jobs": 1500,
        "failed_jobs": 42,
        "avg_duration": 2.35,
        "avg_duration_ms": 2350,
        "avg_duration_seconds": 2.35,
        "retry_rate": 2.72,
        "period_hours": 24
    }
}
```

**Exemplo**:

```bash
# Últimas 24h
curl https://og-tenant1.test:8003/api/queue-master/jobs/overview

# Últimas 6h
curl https://og-tenant1.test:8003/api/queue-master/jobs/overview?hours=6

# Filtrar por queue
curl https://og-tenant1.test:8003/api/queue-master/jobs/overview?queue=reports
```

---

### 5. Active Jobs

Lista jobs em execução no momento.

**Endpoint**: `GET /api/queue-master/jobs/active`

**Parâmetros**:

| Parâmetro | Tipo | Padrão | Descrição |
|-----------|------|--------|-----------|
| `limit` | int | `100` | Máximo de jobs retornados |

**Response**:

```json
{
    "success": true,
    "data": {
        "jobs": [
            {
                "job_id": "550e8400-e29b-41d4-a716-446655440000",
                "job_class": "App\\Jobs\\SendEmailJob",
                "display_name": "SendEmailJob",
                "worker": "server1:12345",
                "hostname": "server1",
                "pid": 12345,
                "queue": "default",
                "vhost": "/tenant1",
                "tenant": "tenant1.test",
                "tenant_domain": "tenant1.test",
                "owner_id": 42,
                "tenant_id": 42,
                "company_id": 100,
                "started_at": 1704067200.123,
                "started_at_iso": "2024-01-01T00:00:00+00:00",
                "duration_ms": 2350.5,
                "attempt": 1,
                "status": "running",
                "context": {}
            }
        ],
        "total": 3,
        "timestamp": 1704067500
    }
}
```

**Exemplo**:

```bash
# Primeiros 100
curl https://og-tenant1.test:8003/api/queue-master/jobs/active

# Primeiros 50
curl https://og-tenant1.test:8003/api/queue-master/jobs/active?limit=50
```

---

### 6. Recent Jobs

Lista jobs completados recentemente.

**Endpoint**: `GET /api/queue-master/jobs/recent`

**Parâmetros**:

| Parâmetro | Tipo | Padrão | Descrição |
|-----------|------|--------|-----------|
| `limit` | int | `100` | Máximo de jobs retornados |
| `queue` | string | - | Filtrar por queue |
| `tenant` | string | - | Filtrar por tenant |

**Response**:

```json
{
    "success": true,
    "data": {
        "jobs": [
            {
                "job_id": "550e8400-e29b-41d4-a716-446655440000",
                "job_class": "App\\Jobs\\SendEmailJob",
                "display_name": "SendEmailJob",
                "worker": "server1:12345",
                "queue": "default",
                "started_at": 1704067200.123,
                "finished_at": 1704067202.456,
                "started_at_iso": "2024-01-01T00:00:00+00:00",
                "finished_at_iso": "2024-01-01T00:00:02+00:00",
                "runtime_ms": 2333.0,
                "duration_ms": 2333.0,
                "attempt": 1,
                "status": "completed",
                "result": null,
                "context": {}
            }
        ],
        "total": 100,
        "limit": 100,
        "has_more": true,
        "filters": {
            "queue": "default"
        }
    }
}
```

**Exemplo**:

```bash
# Últimos 100
curl https://og-tenant1.test:8003/api/queue-master/jobs/recent

# Filtrar por queue
curl https://og-tenant1.test:8003/api/queue-master/jobs/recent?queue=reports&limit=50

# Filtrar por tenant
curl https://og-tenant1.test:8003/api/queue-master/jobs/recent?tenant=tenant1.test
```

---

### 7. Failed Jobs

Lista jobs falhados.

**Endpoint**: `GET /api/queue-master/jobs/failed`

**Parâmetros**:

| Parâmetro | Tipo | Padrão | Descrição |
|-----------|------|--------|-----------|
| `limit` | int | `100` | Máximo de jobs retornados |
| `queue` | string | - | Filtrar por queue |
| `tenant` | string | - | Filtrar por tenant |

**Response**:

```json
{
    "success": true,
    "data": {
        "jobs": [
            {
                "job_id": "550e8400-e29b-41d4-a716-446655440000",
                "job_class": "App\\Jobs\\ProcessReportJob",
                "display_name": "ProcessReportJob",
                "worker": "server1:12345",
                "queue": "reports",
                "started_at": 1704067200.123,
                "failed_at": 1704067800.456,
                "runtime_ms": 600333.0,
                "attempt": 3,
                "status": "failed",
                "exception_class": "RuntimeException",
                "exception_message": "Database connection lost",
                "trace_snippet": "RuntimeException: Database connection lost\n  at ProcessReportJob.php:45",
                "context": {}
            }
        ],
        "total": 10,
        "limit": 100,
        "has_more": false,
        "filters": {}
    }
}
```

**Exemplo**:

```bash
curl https://og-tenant1.test:8003/api/queue-master/jobs/failed?limit=20
```

---

### 8. Shutdown History

Histórico de shutdowns de workers.

**Endpoint**: `GET /api/queue-master/shutdowns/history`

**Parâmetros**:

| Parâmetro | Tipo | Padrão | Descrição |
|-----------|------|--------|-----------|
| `limit` | int | `50` | Máximo de shutdowns |
| `hostname` | string | - | Filtrar por hostname |
| `queue` | string | - | Filtrar por queue |

**Response**:

```json
{
    "success": true,
    "data": {
        "shutdowns": [
            {
                "pid": 12345,
                "hostname": "server1",
                "shutdown_time": 1704067800,
                "shutdown_time_human": "2024-01-01 10:30:00",
                "shutdown_reason": "max_time_reached",
                "reason_color": "warning",
                "uptime_seconds": 300,
                "uptime_human": "5m 0s",
                "jobs_processed": 60,
                "queue": "default",
                "vhost": "/tenant1",
                "memory_usage_mb": 45.2
            }
        ],
        "total": 50,
        "filters": {
            "limit": 50,
            "hostname": null,
            "queue": null
        }
    }
}
```

**Shutdown Reasons**:

| Reason | Descrição | Color |
|--------|-----------|-------|
| `signal_sigterm` | SIGTERM recebido | `info` |
| `signal_sigint` | SIGINT recebido | `info` |
| `max_time_reached` | Tempo máximo atingido | `warning` |
| `max_jobs_reached` | Máximo de jobs atingido | `warning` |
| `memory_limit` | Limite de memória excedido | `warning` |
| `fatal_error` | Erro fatal | `danger` |
| `unknown` | Razão desconhecida | `danger` |

**Exemplo**:

```bash
# Últimos 50
curl https://og-tenant1.test:8003/api/queue-master/shutdowns/history

# Filtrar por hostname
curl https://og-tenant1.test:8003/api/queue-master/shutdowns/history?hostname=server1&limit=100

# Filtrar por queue
curl https://og-tenant1.test:8003/api/queue-master/shutdowns/history?queue=reports
```

---

### 9. Shutdown Stats

Estatísticas agregadas de shutdowns.

**Endpoint**: `GET /api/queue-master/shutdowns/stats`

**Parâmetros**:

| Parâmetro | Tipo | Padrão | Descrição |
|-----------|------|--------|-----------|
| `hostname` | string | - | Filtrar por hostname |
| `days` | int | `7` | Período em dias |

**Response**:

```json
{
    "success": true,
    "data": {
        "total_shutdowns": 1542,
        "by_reason": {
            "max_time_reached": 850,
            "max_jobs_reached": 400,
            "memory_limit": 150,
            "signal_sigterm": 100,
            "fatal_error": 42
        },
        "avg_uptime_seconds": 285.5,
        "avg_jobs_per_worker": 58.3,
        "period_days": 7,
        "hostname_filter": null
    }
}
```

**Exemplo**:

```bash
# Últimos 7 dias
curl https://og-tenant1.test:8003/api/queue-master/shutdowns/stats

# Últimas 24h
curl https://og-tenant1.test:8003/api/queue-master/shutdowns/stats?days=1

# Por hostname
curl https://og-tenant1.test:8003/api/queue-master/shutdowns/stats?hostname=server1&days=7
```

---

### 10. Anomalous Shutdowns

Shutdowns anômalos (problemas).

**Endpoint**: `GET /api/queue-master/shutdowns/anomalous`

**Parâmetros**:

| Parâmetro | Tipo | Padrão | Descrição |
|-----------|------|--------|-----------|
| `limit` | int | `50` | Máximo de shutdowns |

**Response**:

```json
{
    "success": true,
    "data": {
        "shutdowns": [
            {
                "pid": 12345,
                "hostname": "server1",
                "shutdown_time": 1704067800,
                "shutdown_time_human": "2024-01-01 10:30:00",
                "shutdown_reason": "fatal_error",
                "reason_color": "danger",
                "uptime_seconds": 15,
                "uptime_human": "15s",
                "jobs_processed": 1,
                "queue": "default"
            }
        ],
        "total": 5
    },
    "message": "Found anomalous shutdowns that require investigation"
}
```

**O que são shutdowns anômalos**:
- `fatal_error`
- `unknown`
- `uptime < 60s` (worker morreu muito rápido)
- `jobs_processed = 0` (worker não processou nada)

**Exemplo**:

```bash
curl https://og-tenant1.test:8003/api/queue-master/shutdowns/anomalous
```

---

### 11. Tenant Switches

Histórico de mudanças de tenant (multi-tenant).

**Endpoint**: `GET /api/queue-master/tenant-switches`

**Parâmetros**:

| Parâmetro | Tipo | Padrão | Descrição |
|-----------|------|--------|-----------|
| `limit` | int | `50` | Máximo de switches |
| `hostname` | string | - | Filtrar por hostname |

**Response**:

```json
{
    "success": true,
    "data": {
        "switches": [
            {
                "pid": 12345,
                "worker_pid": 12345,
                "hostname": "server1",
                "timestamp": 1704067200,
                "timestamp_human": "2024-01-01 00:00:00",
                "from_tenant": {
                    "domain": "tenant1.test",
                    "company_id": 100,
                    "owner_id": 42
                },
                "to_tenant": {
                    "domain": "tenant2.test",
                    "company_id": 200,
                    "owner_id": 84
                },
                "from_vhost": "/tenant1",
                "to_vhost": "/tenant1",
                "success": true,
                "success_badge": "success",
                "error": null
            }
        ],
        "total": 50
    }
}
```

**Exemplo**:

```bash
# Últimos 50
curl https://og-tenant1.test:8003/api/queue-master/tenant-switches

# Filtrar por hostname
curl https://og-tenant1.test:8003/api/queue-master/tenant-switches?hostname=server1&limit=100
```

---

### 12. Tenant Switch Stats

Estatísticas de tenant switching.

**Endpoint**: `GET /api/queue-master/tenant-switches/stats`

**Parâmetros**:

| Parâmetro | Tipo | Padrão | Descrição |
|-----------|------|--------|-----------|
| `days` | int | `1` | Período em dias |

**Response**:

```json
{
    "success": true,
    "data": {
        "total_switches": 1542,
        "successful_switches": 1500,
        "failed_switches": 42,
        "failure_rate": 2.72,
        "unique_tenants": 5,
        "avg_switches_per_day": 220.3,
        "health_status": "healthy"
    }
}
```

**Health Status**:
- `healthy`: failure_rate ≤ 1%
- `warning`: 1% < failure_rate ≤ 5%
- `critical`: failure_rate > 5%

**Exemplo**:

```bash
# Último dia
curl https://og-tenant1.test:8003/api/queue-master/tenant-switches/stats

# Últimos 7 dias
curl https://og-tenant1.test:8003/api/queue-master/tenant-switches/stats?days=7
```

---

### 13. Problematic Tenant Switches

Tenant switches com problemas.

**Endpoint**: `GET /api/queue-master/tenant-switches/problematic`

**Parâmetros**:

| Parâmetro | Tipo | Padrão | Descrição |
|-----------|------|--------|-----------|
| `limit` | int | `50` | Máximo de switches |

**Response**:

```json
{
    "success": true,
    "data": {
        "switches": [
            {
                "worker_pid": 12345,
                "timestamp_human": "2024-01-01 10:00:00",
                "from_tenant": {
                    "domain": "tenant1.test",
                    "company_id": 100
                },
                "to_tenant": {
                    "domain": "tenant2.test",
                    "company_id": 200
                },
                "success": false,
                "error": "Failed to load tenant configuration",
                "severity": "critical",
                "isolation_issues": ["config_load_failed"]
            }
        ],
        "total": 5
    },
    "message": "Found problematic tenant switches"
}
```

**Exemplo**:

```bash
curl https://og-tenant1.test:8003/api/queue-master/tenant-switches/problematic
```

---

### 14. Stale Workers

Workers sem heartbeat (possivelmente travados).

**Endpoint**: `GET /api/queue-master/workers/stale`

**Parâmetros**:

| Parâmetro | Tipo | Padrão | Descrição |
|-----------|------|--------|-----------|
| `timeout` | int | `60` | Timeout em segundos |
| `vhost` | string | - | Filtrar por vhost |

**Response**:

```json
{
    "success": true,
    "data": {
        "stale_workers": [
            {
                "hostname": "server1",
                "pid": 12345,
                "vhost": "/tenant1",
                "time_since_heartbeat": 125,
                "last_heartbeat": 1704067075,
                "is_stale": true
            }
        ],
        "total": 2,
        "timeout_seconds": 60
    }
}
```

**Exemplo**:

```bash
# Timeout 60s (padrão)
curl https://og-tenant1.test:8003/api/queue-master/workers/stale

# Timeout customizado
curl https://og-tenant1.test:8003/api/queue-master/workers/stale?timeout=120
```

---

## Códigos de Status HTTP

| Código | Descrição |
|--------|-----------|
| `200` | Sucesso |
| `500` | Erro interno do servidor |

## Tratamento de Erros

Quando `success = false`:

```json
{
    "success": false,
    "message": "Failed to fetch workers data: Connection refused"
}
```

## Rate Limiting

Não há rate limiting implementado atualmente.

## Próximos Documentos

- **[MONITORING.md](MONITORING.md)** - Como usar a API para monitoramento
- **[TROUBLESHOOTING.md](TROUBLESHOOTING.md)** - Debug usando a API
- **[EXAMPLES.md](EXAMPLES.md)** - Exemplos de uso da API
