# QueueMaster - Checklist de Deploy / Pré-Produção

## Configuração

- [ ] `Modules/Common/Config/queue-master.php` atualizado com os vhosts/queues de produção.
- [ ] `QUEUE_MASTER_ENABLED=true` e `QUEUE_MASTER_REDIS` apontando para o cluster correto.
- [ ] `queue-master.process.zombie_ttl` definido (ex.: 1800s) e overrides configurados para jobs longos.
- [ ] Abas Metrics/Monitoring funcionando (API stats + snapshots).

## Processos & Signals

- [ ] `php og queue-master` rodando via supervisor/systemd.
- [ ] `php og queue-master:listen-commands` rodando (1 por host) e `LLEN qm:command_queue:{hostname}` próximo de 0.
- [ ] Scripts de deploy usam os sinais POSIX corretos:
  - `SIGUSR1` → pause (drain)
  - `SIGCONT` → resume
  - `SIGUSR2` → restart workers
  - `SIGTERM/SIGINT` → shutdown gracioso

## Jobs automáticos

- [ ] Cron `queue-master:jobs:cleanup-zombies --dry-run` (alerta) + execução real conforme SLA.
- [ ] Cron `queue-master:redis:orphan-scan` (dry-run diário + limpeza semanal).
- [ ] Snapshot de métricas (opcional): `queue-master:snapshot --store --label="hourly"`.

## Testes

- [ ] `pest --group queue-master` executado no container.
- [ ] (Opcional) `QUEUE_MASTER_RUN_CROSS_MACHINE=1` para validar os tests de PCNTL.
- [ ] Smoke manual: dashboard (pause/resume/restart), badge de zombies, CLI (`jobs:cleanup-zombies`, `redis:orphan-scan`).

## Observabilidade

- [ ] Monitoramento coleta `avg_queue_pressure`, `total_workers`, erros de shutdown.
- [ ] Alerta configurado para `rabbitmq_healthy=false` e `failure_rate > 5%`.
