# QueueMaster - Roadmap

## Visão Geral

Este documento descreve as funcionalidades planejadas para o QueueMaster. As features estão organizadas por prioridade e complexidade.

## Legenda

- **Status**:
  - Planejado
  - Em Desenvolvimento
  - Concluído
  - Cancelado

- **Prioridade**:
  - P0: Crítico (blocking)
  - P1: Alta
  - P2: Média
  - P3: Baixa

- **Complexidade**:
  - Pequena (1-3 dias)
  - Média (1 semana)
  - Grande (2-4 semanas)
  - Muito Grande (1+ mês)

---

## Versão Atual: 1.0

### Funcionalidades Atuais

- Master Supervisor com gerenciamento de supervisors
- Queue Supervisor com pool de workers
- Autoscaling básico (balance: off, simple, auto)
- Multi-tenant via vhosts RabbitMQ
- Dashboard web com métricas
- Shutdown tracking e análise
- Tenant switching monitoring
- API REST completa
- Integração Redis para registry

---

## Versão 1.1 (Próxima Release)

### 1. Autoscaling Dinâmico Avançado

**Status**: Planejado
**Prioridade**: P1
**Complexidade**: Média

**Descrição**: Melhorar autoscaling com algoritmos mais sofisticados.

**Funcionalidades**:

1. **Predictive Scaling**
   - Análise de histórico de carga
   - Predição de picos baseada em padrões (ex: todo dia útil 9h-18h)
   - Scale up ANTES do pico

2. **Adaptive Thresholds**
   - Thresholds que se ajustam automaticamente
   - Aprendizado baseado em comportamento real
   - Diferentes thresholds por hora do dia

3. **Cost-Aware Scaling**
   - Considerar custo de workers ociosos
   - Balance entre performance e recursos
   - Configuração de "max spend"

**Implementação**:

```php
'autoscaling' => [
    'strategy' => 'predictive',  // Novo!

    'predictive' => [
        'enabled' => true,
        'look_back_hours' => 168,  // 7 dias
        'confidence_threshold' => 0.8,
        'scale_ahead_minutes' => 5,
    ],

    'adaptive' => [
        'enabled' => true,
        'learning_period_days' => 7,
        'adjust_frequency_hours' => 24,
    ],
],
```

**Benefícios**:
- Menos latência em picos
- Melhor utilização de recursos
- Economia de custos

---

### 2. Health Checks Automáticos

**Status**: Planejado
**Prioridade**: P1
**Complexidade**: Pequena

**Descrição**: Workers executam health checks periódicos.

**Funcionalidades**:

1. **Self Health Check**
   - Worker verifica sua própria saúde a cada N segundos
   - Conectividade RabbitMQ
   - Conectividade Redis
   - Conectividade Database

2. **Auto-Restart em Falha**
   - Worker se mata se falhar health check
   - Supervisor cria novo worker automaticamente

3. **Health Status API**
   - Endpoint mostrando saúde de cada worker
   - Alertas configuráveis

**Implementação**:

```php
'health_checks' => [
    'enabled' => true,
    'interval' => 30,  // segundos

    'checks' => [
        'rabbitmq' => true,
        'redis' => true,
        'database' => true,
    ],

    'timeout' => 5,  // timeout por check
    'max_failures' => 3,  // antes de restart
],
```

**API**:

```bash
GET /api/queue-master/health
```

Response:
```json
{
  "workers": [
    {
      "pid": 12345,
      "health_status": "healthy",
      "last_check": "2024-01-01T00:00:00Z",
      "checks": {
        "rabbitmq": "pass",
        "redis": "pass",
        "database": "pass"
      }
    }
  ]
}
```

---

### 3. Priorização de Filas

**Status**: Planejado
**Prioridade**: P2
**Complexidade**: Média

**Descrição**: Workers processam filas em ordem de prioridade.

**Funcionalidades**:

1. **Priority Queues**
   - Configurar prioridade numérica (1-10)
   - Workers processam alta prioridade primeiro

2. **Dynamic Priority**
   - Prioridade pode mudar baseada em:
     - Idade do job
     - Tipo de tenant
     - Horário

**Implementação**:

```php
'environments' => [
    'production' => [
        'critical' => [
            'queue' => 'critical',
            'priority' => 10,  // Novo!
            // ...
        ],
        'default' => [
            'queue' => 'default',
            'priority' => 5,
            // ...
        ],
        'low' => [
            'queue' => 'low',
            'priority' => 1,
            // ...
        ],
    ],
],
```

Worker processa nesta ordem:
1. `critical` (priority 10)
2. `default` (priority 5)
3. `low` (priority 1)

---

### 4. Rate Limiting de Jobs

**Status**: Planejado
**Prioridade**: P2
**Complexidade**: Pequena

**Descrição**: Limitar taxa de processamento de jobs específicos.

**Funcionalidades**:

1. **Job-Level Rate Limiting**
   - Máximo N jobs por segundo de um tipo
   - Evita sobrecarga de APIs externas

2. **Tenant-Level Rate Limiting**
   - Máximo N jobs por segundo por tenant
   - Fair-share entre tenants

**Implementação**:

```php
// No Job
class SendEmailJob extends Job
{
    public function rateLimits(): array
    {
        return [
            'max_per_second' => 10,
            'max_per_minute' => 100,
        ];
    }
}
```

```php
// Na configuração
'rate_limits' => [
    'enabled' => true,

    'per_job' => [
        'App\Jobs\SendEmailJob' => [
            'max_per_second' => 10,
        ],
    ],

    'per_tenant' => [
        'max_per_second' => 50,
    ],
],
```

---

## Versão 1.2

### 5. Suporte a Redis Streams

**Status**: Planejado
**Prioridade**: P2
**Complexidade**: Grande

**Descrição**: Adicionar suporte a Redis Streams como alternativa ao RabbitMQ.

**Funcionalidades**:

1. **Driver Redis Streams**
   - Consumer groups
   - ACK/NACK de mensagens
   - Dead letter queue

2. **Configuração Simples**
   ```php
   'connection' => 'redis-streams',
   ```

**Benefícios**:
- Uma dependência a menos (não precisa RabbitMQ)
- Simplicidade
- Performance similar

---

### 6. Load Balancing Strategies

**Status**: Planejado
**Prioridade**: P2
**Complexidade**: Média

**Descrição**: Diferentes estratégias de distribuição de carga.

**Estratégias**:

1. **Round Robin** (atual)
   - Workers pegam jobs em ordem

2. **Least Connections**
   - Job vai para worker com menos jobs ativos

3. **Weighted Round Robin**
   - Workers com mais capacidade pegam mais jobs

4. **Job Affinity**
   - Jobs do mesmo tenant sempre no mesmo worker (cache locality)

**Implementação**:

```php
'load_balancing' => [
    'strategy' => 'least_connections',  // round_robin, weighted, affinity

    'affinity' => [
        'enabled' => true,
        'key' => 'tenant',  // ou 'company', 'user'
    ],
],
```

---

### 7. Warm Standby Workers

**Status**: Planejado
**Prioridade**: P3
**Complexidade**: Pequena

**Descrição**: Manter workers "aquecidos" prontos para assumir carga.

**Funcionalidades**:

1. **Standby Pool**
   - N workers em standby (não processando)
   - Sobem para ativo quando necessário

2. **Fast Scale Up**
   - Latência quase zero para aumentar workers

**Implementação**:

```php
'standby' => [
    'enabled' => true,
    'count' => 2,  // 2 workers sempre em standby
    'activation_threshold' => 'high',  // low, medium, high
],
```

---

### 8. Job Tracing / Distributed Tracing

**Status**: Planejado
**Prioridade**: P2
**Complexidade**: Média

**Descrição**: Rastreamento completo de execução de jobs.

**Funcionalidades**:

1. **Trace ID**
   - Cada job tem trace_id único
   - Propaga através de job chains

2. **Spans**
   - Cada operação é um span
   - Visualização de timeline

3. **Integração OpenTelemetry**
   - Exportar para Jaeger/Zipkin
   - Correlação com requests HTTP

**Implementação**:

```php
'tracing' => [
    'enabled' => true,
    'exporter' => 'jaeger',  // jaeger, zipkin, datadog

    'jaeger' => [
        'host' => 'localhost',
        'port' => 6831,
    ],
],
```

**Uso**:

```bash
# Ver trace de job específico
https://jaeger.local/trace/<trace_id>
```

---

## Versão 2.0 (Long Term)

### 9. Multi-Master Support

**Status**: Planejado
**Prioridade**: P1
**Complexidade**: Muito Grande

**Descrição**: Múltiplos Masters para alta disponibilidade.

**Funcionalidades**:

1. **Leader Election**
   - Apenas 1 Master ativo por vez
   - Failover automático se Master morrer

2. **Shared State**
   - Estado compartilhado via Redis

3. **Split Brain Protection**
   - Previne 2 Masters ativos

**Implementação**:

```php
'high_availability' => [
    'enabled' => true,
    'leader_election' => 'redis',  // redis, etcd
    'heartbeat_interval' => 5,
    'election_timeout' => 10,
],
```

---

### 10. Advanced Monitoring & Alerting

**Status**: Planejado
**Prioridade**: P2
**Complexidade**: Grande

**Funcionalidades**:

1. **Anomaly Detection**
   - Detecta comportamento anômalo automaticamente
   - Machine learning básico

2. **Smart Alerts**
   - Alertas baseados em padrões (não thresholds fixos)
   - Reduz falsos positivos

3. **Alerting Channels**
   - Email
   - Slack
   - PagerDuty
   - Webhook

**Implementação**:

```php
'alerting' => [
    'enabled' => true,

    'channels' => [
        'slack' => [
            'webhook_url' => env('SLACK_WEBHOOK'),
            'channel' => '#alerts',
        ],
        'pagerduty' => [
            'api_key' => env('PAGERDUTY_KEY'),
        ],
    ],

    'rules' => [
        'worker_died' => [
            'condition' => 'shutdown_reason == "fatal_error"',
            'severity' => 'critical',
            'channels' => ['slack', 'pagerduty'],
        ],
    ],
],
```

---

### 11. Job Scheduling / Cron Integration

**Status**: Planejado
**Prioridade**: P3
**Complexidade**: Média

**Descrição**: Agendar jobs recorrentes (similar ao Laravel Schedule).

**Funcionalidades**:

1. **Cron Syntax**
   ```php
   Schedule::job(new BackupDatabaseJob())->daily();
   Schedule::job(new CleanupJob())->everyFiveMinutes();
   ```

2. **Integration com QueueMaster**
   - Scheduler roda no Master
   - Dispatcha jobs nas filas certas

**Implementação**:

```php
// Modules/Common/Console/Kernel.php
protected function schedule(Schedule $schedule): void
{
    $schedule->job(new BackupDatabaseJob())
        ->daily()
        ->at('02:00')
        ->queue('maintenance');

    $schedule->job(new GenerateReportJob())
        ->weekdays()
        ->at('09:00')
        ->queue('reports');
}
```

---

### 12. Web UI Enhancements

**Status**: Planejado
**Prioridade**: P3
**Complexidade**: Média

**Descrição**: Melhorias no dashboard web.

**Features**:

1. **Real-time Updates**
   - WebSocket para updates ao vivo
   - Sem refresh necessário

2. **Worker Control**
   - Pausar/resumir worker via UI
   - Kill worker específico
   - Ver logs em tempo real

3. **Job Management**
   - Retry job falhado via UI
   - Cancel job em execução
   - Re-queue job

4. **Advanced Filtering**
   - Filtrar workers por múltiplos critérios
   - Salvar filtros customizados
   - Export para CSV/JSON

5. **Dark Mode**
   - Toggle dark/light mode

**Mockup**:

```
┌─────────────────────────────────────────┐
│ QueueMaster Dashboard    🌙 Dark Mode   │
├─────────────────────────────────────────┤
│ ┌─────┬─────┬─────┬─────┐              │
│ │ 10  │  3  │  7  │ 42  │              │
│ │Total│Proc │Idle │Jobs │              │
│ └─────┴─────┴─────┴─────┘              │
│                                         │
│ Workers (Real-time)                     │
│ ┌─────┬──────┬────────┬───────┬──────┐ │
│ │PID  │Status│Memory  │Jobs   │Action│ │
│ ├─────┼──────┼────────┼───────┼──────┤ │
│ │12345│ Proc │ 45MB   │ 67    │⏸️ ⏹️ │ │
│ │12346│ Idle │ 32MB   │ 42    │⏸️ ⏹️ │ │
│ └─────┴──────┴────────┴───────┴──────┘ │
└─────────────────────────────────────────┘
```

---

## Funcionalidades Canceladas

### Job Batching

**Motivo**: Laravel já tem implementação robusta de batching. Não vale duplicar esforço.

**Alternativa**: Usar `Bus::batch()` do Laravel.

---

## Como Contribuir

Se você quer trabalhar em alguma dessas features:

1. Abra issue no repositório descrevendo a implementação
2. Aguarde aprovação
3. Fork, implemente, teste
4. Abra Pull Request

## Priorização

Features são priorizadas baseado em:

1. **Impact**: Quantos usuários beneficiam
2. **Effort**: Esforço de implementação
3. **Risk**: Risco de quebrar funcionalidade existente
4. **Dependencies**: Depende de outras features

**Matriz de Priorização**:

```
High Impact, Low Effort = P0/P1
High Impact, High Effort = P1/P2
Low Impact, Low Effort = P2/P3
Low Impact, High Effort = P3 ou Cancelado
```

---

## Versionamento

Seguimos **Semantic Versioning** (semver.org):

- **Major** (2.0): Breaking changes
- **Minor** (1.1): New features, backward compatible
- **Patch** (1.0.1): Bug fixes

## Releases

- **Minor releases**: A cada 2-3 meses
- **Patch releases**: Conforme necessário
- **Major releases**: Anualmente

---

## Feedback

Sugestões de features? Abra issue com tag `[FEATURE REQUEST]`.

## Próximos Documentos

- **[DEVELOPMENT.md](DEVELOPMENT.md)** - Como desenvolver features
- **[ARCHITECTURE.md](ARCHITECTURE.md)** - Entender arquitetura atual
- **[CONFIGURATION.md](CONFIGURATION.md)** - Configurações disponíveis