# Prompts para Documentação - Framework OfficeGest

Este ficheiro contém os prompts completos para gerar documentação técnica das principais pastas do framework OfficeGest moderno.

## PROMPT 1: Sistema de Paginação

Você é um especialista em documentação técnica. Preciso que crie documentação completa e técnica da pasta **Modules/Common/Pagination/** do framework OfficeGest baseando-se APENAS no código real existente.

### CONTEXTO

O OfficeGest é um ERP PHP com um framework moderno em Modules/Common/ que convive com código legacy. Esta documentação faz parte de um conjunto maior que será montado por pastas. O sistema de Pagination é um sistema simples mas eficaz para gestão de listagens e resultados paginados.

### THINKING - ANÁLISE DA ESTRUTURA

Baseando-me na análise realizada, encontrei:
- **Paginator.php**: Classe principal que encapsula dados de paginação
- Integração com Query Builder legacy através do método `paginate()`
- Suporte a múltiplos formatos de output (Array, JSON, XML)
- Integração com sistema de requests para parâmetros de paginação

A arquitetura é simples mas eficaz:
1. Data Transfer Object Pattern para encapsulamento de dados
2. Serialization Pattern para múltiplos formatos de output
3. Template Method Pattern para geração de links

### INSTRUÇÕES ESPECÍFICAS

1. ANALISE APENAS a pasta Modules/Common/Pagination/ e seus subdiretórios
2. SEMPRE VERIFIQUE a pasta Modules/Common/Facades/ para identificar facades relacionadas (não existe facade específica)
3. IDENTIFIQUE integrações com Query Builder em `_files/database/DB_query_builder.php`
4. NÃO INVENTE NADA - Base-se exclusivamente no código fornecido
5. FOQUE NO ÚNICO - Explique o que é específico desta pasta, não conceitos genéricos
6. SEJA DIDÁTICO - Explique COMO e PORQUÊ, não apenas COMO USAR
7. EXEMPLOS REAIS - Use exemplos baseados no código real encontrado
8. ARQUITECTURA CLARA - Explique o padrão de design usado

### ESTRUTURA DESEJADA

```
# Sistema de Paginação - Framework OfficeGest

## Visão Geral do Sistema de Paginação
[Descrição da arquitetura simples mas eficaz - DTO pattern, serialization, template method]

## Arquitectura e Padrões de Design
[Explicar padrões: DTO, Serialization Pattern, Template Method Pattern]

## Estrutura e Componentes

### Classe Principal
[Documentar Paginator.php - propriedades, métodos, lógica de cálculo]

### Integração com Query Builder
[Como se integra com OGDB_query_builder através do método paginate()]

## Facades Disponíveis
[Não existe facade específica - usar diretamente via Query Builder ou instanciação]

## Integração com Sistema Legacy
[Como funciona com o Query Builder legacy e sistema de requests]

## Fluxo de Paginação
[Explicar: request → paginate → calcular → encapsular → serializar]

## Configuração e Extensibilidade
[Configuração per_page, personalização de links, etc.]

## Exemplos de Uso Real
[Baseados no código real - Query Builder, instanciação direta, DataTables]
```

### RESTRIÇÕES

- NÃO mencionar funcionalidades que não existem no código
- NÃO assumir padrões standard sem verificar a implementação
- NÃO incluir código de outras pastas (apenas referências se necessário)

Salve o resultado em **_docs/og-framework/pagination-system.md**.

---

## PROMPT 2: Sistema de Providers

Você é um especialista em documentação técnica. Preciso que crie documentação completa e técnica da pasta **Modules/Common/Providers/** do framework OfficeGest baseando-se APENAS no código real existente.

### CONTEXTO

O OfficeGest é um ERP PHP com um framework moderno em Modules/Common/ que convive com código legacy. Esta documentação faz parte de um conjunto maior que será montado por pastas. O sistema de Providers é FUNDAMENTAL - é o coração do sistema de DI (Dependency Injection) que regista todos os serviços no container.

### THINKING - ANÁLISE DA ESTRUTURA

Esta é a pasta mais importante do framework moderno. Encontrei:
- **ServiceProvider.php**: Classe abstrata base com métodos register() e boot()
- **ServiceProviderInterface.php**: Interface (atualmente vazia)
- **ServiceProviderManager.php**: Gestor que regista e inicializa providers

Providers identificados no sistema:
- **GlobalServiceProvider**: Serviços legacy (database, user, session, app, etc.)
- **QueueServiceProvider**: Sistema completo de queues (Redis, RabbitMQ, locks, batches)
- **RoutingServiceProvider**: Router, middleware, URL generator
- **CacheServiceProvider, RedisServiceProvider, ValidationServiceProvider**, etc.

A arquitetura inclui:
1. Service Provider Pattern (inspirado no Laravel)
2. Dependency Injection Pattern
3. Registry Pattern para gestão de providers
4. Bootstrap Pattern para inicialização duas fases
5. Factory Pattern para criação de serviços

### INSTRUÇÕES ESPECÍFICAS

1. ANALISE APENAS a pasta Modules/Common/Providers/ e seus ficheiros
2. IDENTIFIQUE a hierarquia de providers e ordem de registo via Container.php
3. MAPEIE que serviços cada provider regista (especialmente GlobalServiceProvider e QueueServiceProvider)
4. DOCUMENTE o ciclo de vida: register() vs boot(), duas fases de inicialização
5. EXPLIQUE a integração com o Container/DI
6. NÃO INVENTE NADA - Base-se exclusivamente no código fornecido
7. FOQUE NA ARQUITECTURA - Como o sistema todo se inicia
8. SEJA DIDÁTICO - Explique a ordem de execução e dependências
9. EXEMPLOS REAIS - Use providers reais encontrados

### ESTRUTURA DESEJADA

```
# Sistema de Service Providers - Framework OfficeGest

## Visão Geral do Sistema de Providers
[Descrição do papel central dos providers no framework - DI, bootstrap, lifecycle]

## Arquitectura e Padrões de Design
[Service Provider Pattern, DI Pattern, Registry Pattern, Bootstrap Pattern]

## Estrutura e Componentes

### ServiceProvider Base
[Classe abstrata, métodos register() vs boot(), ciclo de vida]

### ServiceProviderInterface
[Interface (atualmente vazia mas extensível)]

### ServiceProviderManager
[Gestor central - registo, boot, controlo de duplicados, error handling]

## Providers Específicos

### GlobalServiceProvider (Crítico)
[Ponte legacy - database, user, session, app, hooks, etc. - mapeamento completo]

### QueueServiceProvider
[Sistema completo de queues - drivers, locks, batches, monitoring]

### RoutingServiceProvider
[Router, middleware, URL generator, route cache]

### Outros Providers
[Cache, Redis, Validation, View, Notifications, etc.]

## Lifecycle e Bootstrap

### Ordem de Execução
[Container → ServiceProviderManager → register all → boot all]

### Fases de Inicialização
[1. register() - registo de serviços, 2. boot() - inicialização com dependências]

### Gestão de Dependências
[Como providers dependem uns dos outros, singletons vs transients]

## Integração com Container DI
[Como providers registam no Container, binding types, quando/como]

## Fluxo de Inicialização Completo
[Do Container constructor até sistema totalmente funcional - step by step]

## Extensibilidade
[Como criar novos providers, best practices, integração com sistema existente]
```

### RESTRIÇÕES CRÍTICAS

- Esta é a documentação mais importante - seja extremamente preciso
- NÃO assumir estrutura sem verificar o código
- DOCUMENTE a ordem exacta de execução (Container.php linha 138-152)
- EXPLIQUE as dependências entre providers
- MAPEIE detalhadamente que serviços são registados onde

Salve o resultado em **_docs/og-framework/service-providers-system.md**.

---

### OBJECTIVO GERAL

Criar documentação técnica DEFINITIVA destas duas pastas fundamentais do framework OfficeGest. A documentação de Providers é especialmente crítica pois define como todo o sistema moderno funciona.

### TOM E ESTILO COMUM

- Português de Portugal
- Extremamente técnico e detalhado
- Focado na arquitectura interna
- Essencial para developers que querem entender o framework
- Preparado para ser referência principal
- Usar exemplos baseados no código real
- Explicar COMO, PORQUÊ e QUANDO usar

### NOTAS FINAIS

Use o TodoWrite para planear e acompanhar o progresso de cada documentação. Estas são documentações críticas que definem como o framework moderno funciona - tome tempo extra para análise profunda e precisão técnica.