import './bootstrap';

// Auto-detect system dark mode preference and apply dark class if needed
const initDarkMode = () => {
    const html = document.documentElement;

    // Check if Flux has already set a preference (via localStorage or similar)
    // If not, respect system preference
    const fluxAppearance = localStorage.getItem('flux-appearance');

    if (!fluxAppearance || fluxAppearance === 'system') {
        if (window.matchMedia('(prefers-color-scheme: dark)').matches) {
            html.classList.add('dark');
        } else {
            html.classList.remove('dark');
        }
    }

    // Listen for system preference changes
    window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', (e) => {
        const currentFluxAppearance = localStorage.getItem('flux-appearance');
        if (!currentFluxAppearance || currentFluxAppearance === 'system') {
            if (e.matches) {
                html.classList.add('dark');
            } else {
                html.classList.remove('dark');
            }
        }
    });
};

const applyPrismTheme = () => {
    const rootIsDark = document.documentElement.classList.contains('dark');
    const lightSheet = document.getElementById('prism-light');
    const darkSheet = document.getElementById('prism-dark');

    if (lightSheet) {
        lightSheet.disabled = rootIsDark;
    }

    if (darkSheet) {
        darkSheet.disabled = !rootIsDark;
    }
};

if (typeof document !== 'undefined') {
    // Initialize dark mode before DOMContentLoaded to prevent flash
    initDarkMode();

    document.addEventListener('DOMContentLoaded', applyPrismTheme);

    const observer = new MutationObserver(() => applyPrismTheme());
    observer.observe(document.documentElement, { attributes: true, attributeFilter: ['class'] });
}

