@extends('layouts.docs')

@section('title', 'Bootstrap - OG Framework')

@section('body')
    <div class="relative min-h-screen bg-transparent px-4 pb-12 pt-6 sm:px-6 lg:px-8">
        <div class="floating-blur blue -left-10 -top-10 hidden lg:block"></div>
        <div class="floating-blur amber right-10 top-32 hidden lg:block"></div>

        <div class="mx-auto flex w-full max-w-7xl gap-8 bg-transparent">
            {{-- Left Sidebar: Navigation --}}
            @include('docs.partials.sidebar')

            {{-- Main Content --}}
            <div class="flex-1 min-w-0">
                <div class="relative overflow-hidden rounded-3xl border border-white/50 bg-white/85 p-8 shadow-xl shadow-primary/20 backdrop-blur dark:border-zinc-800 dark:bg-zinc-900/80">

                    {{-- Page Header --}}
                    <div class="mb-8">
                        <a href="{{ route('docs.index') }}" class="inline-flex items-center gap-1 text-sm text-primary hover:underline mb-4">
                            <flux:icon.arrow-left class="size-4" />
                            Voltar para Documentação
                        </a>
                        <p class="text-xs uppercase tracking-[0.3em] text-primary dark:text-blue-200">Arquitetura</p>
                        <h1 class="font-display text-4xl font-bold text-zinc-900 dark:text-white sm:text-5xl">Sistema de Bootstrap</h1>
                        <p class="mt-3 text-base text-zinc-700 dark:text-zinc-200 max-w-3xl">
                            O OG Framework utiliza um sistema híbrido de bootstrap que suporta múltiplos pontos de entrada — web, AJAX, CLI e cron — cada um com seu próprio fluxo otimizado mas compartilhando componentes comuns.
                        </p>
                    </div>

                    <div class="space-y-10">

                        {{-- Entry Points Overview --}}
                        <section id="pontos-de-entrada" class="scroll-mt-28 space-y-4">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.arrow-right-start-on-rectangle class="size-6 text-primary" />
                                    Pontos de Entrada
                                </h2>
                                <p class="text-zinc-700 dark:text-zinc-300">
                                    O sistema escolhe automaticamente o bootstrapper correto baseado no contexto de execução:
                                </p>
                            </div>

                            <div class="grid gap-4 md:grid-cols-2 lg:grid-cols-3">
                                <div class="feature-card">
                                    <div class="flex items-center gap-2 mb-2">
                                        <flux:icon.globe-alt class="size-5 text-blue-500" />
                                        <p class="font-mono text-sm font-semibold text-zinc-900 dark:text-white">index.php</p>
                                    </div>
                                    <p class="text-sm text-zinc-700 dark:text-zinc-300">Controlador frontal HTTP. Bootstrap completo com autenticação e views.</p>
                                </div>
                                <div class="feature-card">
                                    <div class="flex items-center gap-2 mb-2">
                                        <flux:icon.arrow-path class="size-5 text-green-500" />
                                        <p class="font-mono text-sm font-semibold text-zinc-900 dark:text-white">AjaxServer.php</p>
                                    </div>
                                    <p class="text-sm text-zinc-700 dark:text-zinc-300">AJAX otimizado com <code>DEFERRED_INIT</code> — carrega BD só quando necessário.</p>
                                </div>
                                <div class="feature-card">
                                    <div class="flex items-center gap-2 mb-2">
                                        <flux:icon.command-line class="size-5 text-amber-500" />
                                        <p class="font-mono text-sm font-semibold text-zinc-900 dark:text-white">./og</p>
                                    </div>
                                    <p class="text-sm text-zinc-700 dark:text-zinc-300">CLI Symfony Console. Boot mínimo ou completo conforme comando.</p>
                                </div>
                                <div class="feature-card">
                                    <div class="flex items-center gap-2 mb-2">
                                        <flux:icon.clock class="size-5 text-purple-500" />
                                        <p class="font-mono text-sm font-semibold text-zinc-900 dark:text-white">cron.php</p>
                                    </div>
                                    <p class="text-sm text-zinc-700 dark:text-zinc-300">Tarefas agendadas. Memory/time unlimited, multi-tenant.</p>
                                </div>
                                <div class="feature-card">
                                    <div class="flex items-center gap-2 mb-2">
                                        <flux:icon.arrow-down-tray class="size-5 text-cyan-500" />
                                        <p class="font-mono text-sm font-semibold text-zinc-900 dark:text-white">download.php</p>
                                    </div>
                                    <p class="text-sm text-zinc-700 dark:text-zinc-300">Streaming de arquivos com controle de acesso.</p>
                                </div>
                                <div class="feature-card">
                                    <div class="flex items-center gap-2 mb-2">
                                        <flux:icon.photo class="size-5 text-pink-500" />
                                        <p class="font-mono text-sm font-semibold text-zinc-900 dark:text-white">upload.php</p>
                                    </div>
                                    <p class="text-sm text-zinc-700 dark:text-zinc-300">Imagens com transformações (watermark, resize).</p>
                                </div>
                            </div>
                        </section>

                        {{-- FLOW: HTTP/Web --}}
                        <section id="fluxo-http" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.globe-alt class="size-6 text-blue-500" />
                                    Fluxo HTTP/Web Completo
                                </h2>
                                <p class="text-zinc-700 dark:text-zinc-300">
                                    O bootstrap web é o mais completo, passando por todas as fases de inicialização:
                                </p>
                            </div>

                            <div class="rounded-xl bg-gradient-to-br from-zinc-900 to-zinc-950 p-6 overflow-x-auto">
                                <svg viewBox="0 0 700 480" class="w-full max-w-3xl mx-auto" xmlns="http://www.w3.org/2000/svg">
                                    <defs>
                                        <linearGradient id="httpGradient" x1="0%" y1="0%" x2="0%" y2="100%">
                                            <stop offset="0%" style="stop-color:#3b82f6;stop-opacity:1" />
                                            <stop offset="100%" style="stop-color:#8b5cf6;stop-opacity:1" />
                                        </linearGradient>
                                        <filter id="httpGlow">
                                            <feGaussianBlur stdDeviation="2" result="coloredBlur"/>
                                            <feMerge><feMergeNode in="coloredBlur"/><feMergeNode in="SourceGraphic"/></feMerge>
                                        </filter>
                                    </defs>

                                    <!-- Step 1: HTTP Request -->
                                    <rect x="250" y="10" width="200" height="36" rx="6" fill="#1e40af" stroke="#3b82f6" stroke-width="2"/>
                                    <text x="350" y="33" fill="white" font-family="ui-monospace, monospace" font-size="12" text-anchor="middle" font-weight="600">1. Requisição HTTP</text>
                                    <line x1="350" y1="46" x2="350" y2="58" stroke="url(#httpGradient)" stroke-width="2"/>
                                    <polygon points="350,65 344,58 356,58" fill="#8b5cf6"/>

                                    <!-- Step 2: .htaccess -->
                                    <rect x="250" y="65" width="200" height="36" rx="6" fill="#1e3a5f" stroke="#3b82f6" stroke-width="2"/>
                                    <text x="350" y="88" fill="#93c5fd" font-family="ui-monospace, monospace" font-size="11" text-anchor="middle">2. .htaccess → index.php</text>
                                    <line x1="350" y1="101" x2="350" y2="113" stroke="url(#httpGradient)" stroke-width="2"/>
                                    <polygon points="350,120 344,113 356,113" fill="#8b5cf6"/>

                                    <!-- Step 3: index.php -->
                                    <rect x="220" y="120" width="260" height="50" rx="6" fill="#78350f" stroke="#f59e0b" stroke-width="2"/>
                                    <text x="350" y="140" fill="#fcd34d" font-family="ui-monospace, monospace" font-size="11" text-anchor="middle" font-weight="600">3. index.php</text>
                                    <text x="350" y="158" fill="#fde68a" font-family="ui-monospace, monospace" font-size="9" text-anchor="middle">require '_files/init.php'</text>
                                    <line x1="350" y1="170" x2="350" y2="182" stroke="url(#httpGradient)" stroke-width="2"/>
                                    <polygon points="350,189 344,182 356,182" fill="#8b5cf6"/>

                                    <!-- Step 4: init.php + bootstrap -->
                                    <rect x="180" y="189" width="340" height="65" rx="6" fill="#14532d" stroke="#22c55e" stroke-width="2"/>
                                    <text x="350" y="210" fill="#86efac" font-family="ui-monospace, monospace" font-size="11" text-anchor="middle" font-weight="600">4. init.php</text>
                                    <text x="350" y="226" fill="#bbf7d0" font-family="ui-monospace, monospace" font-size="9" text-anchor="middle">$app = require 'bootstrap.php' → Container DI</text>
                                    <text x="350" y="242" fill="#bbf7d0" font-family="ui-monospace, monospace" font-size="9" text-anchor="middle">new ApplicationBootstrapper()</text>
                                    <line x1="350" y1="254" x2="350" y2="266" stroke="url(#httpGradient)" stroke-width="2"/>
                                    <polygon points="350,273 344,266 356,266" fill="#8b5cf6"/>

                                    <!-- Step 5: init_1 -->
                                    <rect x="220" y="273" width="120" height="45" rx="6" fill="#78350f" stroke="#f59e0b" stroke-width="2"/>
                                    <text x="280" y="293" fill="#fcd34d" font-family="ui-monospace, monospace" font-size="10" text-anchor="middle" font-weight="600">init_1()</text>
                                    <text x="280" y="308" fill="#fde68a" font-family="ui-monospace, monospace" font-size="8" text-anchor="middle">Segurança</text>

                                    <!-- Arrow between init phases -->
                                    <line x1="340" y1="295" x2="355" y2="295" stroke="#f59e0b" stroke-width="2"/>
                                    <polygon points="362,295 355,290 355,300" fill="#f59e0b"/>

                                    <!-- Step 6: init_2 -->
                                    <rect x="362" y="273" width="120" height="45" rx="6" fill="#14532d" stroke="#22c55e" stroke-width="2"/>
                                    <text x="422" y="293" fill="#86efac" font-family="ui-monospace, monospace" font-size="10" text-anchor="middle" font-weight="600">init_2()</text>
                                    <text x="422" y="308" fill="#bbf7d0" font-family="ui-monospace, monospace" font-size="8" text-anchor="middle">Database/Redis</text>

                                    <!-- Arrow down from init_2 -->
                                    <line x1="350" y1="318" x2="350" y2="335" stroke="url(#httpGradient)" stroke-width="2"/>
                                    <polygon points="350,342 344,335 356,335" fill="#8b5cf6"/>

                                    <!-- Step 7: Hooks -->
                                    <rect x="250" y="342" width="200" height="36" rx="6" fill="#4c1d95" stroke="#a855f7" stroke-width="2"/>
                                    <text x="350" y="365" fill="#d8b4fe" font-family="ui-monospace, monospace" font-size="10" text-anchor="middle">Hooks: init_1 → init_2</text>
                                    <line x1="350" y1="378" x2="350" y2="390" stroke="url(#httpGradient)" stroke-width="2"/>
                                    <polygon points="350,397 344,390 356,390" fill="#8b5cf6"/>

                                    <!-- Step 8: Routing -->
                                    <rect x="250" y="397" width="200" height="36" rx="6" fill="#1e40af" stroke="#3b82f6" stroke-width="2" filter="url(#httpGlow)"/>
                                    <text x="350" y="420" fill="white" font-family="ui-monospace, monospace" font-size="11" text-anchor="middle" font-weight="600">Routing → Controller → Response</text>

                                    <!-- Labels -->
                                    <text x="30" y="33" fill="#6b7280" font-size="10">Request</text>
                                    <text x="30" y="145" fill="#6b7280" font-size="10">Entry Point</text>
                                    <text x="30" y="220" fill="#6b7280" font-size="10">Bootstrap</text>
                                    <text x="30" y="295" fill="#6b7280" font-size="10">Fases</text>
                                    <text x="30" y="420" fill="#6b7280" font-size="10">Response</text>
                                </svg>
                            </div>
                        </section>

                        {{-- init_1 vs init_2 --}}
                        <section id="fases-inicializacao" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.list-bullet class="size-6 text-primary" />
                                    Fases de Inicialização
                                </h2>
                                <p class="text-zinc-700 dark:text-zinc-300">
                                    O <code>ApplicationBootstrapper</code> divide a inicialização em duas fases distintas:
                                </p>
                            </div>

                            <div class="grid gap-4 md:grid-cols-2">
                                <div class="feature-card border-l-4 border-amber-500">
                                    <p class="font-mono text-sm font-semibold text-amber-600 dark:text-amber-400">init_1() — Fase de Segurança</p>
                                    <ul class="text-sm text-zinc-700 dark:text-zinc-300 mt-2 space-y-1 list-disc list-inside">
                                        <li><code>sanitizeInputVars()</code> — Escapa inputs maliciosos</li>
                                        <li><code>loadRebranding()</code> — White-label configs</li>
                                        <li><code>checkDefinedVars()</code> — Valida paths essenciais</li>
                                        <li><code>load_config()</code> — Carrega config.php</li>
                                        <li><code>set_php_settings()</code> — Timezone, locale, error level</li>
                                        <li><code>spl_autoload_register()</code> — Autoloader legacy</li>
                                    </ul>
                                </div>
                                <div class="feature-card border-l-4 border-green-500">
                                    <p class="font-mono text-sm font-semibold text-green-600 dark:text-green-400">init_2() — Fase de Dados</p>
                                    <ul class="text-sm text-zinc-700 dark:text-zinc-300 mt-2 space-y-1 list-disc list-inside">
                                        <li><code>databaseConnect()</code> — Conexão MySQL (crítico)</li>
                                        <li><code>initialize_redis()</code> — Client Redis</li>
                                        <li><code>loadRequiredModules()</code> — Módulos core</li>
                                        <li><code>loadLanguage()</code> — i18n baseado em sessão</li>
                                        <li><code>loadModules()</code> — Todos os módulos ativos</li>
                                        <li><code>load_addons()</code> — Plugins de terceiros</li>
                                    </ul>
                                </div>
                            </div>
                        </section>

                        {{-- FLOW: CLI --}}
                        <section id="fluxo-cli" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.command-line class="size-6 text-amber-500" />
                                    Fluxo CLI (./og)
                                </h2>
                                <p class="text-zinc-700 dark:text-zinc-300">
                                    O CLI usa o <code>CliBootstrapper</code> com três níveis de inicialização conforme a complexidade do comando:
                                </p>
                            </div>

                            <div class="rounded-xl bg-gradient-to-br from-zinc-900 to-zinc-950 p-6 overflow-x-auto">
                                <svg viewBox="0 0 700 450" class="w-full max-w-3xl mx-auto" xmlns="http://www.w3.org/2000/svg">
                                    <defs>
                                        <linearGradient id="cliGradient" x1="0%" y1="0%" x2="0%" y2="100%">
                                            <stop offset="0%" style="stop-color:#f59e0b;stop-opacity:1" />
                                            <stop offset="100%" style="stop-color:#f59e0b;stop-opacity:1" />
                                        </linearGradient>
                                    </defs>

                                    <!-- Step 1: Default Entry -->
                                    <rect x="250" y="10" width="200" height="30" rx="6" fill="#1e3a5f" stroke="#3b82f6" stroke-width="2"/>
                                    <text x="350" y="30" fill="white" font-family="ui-monospace, monospace" font-size="11" text-anchor="middle" font-weight="600">./og &lt;comando&gt;</text>
                                    
                                    <line x1="350" y1="40" x2="350" y2="55" stroke="#475569" stroke-width="2"/>
                                    
                                    <!-- Step 2: Environment Setup -->
                                    <rect x="220" y="55" width="260" height="90" rx="6" fill="#1e293b" stroke="#475569" stroke-width="1" stroke-dasharray="4 4"/>
                                    <text x="350" y="75" fill="#94a3b8" font-family="ui-monospace, monospace" font-size="10" text-anchor="middle">Setup Inicial</text>
                                    <text x="240" y="95" fill="#cbd5e1" font-family="ui-monospace, monospace" font-size="10">• SAPI Validation (cli)</text>
                                    <text x="240" y="110" fill="#cbd5e1" font-family="ui-monospace, monospace" font-size="10">• require 'vendor/autoload.php'</text>
                                    <text x="240" y="125" fill="#cbd5e1" font-family="ui-monospace, monospace" font-size="10">• Dotenv::safeLoad()</text>

                                    <!-- Arrow to Decision -->
                                    <line x1="350" y1="145" x2="350" y2="165" stroke="#475569" stroke-width="2"/>
                                    <polygon points="350,175 344,165 356,165" fill="#475569"/>

                                    <!-- Decision Diamond -->
                                    <path d="M 350 175 L 420 205 L 350 235 L 280 205 Z" fill="#451a03" stroke="#f59e0b" stroke-width="2"/>
                                    <text x="350" y="200" fill="#fbbf24" font-family="ui-monospace, monospace" font-size="10" text-anchor="middle" font-weight="600">Tipo de Comando?</text>
                                    <text x="350" y="215" fill="#fcd34d" font-family="ui-monospace, monospace" font-size="9" text-anchor="middle">(precisa contexto?)</text>

                                    <!-- Branch Left: Simple -->
                                    <line x1="280" y1="205" x2="180" y2="205" stroke="#22c55e" stroke-width="2"/>
                                    <line x1="180" y1="205" x2="180" y2="235" stroke="#22c55e" stroke-width="2"/>
                                    <polygon points="180,245 174,235 186,235" fill="#22c55e"/>

                                    <rect x="80" y="245" width="200" height="120" rx="6" fill="#14532d" stroke="#22c55e" stroke-width="2"/>
                                    <text x="180" y="265" fill="#86efac" font-family="ui-monospace, monospace" font-size="11" text-anchor="middle" font-weight="600">Simples</text>
                                    <text x="180" y="280" fill="#bbf7d0" font-family="ui-monospace, monospace" font-size="9" text-anchor="middle">(sem BD/app)</text>
                                    
                                    <line x1="100" y1="290" x2="260" y2="290" stroke="#22c55e" stroke-width="1" stroke-opacity="0.5"/>
                                    
                                    <text x="100" y="310" fill="#bbf7d0" font-family="ui-monospace, monospace" font-size="10">• Container::getInstance()</text>
                                    <text x="100" y="325" fill="#bbf7d0" font-family="ui-monospace, monospace" font-size="10">• $container→boot()</text>
                                    <text x="100" y="340" fill="#bbf7d0" font-family="ui-monospace, monospace" font-size="10">• CLIApplication→run()</text>

                                    <!-- Branch Right: Complex -->
                                    <line x1="420" y1="205" x2="520" y2="205" stroke="#ef4444" stroke-width="2"/>
                                    <line x1="520" y1="205" x2="520" y2="235" stroke="#ef4444" stroke-width="2"/>
                                    <polygon points="520,245 514,235 526,235" fill="#ef4444"/>

                                    <rect x="420" y="245" width="200" height="160" rx="6" fill="#450a0a" stroke="#ef4444" stroke-width="2"/>
                                    <text x="520" y="265" fill="#fca5a5" font-family="ui-monospace, monospace" font-size="11" text-anchor="middle" font-weight="600">Complexo</text>
                                    <text x="520" y="280" fill="#fecaca" font-family="ui-monospace, monospace" font-size="9" text-anchor="middle">(load full app)</text>
                                    
                                    <line x1="440" y1="290" x2="600" y2="290" stroke="#ef4444" stroke-width="1" stroke-opacity="0.5"/>
                                    
                                    <text x="440" y="310" fill="#fecaca" font-family="ui-monospace, monospace" font-size="10">• require 'bootstrap.php'</text>
                                    <text x="440" y="325" fill="#fecaca" font-family="ui-monospace, monospace" font-size="10">• ensureDatabaseConnection()</text>
                                    <text x="440" y="340" fill="#fecaca" font-family="ui-monospace, monospace" font-size="10">• $cli→boot()</text>
                                    <text x="440" y="355" fill="#fecaca" font-family="ui-monospace, monospace" font-size="10">• $cli→end()</text>
                                    <text x="440" y="370" fill="#fecaca" font-family="ui-monospace, monospace" font-size="10">• CLIApplication→run()</text>

                                </svg>
                            </div>

                            {{-- CliBootstrapper methods --}}
                            <div class="rounded-xl border-l-4 border-amber-500 bg-amber-50 dark:bg-amber-900/20 p-4 mt-4">
                                <div class="flex items-center gap-2 mb-2">
                                    <flux:icon.cog-6-tooth class="size-5 text-amber-600 dark:text-amber-400" />
                                    <p class="font-semibold text-amber-800 dark:text-amber-200">Métodos do CliBootstrapper</p>
                                </div>
                                <div class="grid gap-3 md:grid-cols-3 mt-3">
                                    <div class="text-sm">
                                        <p class="font-mono font-semibold text-amber-700 dark:text-amber-300">boot()</p>
                                        <p class="text-amber-900 dark:text-amber-100 text-xs">Inicialização básica. Carrega configs, não conecta ao BD ainda.</p>
                                    </div>
                                    <div class="text-sm">
                                        <p class="font-mono font-semibold text-amber-700 dark:text-amber-300">ensureDatabaseConnection()</p>
                                        <p class="text-amber-900 dark:text-amber-100 text-xs">Conecta ao BD sob demanda. Flag evita reconexão.</p>
                                    </div>
                                    <div class="text-sm">
                                        <p class="font-mono font-semibold text-amber-700 dark:text-amber-300">end()</p>
                                        <p class="text-amber-900 dark:text-amber-100 text-xs">Cleanup. Fecha conexões, limpa estado.</p>
                                    </div>
                                </div>
                            </div>

                            {{-- CLI Code Example --}}
                            <div class="rounded-xl bg-zinc-950 p-4 text-sm overflow-x-auto mt-4">
                                <pre class="language-php"><code>// Exemplo: Comando que precisa de BD
class MigrateCommand extends Command
{
    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        // O CliBootstrapper já garantiu a conexão!
        $db = app('database');

        // Executa migrations
        $migrator = app(Migrator::class);
        $migrator->run();

        return Command::SUCCESS;
    }
}</code></pre>
                            </div>
                        </section>

                        {{-- FLOW: AJAX --}}
                        <section id="fluxo-ajax" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.arrow-path class="size-6 text-green-500" />
                                    Fluxo AJAX (AjaxServer.php)
                                </h2>
                                <p class="text-zinc-700 dark:text-zinc-300">
                                    O AJAX usa <strong>inicialização diferida</strong> — a fase <code>init_2()</code> só executa quando realmente necessário:
                                </p>
                            </div>

                            <div class="rounded-xl bg-gradient-to-br from-zinc-900 to-zinc-950 p-6 overflow-x-auto">
                                <svg viewBox="0 0 700 480" class="w-full max-w-3xl mx-auto" xmlns="http://www.w3.org/2000/svg">
                                    <defs>
                                        <linearGradient id="ajaxGradient" x1="0%" y1="0%" x2="0%" y2="100%">
                                            <stop offset="0%" style="stop-color:#22c55e;stop-opacity:1" />
                                            <stop offset="100%" style="stop-color:#22c55e;stop-opacity:1" />
                                        </linearGradient>
                                        <filter id="deferredGlow">
                                            <feGaussianBlur stdDeviation="3" result="coloredBlur"/>
                                            <feMerge><feMergeNode in="coloredBlur"/><feMergeNode in="SourceGraphic"/></feMerge>
                                        </filter>
                                    </defs>

                                    <!-- Step 1: Request -->
                                    <rect x="250" y="10" width="200" height="30" rx="6" fill="#1e40af" stroke="#3b82f6" stroke-width="2"/>
                                    <text x="350" y="30" fill="white" font-family="ui-monospace, monospace" font-size="11" text-anchor="middle" font-weight="600">POST /ajaxserver/action</text>
                                    
                                    <line x1="350" y1="40" x2="350" y2="55" stroke="#475569" stroke-width="2"/>
                                    <polygon points="350,65 344,55 356,55" fill="#475569"/>

                                    <!-- Step 2: AjaxServer Entry -->
                                    <rect x="220" y="65" width="260" height="60" rx="6" fill="#14532d" stroke="#22c55e" stroke-width="2"/>
                                    <text x="350" y="85" fill="#86efac" font-family="ui-monospace, monospace" font-size="11" text-anchor="middle" font-weight="600">AjaxServer.php</text>
                                    <text x="350" y="105" fill="#bbf7d0" font-family="ui-monospace, monospace" font-size="10" text-anchor="middle">define('DEFERRED_INIT', true)</text>
                                    
                                    <line x1="350" y1="125" x2="350" y2="145" stroke="#475569" stroke-width="2"/>
                                    <polygon points="350,155 344,145 356,145" fill="#475569"/>

                                    <!-- Step 3: init_1 only -->
                                    <rect x="250" y="155" width="200" height="40" rx="6" fill="#78350f" stroke="#f59e0b" stroke-width="2"/>
                                    <text x="350" y="180" fill="#fcd34d" font-family="ui-monospace, monospace" font-size="11" text-anchor="middle">$OG_Init→init_1() Only</text>
                                    
                                    <line x1="350" y1="195" x2="350" y2="215" stroke="#475569" stroke-width="2"/>

                                    <!-- Step 4: Action Parsing -->
                                    <rect x="250" y="215" width="200" height="30" rx="6" fill="#4c1d95" stroke="#a855f7" stroke-width="2"/>
                                    <text x="350" y="235" fill="#e9d5ff" font-family="ui-monospace, monospace" font-size="10" text-anchor="middle">Parse Action Name</text>

                                    <line x1="350" y1="245" x2="350" y2="265" stroke="#475569" stroke-width="2"/>
                                    <polygon points="350,275 344,265 356,265" fill="#475569"/>

                                    <!-- Decision: Needs DB? -->
                                    <path d="M 350 275 L 420 305 L 350 335 L 280 305 Z" fill="#1e293b" stroke="#94a3b8" stroke-width="2"/>
                                    <text x="350" y="300" fill="#f1f5f9" font-family="ui-monospace, monospace" font-size="10" text-anchor="middle" font-weight="600">Precisa BD?</text>
                                    <text x="350" y="315" fill="#cbd5e1" font-family="ui-monospace, monospace" font-size="9" text-anchor="middle">(AjaxRegistry)</text>

                                    <!-- Branch Left: Yes (init_2) -->
                                    <line x1="280" y1="305" x2="200" y2="305" stroke="#22c55e" stroke-width="2"/>
                                    <line x1="200" y1="305" x2="200" y2="335" stroke="#22c55e" stroke-width="2"/>
                                    <polygon points="200,345 194,335 206,335" fill="#22c55e"/>

                                    <rect x="140" y="345" width="120" height="40" rx="6" fill="#14532d" stroke="#22c55e" stroke-width="2" filter="url(#deferredGlow)"/>
                                    <text x="200" y="370" fill="#86efac" font-family="ui-monospace, monospace" font-size="11" text-anchor="middle" font-weight="600">Run init_2()</text>

                                    <line x1="200" y1="385" x2="200" y2="415" stroke="#22c55e" stroke-width="1" stroke-dasharray="4 4"/>
                                    <line x1="200" y1="415" x2="320" y2="415" stroke="#22c55e" stroke-width="1" stroke-dasharray="4 4"/>

                                    <!-- Branch Right: No -->
                                    <line x1="420" y1="305" x2="500" y2="305" stroke="#94a3b8" stroke-width="2"/>
                                    <line x1="500" y1="305" x2="500" y2="395" stroke="#94a3b8" stroke-width="2"/>
                                    <line x1="500" y1="395" x2="380" y2="395" stroke="#94a3b8" stroke-width="2"/>
                                    <polygon points="380,395 385,390 385,400" fill="#94a3b8"/>

                                    <text x="505" y="350" fill="#94a3b8" font-family="ui-monospace, monospace" font-size="10">Skip init_2</text>
                                    <text x="505" y="365" fill="#94a3b8" font-family="ui-monospace, monospace" font-size="10">(Fast path)</text>

                                    <!-- Final Execution -->
                                    <rect x="250" y="400" width="200" height="50" rx="6" fill="#831843" stroke="#ec4899" stroke-width="2"/>
                                    <text x="350" y="420" fill="#fbcfe8" font-family="ui-monospace, monospace" font-size="11" text-anchor="middle" font-weight="600">new AjaxServer($action)</text>
                                    <text x="350" y="438" fill="#fce7f3" font-family="ui-monospace, monospace" font-size="11" text-anchor="middle">$this->$action()</text>

                                </svg>
                            </div>

                            <div class="rounded-xl border-l-4 border-green-500 bg-green-50 dark:bg-green-900/20 p-4 mt-4">
                                <div class="flex items-center gap-2 mb-2">
                                    <flux:icon.bolt class="size-5 text-green-600 dark:text-green-400" />
                                    <p class="font-semibold text-green-800 dark:text-green-200">Por que DEFERRED_INIT?</p>
                                </div>
                                <p class="text-sm text-green-900 dark:text-green-100">
                                    Muitas chamadas AJAX não precisam de conexão ao BD (ex: validação de formulários, cálculos client-side). O <code>DEFERRED_INIT</code> economiza ~50ms por request ao pular a inicialização do banco de dados até que seja realmente necessário.
                                </p>
                            </div>
                        </section>

                        {{-- Bootstrap Comparison Table --}}
                        <section id="comparativo" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.scale class="size-6 text-purple-500" />
                                    Comparativo de Bootstrappers
                                </h2>
                            </div>

                            <div class="overflow-x-auto">
                                <table class="w-full text-sm text-left">
                                    <thead class="text-xs uppercase bg-zinc-100 dark:bg-zinc-800">
                                        <tr>
                                            <th class="px-4 py-3 text-zinc-700 dark:text-zinc-300">Aspecto</th>
                                            <th class="px-4 py-3 text-blue-600 dark:text-blue-400">ApplicationBootstrapper</th>
                                            <th class="px-4 py-3 text-amber-600 dark:text-amber-400">CliBootstrapper</th>
                                        </tr>
                                    </thead>
                                    <tbody class="divide-y divide-zinc-200 dark:divide-zinc-700">
                                        <tr class="bg-white dark:bg-zinc-900">
                                            <td class="px-4 py-3 font-medium">Contexto</td>
                                            <td class="px-4 py-3">HTTP/Web</td>
                                            <td class="px-4 py-3">Terminal/CLI</td>
                                        </tr>
                                        <tr class="bg-zinc-50 dark:bg-zinc-800/50">
                                            <td class="px-4 py-3 font-medium">Fases</td>
                                            <td class="px-4 py-3"><code>init_1()</code> + <code>init_2()</code></td>
                                            <td class="px-4 py-3"><code>boot()</code> + <code>ensureDatabaseConnection()</code> + <code>end()</code></td>
                                        </tr>
                                        <tr class="bg-white dark:bg-zinc-900">
                                            <td class="px-4 py-3 font-medium">Sessão</td>
                                            <td class="px-4 py-3">✅ session_start()</td>
                                            <td class="px-4 py-3">❌ Não aplicável</td>
                                        </tr>
                                        <tr class="bg-zinc-50 dark:bg-zinc-800/50">
                                            <td class="px-4 py-3 font-medium">Sanitização</td>
                                            <td class="px-4 py-3">✅ GET/POST/REQUEST</td>
                                            <td class="px-4 py-3">❌ Mínima</td>
                                        </tr>
                                        <tr class="bg-white dark:bg-zinc-900">
                                            <td class="px-4 py-3 font-medium">BD</td>
                                            <td class="px-4 py-3">Sempre em init_2()</td>
                                            <td class="px-4 py-3">Sob demanda via flag</td>
                                        </tr>
                                        <tr class="bg-zinc-50 dark:bg-zinc-800/50">
                                            <td class="px-4 py-3 font-medium">Controle de estado</td>
                                            <td class="px-4 py-3">Sem flags</td>
                                            <td class="px-4 py-3"><code>isBooted</code>, <code>isDatabaseConnected</code></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </section>

                        {{-- Container & Service Providers --}}
                        <section id="service-providers" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.cube class="size-6 text-green-500" />
                                    Container & Service Providers
                                </h2>
                                <p class="text-zinc-700 dark:text-zinc-300">
                                    O arquivo <code>bootstrap.php</code> é o ponto central que configura o container DI:
                                </p>
                            </div>

                            <div class="rounded-xl bg-zinc-950 p-4 text-sm overflow-x-auto">
                                <pre class="language-php"><code>// bootstrap.php
ErrorHandler::register();                              // Error handling global
Dotenv::createImmutable(rootPath())->safeLoad();       // Variáveis .env

$container = Container::getInstance();                 // Singleton do container

// Seleciona bootstrapper baseado no contexto
if (isCli()) {
    $container->make(CliBootstrapper::class);
} else {
    $container->make(ApplicationBootstrapper::class);
}

$container->boot();  // Carrega todos os Service Providers
return $container;</code></pre>
                            </div>

                            {{-- Service Providers List --}}
                            <div class="rounded-xl border-l-4 border-green-500 bg-green-50 dark:bg-green-900/20 p-4 mt-4">
                                <div class="flex items-center gap-2 mb-3">
                                    <flux:icon.puzzle-piece class="size-5 text-green-600 dark:text-green-400" />
                                    <p class="font-semibold text-green-800 dark:text-green-200">16 Service Providers Registrados</p>
                                </div>
                                <div class="grid gap-2 md:grid-cols-4 text-xs">
                                    <code class="bg-green-100 dark:bg-green-800/30 px-2 py-1 rounded text-green-800 dark:text-green-200">EventServiceProvider</code>
                                    <code class="bg-green-100 dark:bg-green-800/30 px-2 py-1 rounded text-green-800 dark:text-green-200">HelperServiceProvider</code>
                                    <code class="bg-green-100 dark:bg-green-800/30 px-2 py-1 rounded text-green-800 dark:text-green-200">ConfigServiceProvider</code>
                                    <code class="bg-green-100 dark:bg-green-800/30 px-2 py-1 rounded text-green-800 dark:text-green-200">QueueServiceProvider</code>
                                    <code class="bg-green-100 dark:bg-green-800/30 px-2 py-1 rounded text-green-800 dark:text-green-200">RedisServiceProvider</code>
                                    <code class="bg-green-100 dark:bg-green-800/30 px-2 py-1 rounded text-green-800 dark:text-green-200">CacheServiceProvider</code>
                                    <code class="bg-green-100 dark:bg-green-800/30 px-2 py-1 rounded text-green-800 dark:text-green-200">HttpClientServiceProvider</code>
                                    <code class="bg-green-100 dark:bg-green-800/30 px-2 py-1 rounded text-green-800 dark:text-green-200">ValidationServiceProvider</code>
                                    <code class="bg-green-100 dark:bg-green-800/30 px-2 py-1 rounded text-green-800 dark:text-green-200">GlobalServiceProvider</code>
                                    <code class="bg-green-100 dark:bg-green-800/30 px-2 py-1 rounded text-green-800 dark:text-green-200">ViewServiceProvider</code>
                                    <code class="bg-green-100 dark:bg-green-800/30 px-2 py-1 rounded text-green-800 dark:text-green-200">NotificationServiceProvider</code>
                                    <code class="bg-green-100 dark:bg-green-800/30 px-2 py-1 rounded text-green-800 dark:text-green-200">RoutingServiceProvider</code>
                                    <code class="bg-green-100 dark:bg-green-800/30 px-2 py-1 rounded text-green-800 dark:text-green-200">GuardServiceProvider</code>
                                    <code class="bg-green-100 dark:bg-green-800/30 px-2 py-1 rounded text-green-800 dark:text-green-200">QueueMasterServiceProvider</code>
                                    <code class="bg-green-100 dark:bg-green-800/30 px-2 py-1 rounded text-green-800 dark:text-green-200">SaftPtServiceProvider</code>
                                    <code class="bg-green-100 dark:bg-green-800/30 px-2 py-1 rounded text-green-800 dark:text-green-200">SaftAoServiceProvider</code>
                                </div>
                            </div>
                        </section>

                        {{-- Navigation --}}
                        <div class="flex justify-between items-center pt-8 border-t border-zinc-200 dark:border-zinc-800">
                            <a href="{{ route('docs.index') }}" class="inline-flex items-center gap-2 text-sm text-zinc-600 dark:text-zinc-400 hover:text-primary">
                                <flux:icon.arrow-left class="size-4" />
                                Visão Geral
                            </a>
                            <a href="{{ route('docs.show', 'container') }}" class="inline-flex items-center gap-2 text-sm font-medium text-primary hover:underline">
                                Container
                                <flux:icon.arrow-right class="size-4" />
                            </a>
                        </div>
                    </div>

                </div>
            </div>

            {{-- Right Sidebar: Table of Contents --}}
            @include('docs.partials.toc', ['sections' => [
                'pontos-de-entrada' => 'Pontos de Entrada',
                'fluxo-http' => 'Fluxo HTTP/Web',
                'fases-inicializacao' => 'Fases de Inicialização',
                'fluxo-cli' => 'Fluxo CLI',
                'fluxo-ajax' => 'Fluxo AJAX',
                'comparativo' => 'Comparativo',
                'service-providers' => 'Service Providers',
            ]])
        </div>
    </div>
@endsection
