@extends('layouts.docs')

@section('title', 'Cache System - OG Framework')

@section('body')
    <div class="relative min-h-screen bg-transparent px-4 pb-12 pt-6 sm:px-6 lg:px-8">
        {{-- Floating shapes for styling --}}
        <div class="floating-blur orange -left-10 -top-10 hidden lg:block"></div>
        <div class="floating-blur purple right-10 top-32 hidden lg:block"></div>

        <div class="mx-auto flex w-full max-w-7xl gap-8 bg-transparent">
            {{-- Left Sidebar: Navigation --}}
            @include('docs.partials.sidebar')

            {{-- Main Content --}}
            <div class="flex-1 min-w-0">
                <div class="relative overflow-hidden rounded-3xl border border-white/50 bg-white/85 p-8 shadow-xl shadow-primary/20 backdrop-blur dark:border-zinc-800 dark:bg-zinc-900/80">

                    {{-- Page Header --}}
                    <div class="mb-8">
                        <a href="{{ route('docs.index') }}" class="inline-flex items-center gap-1 text-sm text-primary hover:underline mb-4">
                            <flux:icon.arrow-left class="size-4" />
                            Voltar para Documentação
                        </a>
                        <p class="text-xs uppercase tracking-[0.3em] text-primary dark:text-blue-200">System</p>
                        <h1 class="font-display text-4xl font-bold text-zinc-900 dark:text-white sm:text-5xl">Cache System</h1>
                        <p class="mt-3 text-base text-zinc-700 dark:text-zinc-200 max-w-3xl">
                            API unificada e expressiva para diversos backends de armazenamento em cache, otimizada para performance e flexibilidade.
                        </p>
                    </div>

                    <div class="space-y-10">

                        {{-- Introduction --}}
                        <section id="introducao" class="scroll-mt-28 space-y-4">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.book-open class="size-6 text-orange-500" />
                                    Introdução
                                </h2>
                                <p class="text-zinc-700 dark:text-zinc-300">
                                    O sistema de cache do OfficeGest oferece uma interface consistente para drivers como Redis, Files e Database. A configuração reside em <code>Modules/Common/Config/cache.php</code> e pode ser ajustada via variáveis de ambiente <code>.env</code>.
                                </p>
                            </div>
                        </section>

                        {{-- Architecture (SVG) --}}
                        <section id="arquitetura" class="scroll-mt-28 space-y-4">
                            <h3 class="text-lg font-semibold text-zinc-900 dark:text-white">Arquitetura do Sistema</h3>
                            <div class="rounded-xl bg-gradient-to-br from-zinc-900 to-zinc-950 p-6 overflow-x-auto">
                                <svg viewBox="0 0 700 350" class="w-full max-w-3xl mx-auto" xmlns="http://www.w3.org/2000/svg">
                                    <defs>
                                        <linearGradient id="cacheGradient" x1="0%" y1="0%" x2="0%" y2="100%">
                                            <stop offset="0%" style="stop-color:#f97316;stop-opacity:1" />
                                            <stop offset="100%" style="stop-color:#c2410c;stop-opacity:1" />
                                        </linearGradient>
                                    </defs>

                                    <!-- Application Layer -->
                                    <rect x="50" y="150" width="120" height="60" rx="8" fill="#1e293b" stroke="#f97316" stroke-width="2"/>
                                    <text x="110" y="185" fill="white" font-family="ui-monospace, monospace" font-size="12" text-anchor="middle" font-weight="600">Application</text>
                                    <text x="110" y="200" fill="#cbd5e1" font-family="ui-monospace, monospace" font-size="10" text-anchor="middle">Cache::get()</text>

                                    <!-- Arrow -->
                                    <line x1="170" y1="180" x2="240" y2="180" stroke="#94a3b8" stroke-width="2"/>
                                    <polygon points="240,180 230,175 230,185" fill="#94a3b8"/>

                                    <!-- Facade Layer -->
                                    <rect x="250" y="140" width="140" height="80" rx="8" fill="#fff7ed" stroke="#f97316" stroke-width="1" stroke-dasharray="4 4"/>
                                    <text x="320" y="165" fill="#c2410c" font-family="ui-monospace, monospace" font-size="12" text-anchor="middle" font-weight="600">Cache Facade</text>
                                    <line x1="270" y1="180" x2="370" y2="180" stroke="#fdba74" stroke-width="1"/>
                                    <text x="320" y="200" fill="#9a3412" font-family="ui-monospace, monospace" font-size="10" text-anchor="middle">Proxy -> Manager</text>

                                    <!-- Arrow -->
                                    <line x1="390" y1="180" x2="460" y2="180" stroke="#94a3b8" stroke-width="2"/>
                                    <polygon points="460,180 450,175 450,185" fill="#94a3b8"/>

                                    <!-- Drivers Layer -->
                                    <rect x="470" y="50" width="180" height="260" rx="8" fill="#1e293b" stroke="#475569" stroke-width="2"/>
                                    <text x="560" y="80" fill="white" font-family="ui-monospace, monospace" font-size="12" text-anchor="middle" font-weight="600">Cache Drivers</text>

                                    <!-- Driver: Redis -->
                                    <rect x="490" y="100" width="140" height="40" rx="6" fill="#dc2626" stroke="#ef4444" stroke-width="2"/>
                                    <text x="560" y="125" fill="white" font-family="ui-monospace, monospace" font-size="11" text-anchor="middle">Redis (Memory)</text>

                                    <!-- Driver: Database -->
                                    <rect x="490" y="160" width="140" height="40" rx="6" fill="#0f766e" stroke="#14b8a6" stroke-width="2"/>
                                    <text x="560" y="185" fill="white" font-family="ui-monospace, monospace" font-size="11" text-anchor="middle">Database (SQL)</text>

                                    <!-- Driver: File -->
                                    <rect x="490" y="220" width="140" height="40" rx="6" fill="#1e3a8a" stroke="#3b82f6" stroke-width="2"/>
                                    <text x="560" y="245" fill="white" font-family="ui-monospace, monospace" font-size="11" text-anchor="middle">File System</text>

                                </svg>
                            </div>
                        </section>

                        {{-- Basic Usage --}}
                        <section id="uso-basico" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.code-bracket class="size-6 text-green-500" />
                                    Recuperar e Guardar Itens
                                </h2>
                                <p class="text-zinc-700 dark:text-zinc-300">
                                    A Facade <code>Cache</code> é a porta de entrada principal.
                                </p>
                            </div>

                            <div class="grid gap-6">
                                {{-- Method: GET --}}
                                <div class="rounded-xl border border-zinc-200 bg-zinc-50 p-4 dark:border-zinc-800 dark:bg-zinc-900/30">
                                    <h3 class="font-mono text-sm font-bold text-primary mb-2">Cache::get($key, $default = null)</h3>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400 mb-2">Recupera um valor. Se não existir, retorna <code>null</code> ou o valor default.</p>
                                    <pre class="language-php text-xs rounded-lg bg-zinc-950 p-3"><code>// Simples
$value = Cache::get('key');

// Com default
$value = Cache::get('key', 'default_value');

// Com Closure (lazy evaluation)
$value = Cache::get('settings', function () {
    return DB::table('settings')->get();
});</code></pre>
                                </div>

                                {{-- Method: PUT --}}
                                <div class="rounded-xl border border-zinc-200 bg-zinc-50 p-4 dark:border-zinc-800 dark:bg-zinc-900/30">
                                    <h3 class="font-mono text-sm font-bold text-primary mb-2">Cache::put($key, $value, $seconds)</h3>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400 mb-2">Armazena um item por um tempo determinado.</p>
                                    <pre class="language-php text-xs rounded-lg bg-zinc-950 p-3"><code>// Guardar por 60 segundos
Cache::put('key', 'meu_valor', 60);

// Arrays são serializados automaticamente
Cache::put('user:profile', ['name' => 'Paulo', 'role' => 'admin'], 600);</code></pre>
                                </div>

                                {{-- Method: REMEMBER --}}
                                <div class="rounded-xl border border-zinc-200 bg-zinc-50 p-4 dark:border-zinc-800 dark:bg-zinc-900/30">
                                    <h3 class="font-mono text-sm font-bold text-primary mb-2">Cache::remember($key, $seconds, $callback)</h3>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400 mb-2">
                                        Tenta obter do cache. Se não existir, executa a closure, guarda o resultado e retorna. 
                                        <strong>Método mais comum e eficiente.</strong>
                                    </p>
                                    <pre class="language-php text-xs rounded-lg bg-zinc-950 p-3"><code>$users = Cache::remember('all_users', 600, function () {
    return DB::table('users')->get();
});</code></pre>
                                </div>

                                {{-- Other Methods --}}
                                <div class="grid gap-4 md:grid-cols-2">
                                    <div class="rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-800 dark:bg-zinc-900/50">
                                        <h3 class="font-mono text-sm font-bold text-primary mb-1">Cache::has($key)</h3>
                                        <p class="text-xs text-zinc-500">Verifica existência (retorna bool).</p>
                                    </div>
                                    <div class="rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-800 dark:bg-zinc-900/50">
                                        <h3 class="font-mono text-sm font-bold text-primary mb-1">Cache::add($key, $val, $sec)</h3>
                                        <p class="text-xs text-zinc-500">Adiciona apenas se NÃO existir. Retorna <code>true</code> se adicionou (Lock atómico).</p>
                                    </div>
                                </div>
                            </div>
                        </section>

                        {{-- Removing Items --}}
                        <section id="remover" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.trash class="size-6 text-red-500" />
                                    Remover Itens
                                </h2>
                            </div>
                            <div class="grid gap-4 md:grid-cols-2">
                                <div class="rounded-xl bg-zinc-950 p-4 text-sm font-mono text-zinc-300">
                                    <div class="text-purple-400 mb-2">// Remover um item</div>
                                    Cache::forget('key');
                                </div>
                                <div class="rounded-xl bg-zinc-950 p-4 text-sm font-mono text-zinc-300">
                                    <div class="text-red-400 mb-2">// Limpar TUDO (Cuidado!)</div>
                                    Cache::clearAll();
                                </div>
                            </div>
                        </section>

                        {{-- Configuration --}}
                        <section id="configuracao" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.cog-6-tooth class="size-6 text-zinc-500" />
                                    Configuração e Drivers
                                </h2>
                                <p class="text-zinc-700 dark:text-zinc-300">
                                    Configurável via <code>.env</code>. Em produção, prefira <strong>Redis</strong>.
                                </p>
                            </div>

                            <div class="rounded-xl bg-zinc-950 p-4 text-sm overflow-x-auto">
                                <div class="flex items-center justify-between mb-2">
                                    <span class="text-xs font-semibold text-purple-400">Modules/Common/Config/cache.php</span>
                                </div>
                                <pre class="language-php"><code>return [
    'default' => envVar('CACHE_DRIVER', 'redis'),

    'stores' => [
        'file' => [
            'driver' => 'file',
            'path' => rootPath("_cache/{$server}cache"),
        ],
        
        'redis' => [
            'driver' => 'redis',
            'connection' => 'cache',
            'prefix' => "{$serverCachePrefix}_cache",
        ],
    ],
];</code></pre>
                            </div>
                        </section>

                        {{-- Real Examples --}}
                        <section id="exemplos" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.beaker class="size-6 text-amber-500" />
                                    Exemplos Práticos
                                </h2>
                                <p class="text-zinc-700 dark:text-zinc-300">
                                    Casos de uso reais extraídos do código do OfficeGest.
                                </p>
                            </div>

                            <div class="space-y-6">
                                {{-- Exemplo 1 --}}
                                <div class="rounded-xl border border-zinc-200 bg-white p-6 shadow-sm dark:border-zinc-800 dark:bg-zinc-900/50">
                                    <h4 class="font-semibold text-zinc-900 dark:text-white mb-2">1. Cache de Configurações Externas (WMS)</h4>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400 mb-3">Evita chamadas de API repetitivas usando <code>remember</code>.</p>
                                    <pre class="text-xs bg-zinc-950 p-3 rounded-lg text-zinc-300 overflow-x-auto"><code>return Cache::remember('wms_configs', 5, function () {
    return $this->connection->makeHttpCall(url: "configs");
});</code></pre>
                                </div>

                                {{-- Exemplo 2 --}}
                                <div class="rounded-xl border border-zinc-200 bg-white p-6 shadow-sm dark:border-zinc-800 dark:bg-zinc-900/50">
                                    <h4 class="font-semibold text-zinc-900 dark:text-white mb-2">2. Estado de Processamento em Lote</h4>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400 mb-3">Uso de <code>put</code> e <code>get</code> para gestão de estado mutável.</p>
                                    <pre class="text-xs bg-zinc-950 p-3 rounded-lg text-zinc-300 overflow-x-auto"><code>// Inicializar
Cache::put("batch:123:state", ['status' => 'pending'], 86400);

// Atualizar depois
$state = Cache::get("batch:123:state");
$state['status'] = 'processing';
Cache::put("batch:123:state", $state, 86400);</code></pre>
                                </div>

                                {{-- Exemplo 3 --}}
                                <div class="rounded-xl border border-zinc-200 bg-white p-6 shadow-sm dark:border-zinc-800 dark:bg-zinc-900/50">
                                    <h4 class="font-semibold text-zinc-900 dark:text-white mb-2">3. Listas para Dropdowns (Select2)</h4>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400 mb-3">Cache longo para dados estáticos de base de dados.</p>
                                    <pre class="text-xs bg-zinc-950 p-3 rounded-lg text-zinc-300 overflow-x-auto"><code>$statusTypes = Cache::remember('wmso_select2_status_types', 3600, function () {
    return $this->database->from('status_types')->get()->result();
});</code></pre>
                                </div>
                            </div>
                        </section>

                        {{-- Troubleshooting --}}
                        <section id="troubleshooting" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                <flux:icon.wrench-screwdriver class="size-6 text-red-500" />
                                Troubleshooting
                            </h2>
                            <div class="grid gap-4">
                                <div class="rounded-lg border border-red-200 bg-red-50 p-4 dark:border-red-900/30 dark:bg-red-900/10">
                                    <p class="font-semibold text-red-800 dark:text-red-300">Não serializa?</p>
                                    <p class="text-sm text-red-700 dark:text-red-400 mt-1">Evite salvar objetos com recursos (streams, conexões DB) dentro. O Cache usa <code>serialize()</code> e vai falhar.</p>
                                </div>
                                <div class="rounded-lg border border-amber-200 bg-amber-50 p-4 dark:border-amber-900/30 dark:bg-amber-900/10">
                                    <p class="font-semibold text-amber-800 dark:text-amber-300">Dados antigos?</p>
                                    <p class="text-sm text-amber-700 dark:text-amber-400 mt-1">Lembre-se de usar <code>Cache::forget()</code> quando atualizar o dado original na DB.</p>
                                </div>
                            </div>
                        </section>

                        {{-- Navigation --}}
                        <div class="flex justify-between items-center pt-8 border-t border-zinc-200 dark:border-zinc-800">
                            <a href="{{ route('docs.show', 'facades') }}" class="inline-flex items-center gap-2 text-sm text-zinc-600 dark:text-zinc-400 hover:text-primary">
                                <flux:icon.arrow-left class="size-4" />
                                Facades
                            </a>
                            <a href="{{ route('docs.show', 'filesystem') }}" class="inline-flex items-center gap-2 text-sm font-medium text-primary hover:underline">
                                Filesystem
                                <flux:icon.arrow-right class="size-4" />
                            </a>
                        </div>
                    </div>

                </div>
            </div>

            {{-- Right Sidebar: Table of Contents --}}
            @include('docs.partials.toc', ['sections' => [
                'introducao' => 'Introdução',
                'arquitetura' => 'Arquitetura',
                'uso-basico' => 'Recuperar e Guardar',
                'remover' => 'Remover Itens',
                'configuracao' => 'Configuração',
                'exemplos' => 'Exemplos Práticos',
                'troubleshooting' => 'Troubleshooting',
            ]])
        </div>
    </div>
@endsection
