@extends('layouts.docs')

@section('title', 'Facades - OG Framework')

@section('body')
    <div class="relative min-h-screen bg-transparent px-4 pb-12 pt-6 sm:px-6 lg:px-8">
        <div class="floating-blur blue -left-10 -top-10 hidden lg:block"></div>
        <div class="floating-blur amber right-10 top-32 hidden lg:block"></div>

        <div class="mx-auto flex w-full max-w-7xl gap-8 bg-transparent">
            {{-- Left Sidebar: Navigation --}}
            @include('docs.partials.sidebar')

            {{-- Main Content --}}
            <div class="flex-1 min-w-0">
                <div class="relative overflow-hidden rounded-3xl border border-white/50 bg-white/85 p-8 shadow-xl shadow-primary/20 backdrop-blur dark:border-zinc-800 dark:bg-zinc-900/80">

                    {{-- Page Header --}}
                    <div class="mb-8">
                        <a href="{{ route('docs.index') }}" class="inline-flex items-center gap-1 text-sm text-primary hover:underline mb-4">
                            <flux:icon.arrow-left class="size-4" />
                            Voltar para Documentação
                        </a>
                        <p class="text-xs uppercase tracking-[0.3em] text-primary dark:text-blue-200">Arquitetura</p>
                        <h1 class="font-display text-4xl font-bold text-zinc-900 dark:text-white sm:text-5xl">Facades</h1>
                        <p class="mt-3 text-base text-zinc-700 dark:text-zinc-200 max-w-3xl">
                            Facades fornecem uma interface estática elegante para serviços do container. Em vez de <code>app('cache')->get('key')</code>, use simplesmente <code>Cache::get('key')</code>.
                        </p>
                    </div>

                    <div class="space-y-10">

                        {{-- Introduction --}}
                        <section id="introducao" class="scroll-mt-28 space-y-4">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.light-bulb class="size-6 text-amber-500" />
                                    Como Funcionam?
                                </h2>
                            </div>

                            <div class="rounded-xl bg-gradient-to-br from-zinc-900 to-zinc-950 p-6 overflow-x-auto">
                                <svg viewBox="0 0 600 320" class="w-full max-w-2xl mx-auto" xmlns="http://www.w3.org/2000/svg">
                                    <!-- Background grid -->
                                    <defs>
                                        <pattern id="grid" width="20" height="20" patternUnits="userSpaceOnUse">
                                            <path d="M 20 0 L 0 0 0 20" fill="none" stroke="rgba(255,255,255,0.03)" stroke-width="1"/>
                                        </pattern>
                                        <linearGradient id="arrowGradient" x1="0%" y1="0%" x2="0%" y2="100%">
                                            <stop offset="0%" style="stop-color:#22d3ee;stop-opacity:1" />
                                            <stop offset="100%" style="stop-color:#8b5cf6;stop-opacity:1" />
                                        </linearGradient>
                                        <filter id="glow">
                                            <feGaussianBlur stdDeviation="3" result="coloredBlur"/>
                                            <feMerge>
                                                <feMergeNode in="coloredBlur"/>
                                                <feMergeNode in="SourceGraphic"/>
                                            </feMerge>
                                        </filter>
                                    </defs>
                                    <rect width="600" height="320" fill="url(#grid)"/>

                                    <!-- Step 1: Code call -->
                                    <rect x="200" y="15" width="200" height="40" rx="8" fill="#0e7490" stroke="#22d3ee" stroke-width="2"/>
                                    <text x="300" y="40" fill="white" font-family="ui-monospace, monospace" font-size="14" text-anchor="middle" font-weight="600">Cache::get('key')</text>

                                    <!-- Arrow 1 -->
                                    <line x1="300" y1="55" x2="300" y2="75" stroke="url(#arrowGradient)" stroke-width="2"/>
                                    <polygon points="300,85 294,75 306,75" fill="#8b5cf6"/>

                                    <!-- Step 2: __callStatic -->
                                    <rect x="180" y="85" width="240" height="40" rx="8" fill="#1e3a5f" stroke="#3b82f6" stroke-width="2"/>
                                    <text x="300" y="110" fill="#93c5fd" font-family="ui-monospace, monospace" font-size="13" text-anchor="middle">__callStatic('get', ['key'])</text>

                                    <!-- Arrow 2 -->
                                    <line x1="300" y1="125" x2="300" y2="145" stroke="url(#arrowGradient)" stroke-width="2"/>
                                    <polygon points="300,155 294,145 306,145" fill="#8b5cf6"/>

                                    <!-- Step 3: getFacadeAccessor -->
                                    <rect x="180" y="155" width="240" height="40" rx="8" fill="#14532d" stroke="#22c55e" stroke-width="2"/>
                                    <text x="300" y="180" fill="#86efac" font-family="ui-monospace, monospace" font-size="13" text-anchor="middle">getFacadeAccessor() → 'cache'</text>

                                    <!-- Arrow 3 -->
                                    <line x1="300" y1="195" x2="300" y2="215" stroke="url(#arrowGradient)" stroke-width="2"/>
                                    <polygon points="300,225 294,215 306,215" fill="#8b5cf6"/>

                                    <!-- Step 4: Container -->
                                    <rect x="180" y="225" width="240" height="40" rx="8" fill="#4c1d95" stroke="#a855f7" stroke-width="2"/>
                                    <text x="300" y="250" fill="#d8b4fe" font-family="ui-monospace, monospace" font-size="13" text-anchor="middle">Container::get('cache')</text>

                                    <!-- Arrow 4 -->
                                    <line x1="420" y1="245" x2="450" y2="245" stroke="url(#arrowGradient)" stroke-width="2"/>
                                    <polygon points="460,245 450,239 450,251" fill="#8b5cf6"/>

                                    <!-- Step 5: Service -->
                                    <rect x="460" y="225" width="130" height="40" rx="8" fill="#831843" stroke="#ec4899" stroke-width="2" filter="url(#glow)"/>
                                    <text x="525" y="250" fill="#fbcfe8" font-family="ui-monospace, monospace" font-size="12" text-anchor="middle">CacheManager</text>

                                    <!-- Labels -->
                                    <text x="30" y="40" fill="#6b7280" font-size="11" font-weight="500">1. Chamada</text>
                                    <text x="30" y="110" fill="#6b7280" font-size="11" font-weight="500">2. Método mágico</text>
                                    <text x="30" y="180" fill="#6b7280" font-size="11" font-weight="500">3. Accessor</text>
                                    <text x="30" y="250" fill="#6b7280" font-size="11" font-weight="500">4. Container</text>
                                    <text x="460" y="290" fill="#6b7280" font-size="11" font-weight="500" text-anchor="middle">5. Serviço Real</text>
                                </svg>
                            </div>

                            <div class="overflow-x-auto">
                                <table class="w-full text-sm text-left">
                                    <thead class="text-xs uppercase bg-zinc-100 dark:bg-zinc-800">
                                        <tr>
                                            <th class="px-4 py-3">Aspecto</th>
                                            <th class="px-4 py-3">Sem Facade</th>
                                            <th class="px-4 py-3">Com Facade</th>
                                        </tr>
                                    </thead>
                                    <tbody class="divide-y divide-zinc-200 dark:divide-zinc-700">
                                        <tr class="bg-white dark:bg-zinc-900">
                                            <td class="px-4 py-3 font-medium">Sintaxe</td>
                                            <td class="px-4 py-3 text-red-600">Verbosa</td>
                                            <td class="px-4 py-3 text-green-600">Concisa</td>
                                        </tr>
                                        <tr class="bg-zinc-50 dark:bg-zinc-800/50">
                                            <td class="px-4 py-3 font-medium">Testabilidade</td>
                                            <td class="px-4 py-3 text-red-600">Manual mocking</td>
                                            <td class="px-4 py-3 text-green-600">spy(), mock() built-in</td>
                                        </tr>
                                        <tr class="bg-white dark:bg-zinc-900">
                                            <td class="px-4 py-3 font-medium">IDE Support</td>
                                            <td class="px-4 py-3 text-amber-600">Limitado</td>
                                            <td class="px-4 py-3 text-green-600">PHPDoc completo</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </section>

                        {{-- Quick Start --}}
                        <section id="quick-start" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.rocket-launch class="size-6 text-green-500" />
                                    Quick Start
                                </h2>
                            </div>

                            <div class="rounded-xl bg-zinc-950 p-4 text-sm overflow-x-auto">
                                <pre class="language-php"><code>use Og\Modules\Common\Facades\Cache;
use Og\Modules\Common\Facades\Auth;
use Og\Modules\Common\Facades\Queue;
use Og\Modules\Common\Facades\Http;

// CACHE - armazenar e recuperar dados
Cache::put('user:1', $userData, 60);
$user = Cache::get('user:1');

// AUTH - verificar utilizador
if (Auth::check()) {
    $userId = Auth::id();
    $canEdit = Auth::can('posts:edit');
}

// QUEUE - enviar jobs para background
Queue::dispatch(new SendEmailJob($user));

// HTTP - fazer requests externos
$response = Http::get('https://api.example.com/users');</code></pre>
                            </div>

                            <div class="feature-card">
                                <p class="font-semibold text-zinc-900 dark:text-white mb-2">Import Múltiplo</p>
                                <div class="rounded-lg bg-zinc-950 p-3 text-xs overflow-x-auto">
                                    <pre class="language-php"><code>use Og\Modules\Common\Facades\{
    Auth, Cache, Queue, Http,
    Route, View, File, Notification
};</code></pre>
                                </div>
                            </div>
                        </section>

                        {{-- All Facades --}}
                        <section id="todas-facades" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.rectangle-stack class="size-6 text-blue-500" />
                                    11 Facades Disponíveis
                                </h2>
                            </div>

                            <div class="overflow-x-auto">
                                <table class="w-full text-sm text-left">
                                    <thead class="text-xs uppercase bg-zinc-100 dark:bg-zinc-800">
                                        <tr>
                                            <th class="px-4 py-3">Facade</th>
                                            <th class="px-4 py-3">Accessor</th>
                                            <th class="px-4 py-3">Uso</th>
                                        </tr>
                                    </thead>
                                    <tbody class="divide-y divide-zinc-200 dark:divide-zinc-700 text-xs">
                                        <tr class="bg-white dark:bg-zinc-900">
                                            <td class="px-4 py-2 font-mono font-semibold text-blue-600">Auth</td>
                                            <td class="px-4 py-2 font-mono">'auth'</td>
                                            <td class="px-4 py-2">Verificar utilizador e permissões</td>
                                        </tr>
                                        <tr class="bg-zinc-50 dark:bg-zinc-800/50">
                                            <td class="px-4 py-2 font-mono font-semibold text-green-600">Cache</td>
                                            <td class="px-4 py-2 font-mono">'cache'</td>
                                            <td class="px-4 py-2">Cache distribuído (Redis)</td>
                                        </tr>
                                        <tr class="bg-white dark:bg-zinc-900">
                                            <td class="px-4 py-2 font-mono font-semibold text-purple-600">Queue</td>
                                            <td class="px-4 py-2 font-mono">QueueManagerInterface</td>
                                            <td class="px-4 py-2">Jobs em background</td>
                                        </tr>
                                        <tr class="bg-zinc-50 dark:bg-zinc-800/50">
                                            <td class="px-4 py-2 font-mono font-semibold text-amber-600">Http</td>
                                            <td class="px-4 py-2 font-mono">'http-client'</td>
                                            <td class="px-4 py-2">Requests HTTP externos</td>
                                        </tr>
                                        <tr class="bg-white dark:bg-zinc-900">
                                            <td class="px-4 py-2 font-mono font-semibold text-cyan-600">Route</td>
                                            <td class="px-4 py-2 font-mono">RouterClass</td>
                                            <td class="px-4 py-2">Definição de rotas</td>
                                        </tr>
                                        <tr class="bg-zinc-50 dark:bg-zinc-800/50">
                                            <td class="px-4 py-2 font-mono font-semibold text-pink-600">View</td>
                                            <td class="px-4 py-2 font-mono">'view'</td>
                                            <td class="px-4 py-2">Renderizar templates</td>
                                        </tr>
                                        <tr class="bg-white dark:bg-zinc-900">
                                            <td class="px-4 py-2 font-mono font-semibold text-indigo-600">File</td>
                                            <td class="px-4 py-2 font-mono">Filesystem::class</td>
                                            <td class="px-4 py-2">Operações de ficheiros</td>
                                        </tr>
                                        <tr class="bg-zinc-50 dark:bg-zinc-800/50">
                                            <td class="px-4 py-2 font-mono font-semibold text-rose-600">Notification</td>
                                            <td class="px-4 py-2 font-mono">NotificationService</td>
                                            <td class="px-4 py-2">Email, SMS, Push</td>
                                        </tr>
                                        <tr class="bg-white dark:bg-zinc-900">
                                            <td class="px-4 py-2 font-mono font-semibold text-teal-600">Request</td>
                                            <td class="px-4 py-2 font-mono">'request'</td>
                                            <td class="px-4 py-2">Dados do request actual</td>
                                        </tr>
                                        <tr class="bg-zinc-50 dark:bg-zinc-800/50">
                                            <td class="px-4 py-2 font-mono font-semibold text-orange-600">Response</td>
                                            <td class="px-4 py-2 font-mono">'response'</td>
                                            <td class="px-4 py-2">Construir responses</td>
                                        </tr>
                                        <tr class="bg-white dark:bg-zinc-900">
                                            <td class="px-4 py-2 font-mono font-semibold text-red-600">GuardFacade</td>
                                            <td class="px-4 py-2 font-mono">'guard'</td>
                                            <td class="px-4 py-2">Tokens e SPA auth</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </section>

                        {{-- Facade Examples --}}
                        <section id="exemplos-facades" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.code-bracket class="size-6 text-cyan-500" />
                                    Exemplos por Facade
                                </h2>
                            </div>

                            <div class="grid gap-4">
                                {{-- Cache --}}
                                <div class="feature-card">
                                    <p class="font-mono text-sm font-semibold text-green-600 dark:text-green-400 mb-2">Cache</p>
                                    <div class="rounded-lg bg-zinc-950 p-3 text-xs overflow-x-auto">
                                        <pre class="language-php"><code>// Operações básicas
Cache::put('key', $value, 60);   // Guardar por 60s
$value = Cache::get('key');       // Recuperar
Cache::forget('key');             // Remover

// Remember pattern (cache inteligente)
$data = Cache::remember('expensive', 300, function() {
    return $this->heavyQuery();
});

// Multi-tenant
Cache::replacePrefix('tenant:123:');</code></pre>
                                    </div>
                                </div>

                                {{-- Queue --}}
                                <div class="feature-card">
                                    <p class="font-mono text-sm font-semibold text-purple-600 dark:text-purple-400 mb-2">Queue</p>
                                    <div class="rounded-lg bg-zinc-950 p-3 text-xs overflow-x-auto">
                                        <pre class="language-php"><code>// Dispatch simples
Queue::dispatch(new SendEmailJob($user));

// Com delay
Queue::later(now()->addMinutes(5), new ReminderJob());

// Batch de jobs
Queue::batch([
    new ProcessJob($item1),
    new ProcessJob($item2),
]);

// Chain sequencial
Queue::chain([
    new ImportDataJob(),
    new ValidateDataJob(),
    new GenerateReportJob(),
]);</code></pre>
                                    </div>
                                </div>

                                {{-- Http --}}
                                <div class="feature-card">
                                    <p class="font-mono text-sm font-semibold text-amber-600 dark:text-amber-400 mb-2">Http</p>
                                    <div class="rounded-lg bg-zinc-950 p-3 text-xs overflow-x-auto">
                                        <pre class="language-php"><code>// GET request
$response = Http::get('https://api.example.com/users');

// POST com dados
$response = Http::post('https://api.example.com/users', [
    'name' => 'João',
    'email' => 'joao@email.com',
]);

// Com headers
$response = Http::withHeaders([
    'Authorization' => 'Bearer ' . $token,
])->get('https://api.example.com/protected');

// Base URL
$response = Http::baseUrl('https://api.example.com')
    ->get('/users');</code></pre>
                                    </div>
                                </div>

                                {{-- Route --}}
                                <div class="feature-card">
                                    <p class="font-mono text-sm font-semibold text-cyan-600 dark:text-cyan-400 mb-2">Route</p>
                                    <div class="rounded-lg bg-zinc-950 p-3 text-xs overflow-x-auto">
                                        <pre class="language-php"><code>// Rotas básicas
Route::get('/users', [UserController::class, 'index']);
Route::post('/users', [UserController::class, 'store']);

// Controller group
Route::controller(InvoiceController::class)->group(function() {
    Route::get('/invoices', 'index');
    Route::post('/invoices', 'store');
});</code></pre>
                                    </div>
                                </div>
                            </div>
                        </section>

                        {{-- Create Facade --}}
                        <section id="criar-facade" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.plus-circle class="size-6 text-purple-500" />
                                    Criar uma Facade
                                </h2>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    <code>Modules/Common/Facades/Auth.php</code> — Exemplo real do sistema:
                                </p>
                            </div>

                            <div class="rounded-xl bg-zinc-950 p-4 text-sm overflow-x-auto">
                                <pre class="language-php"><code>namespace Og\Modules\Common\Facades;

use Og\Modules\Common\Utils\Facade;

/**
 * @@method static user()
 * @@method static id()
 * @@method static check()
 * @@method static can(string $permission)
 * @@method static isImpersonating()
 */
class Auth extends Facade
{
    public static function getFacadeAccessor(): string
    {
        return 'auth';  // Resolve app('auth') → AuthManager
    }
}</code></pre>
                            </div>

                            <div class="grid gap-4 md:grid-cols-2">
                                <div class="feature-card border-l-4 border-blue-500">
                                    <p class="font-semibold text-blue-600 dark:text-blue-400 mb-2">Accessor como String</p>
                                    <div class="rounded-lg bg-zinc-950 p-3 text-xs overflow-x-auto">
                                        <pre class="language-php"><code>return 'cache';
// → Container::get('cache')</code></pre>
                                    </div>
                                </div>
                                <div class="feature-card border-l-4 border-green-500">
                                    <p class="font-semibold text-green-600 dark:text-green-400 mb-2">Accessor como Classe/Interface</p>
                                    <div class="rounded-lg bg-zinc-950 p-3 text-xs overflow-x-auto">
                                        <pre class="language-php"><code>return QueueManagerInterface::class;
// → Container::make (...)</code></pre>
                                    </div>
                                </div>
                            </div>
                        </section>

                        {{-- Testing --}}
                        <section id="testing" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.beaker class="size-6 text-green-500" />
                                    Testing com Facades
                                </h2>
                            </div>

                            <div class="grid gap-4 md:grid-cols-2">
                                <div class="feature-card">
                                    <p class="font-mono text-sm font-semibold text-blue-600 dark:text-blue-400 mb-2">spy() — Verificar chamadas</p>
                                    <div class="rounded-lg bg-zinc-950 p-3 text-xs overflow-x-auto">
                                        <pre class="language-php"><code>test('cache is called', function() {
    Cache::spy();

    $service->process();

    Cache::shouldHaveReceived('put')->once();
});</code></pre>
                                    </div>
                                </div>
                                <div class="feature-card">
                                    <p class="font-mono text-sm font-semibold text-green-600 dark:text-green-400 mb-2">mock() — Retornos falsos</p>
                                    <div class="rounded-lg bg-zinc-950 p-3 text-xs overflow-x-auto">
                                        <pre class="language-php"><code>test('mocked cache', function() {
    Cache::mock()
        ->shouldReceive('get')
        ->with('key')
        ->andReturn('mocked');
});</code></pre>
                                    </div>
                                </div>
                                <div class="feature-card">
                                    <p class="font-mono text-sm font-semibold text-purple-600 dark:text-purple-400 mb-2">swap() — Substituir serviço</p>
                                    <div class="rounded-lg bg-zinc-950 p-3 text-xs overflow-x-auto">
                                        <pre class="language-php"><code>test('with fake', function() {
    Cache::swap(new FakeCacheManager());
    // Agora usa FakeCacheManager
});</code></pre>
                                    </div>
                                </div>
                                <div class="feature-card">
                                    <p class="font-mono text-sm font-semibold text-amber-600 dark:text-amber-400 mb-2">Http::fake() — Fake requests</p>
                                    <div class="rounded-lg bg-zinc-950 p-3 text-xs overflow-x-auto">
                                        <pre class="language-php"><code>test('api call', function() {
    Http::fake([
        'api.example.com/*' =>
            Http::response(['data' => 'mocked'])
    ]);
});</code></pre>
                                    </div>
                                </div>
                            </div>
                        </section>

                        {{-- Next Steps --}}
                        <div class="rounded-xl border border-blue-200 dark:border-blue-800 bg-blue-50 dark:bg-blue-900/20 p-4">
                            <p class="text-sm text-blue-900 dark:text-blue-100">
                                <strong>Relação com Container:</strong> Facades são uma camada de "açúcar sintático" sobre o <a href="{{ route('docs.show', 'container') }}" class="underline">Container DI</a>. Cada Facade resolve um serviço registado via <a href="{{ route('docs.show', 'service-providers') }}" class="underline">Service Provider</a>.
                            </p>
                        </div>

                        {{-- Navigation --}}
                        <div class="flex justify-between items-center pt-8 border-t border-zinc-200 dark:border-zinc-800">
                            <a href="{{ route('docs.show', 'auth') }}" class="inline-flex items-center gap-2 text-sm text-zinc-600 dark:text-zinc-400 hover:text-primary">
                                <flux:icon.arrow-left class="size-4" />
                                Autenticação
                            </a>
                            <a href="{{ route('docs.index') }}" class="inline-flex items-center gap-2 text-sm font-medium text-primary hover:underline">
                                Próxima seção em breve
                                <flux:icon.arrow-right class="size-4" />
                            </a>
                        </div>
                    </div>

                </div>
            </div>

            {{-- Right Sidebar: Table of Contents --}}
            @include('docs.partials.toc', ['sections' => [
                'introducao' => 'Como Funcionam?',
                'quick-start' => 'Quick Start',
                'todas-facades' => '11 Facades',
                'exemplos-facades' => 'Exemplos',
                'criar-facade' => 'Criar Facade',
                'testing' => 'Testing',
            ]])
        </div>
    </div>
@endsection
