@extends('layouts.docs')

@section('title', 'Filesystem System - OG Framework')

@section('body')
    <div class="relative min-h-screen bg-transparent px-4 pb-12 pt-6 sm:px-6 lg:px-8">
        {{-- Floating shapes for styling --}}
        <div class="floating-blur purple -left-10 -top-10 hidden lg:block"></div>
        <div class="floating-blur cyan right-10 top-32 hidden lg:block"></div>

        <div class="mx-auto flex w-full max-w-7xl gap-8 bg-transparent">
            {{-- Left Sidebar: Navigation --}}
            @include('docs.partials.sidebar')

            {{-- Main Content --}}
            <div class="flex-1 min-w-0">
                <div class="relative overflow-hidden rounded-3xl border border-white/50 bg-white/85 p-8 shadow-xl shadow-primary/20 backdrop-blur dark:border-zinc-800 dark:bg-zinc-900/80">

                    {{-- Page Header --}}
                    <div class="mb-8">
                        <a href="{{ route('docs.index') }}" class="inline-flex items-center gap-1 text-sm text-primary hover:underline mb-4">
                            <flux:icon.arrow-left class="size-4" />
                            Voltar para Documentação
                        </a>
                        <p class="text-xs uppercase tracking-[0.3em] text-primary dark:text-blue-200">System</p>
                        <h1 class="font-display text-4xl font-bold text-zinc-900 dark:text-white sm:text-5xl">Filesystem System</h1>
                        <p class="mt-3 text-base text-zinc-700 dark:text-zinc-200 max-w-3xl">
                            Abstração poderosa para gestão de ficheiros, oferecendo métodos seguros e normalizados para I/O, gestão de diretórios e downloads.
                        </p>
                    </div>

                    <div class="space-y-10">

                        {{-- Introduction --}}
                        <section id="introducao" class="scroll-mt-28 space-y-4">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.book-open class="size-6 text-purple-500" />
                                    Introdução
                                </h2>
                                <p class="text-zinc-700 dark:text-zinc-300">
                                    O OfficeGest possui uma camada de abstração localizada em <code>Modules/Common/Filesystem/</code>. A interação principal é feita através da Facade <code>File</code>, que simplifica operações comuns e garante segurança.
                                </p>
                            </div>
                        </section>

                        {{-- Architecture (SVG) --}}
                        <section id="arquitetura" class="scroll-mt-28 space-y-4">
                            <h3 class="text-lg font-semibold text-zinc-900 dark:text-white">Arquitetura do Sistema</h3>
                            <div class="rounded-xl bg-gradient-to-br from-zinc-900 to-zinc-950 p-6 overflow-x-auto">
                                <svg viewBox="0 0 700 350" class="w-full max-w-3xl mx-auto" xmlns="http://www.w3.org/2000/svg">
                                    <defs>
                                        <linearGradient id="fsGradient" x1="0%" y1="0%" x2="0%" y2="100%">
                                            <stop offset="0%" style="stop-color:#a855f7;stop-opacity:1" />
                                            <stop offset="100%" style="stop-color:#7e22ce;stop-opacity:1" />
                                        </linearGradient>
                                    </defs>

                                    <!-- Client Code -->
                                    <rect x="50" y="150" width="120" height="60" rx="8" fill="#1e293b" stroke="#a855f7" stroke-width="2"/>
                                    <text x="110" y="185" fill="white" font-family="ui-monospace, monospace" font-size="12" text-anchor="middle" font-weight="600">Client Code</text>
                                    <text x="110" y="200" fill="#cbd5e1" font-family="ui-monospace, monospace" font-size="10" text-anchor="middle">File::put()</text>

                                    <!-- Arrow -->
                                    <line x1="170" y1="180" x2="240" y2="180" stroke="#94a3b8" stroke-width="2"/>
                                    <polygon points="240,180 230,175 230,185" fill="#94a3b8"/>

                                    <!-- Facade/Proxy -->
                                    <rect x="250" y="140" width="140" height="80" rx="8" fill="#faf5ff" stroke="#a855f7" stroke-width="1" stroke-dasharray="4 4"/>
                                    <text x="320" y="165" fill="#7e22ce" font-family="ui-monospace, monospace" font-size="12" text-anchor="middle" font-weight="600">File Facade</text>
                                    <line x1="270" y1="180" x2="370" y2="180" stroke="#d8b4fe" stroke-width="1"/>
                                    <text x="320" y="200" fill="#6b21a8" font-family="ui-monospace, monospace" font-size="10" text-anchor="middle">Proxy Class</text>

                                    <!-- Arrow -->
                                    <line x1="390" y1="180" x2="460" y2="180" stroke="#94a3b8" stroke-width="2"/>
                                    <polygon points="460,180 450,175 450,185" fill="#94a3b8"/>

                                    <!-- Filesystem Singleton -->
                                    <rect x="470" y="80" width="180" height="200" rx="8" fill="#1e293b" stroke="#64748b" stroke-width="2"/>
                                    <text x="560" y="110" fill="white" font-family="ui-monospace, monospace" font-size="12" text-anchor="middle" font-weight="600">Filesystem (Singleton)</text>

                                    <!-- Operations -->
                                    <rect x="490" y="130" width="140" height="30" rx="4" fill="#334155"/>
                                    <text x="560" y="150" fill="#e2e8f0" font-family="ui-monospace, monospace" font-size="10" text-anchor="middle">I/O Operations</text>

                                    <rect x="490" y="170" width="140" height="30" rx="4" fill="#334155"/>
                                    <text x="560" y="190" fill="#e2e8f0" font-family="ui-monospace, monospace" font-size="10" text-anchor="middle">Directory Mgmt</text>
                                    
                                    <!-- Download Manager -->
                                    <rect x="490" y="220" width="140" height="40" rx="4" fill="#0f766e" stroke="#14b8a6"/>
                                    <text x="560" y="245" fill="white" font-family="ui-monospace, monospace" font-size="10" text-anchor="middle">DownloadManager</text>

                                </svg>
                            </div>
                        </section>

                        {{-- Basic Usage --}}
                        <section id="recuperar-guardar" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.document-text class="size-6 text-green-500" />
                                    Recuperar e Guardar Ficheiros
                                </h2>
                            </div>

                            <div class="grid gap-6">
                                {{-- Method: GET --}}
                                <div class="rounded-xl border border-zinc-200 bg-zinc-50 p-4 dark:border-zinc-800 dark:bg-zinc-900/30">
                                    <h3 class="font-mono text-sm font-bold text-primary mb-2">File::get($path)</h3>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400 mb-2">Recupera o conteúdo de um ficheiro. Lança exceção se não existir.</p>
                                    <pre class="language-php text-xs rounded-lg bg-zinc-950 p-3"><code>try {
    $conteudo = File::get('/caminho/para/arquivo.txt');
} catch (\Exception $e) {
    // Ficheiro não existe
}</code></pre>
                                </div>

                                {{-- Method: PUT --}}
                                <div class="rounded-xl border border-zinc-200 bg-zinc-50 p-4 dark:border-zinc-800 dark:bg-zinc-900/30">
                                    <h3 class="font-mono text-sm font-bold text-primary mb-2">File::put($path, $contents, $permissions)</h3>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400 mb-2">Grava conteúdo. <strong class="text-purple-500">Cria diretórios automaticamente</strong> se não existirem.</p>
                                    <pre class="language-php text-xs rounded-lg bg-zinc-950 p-3"><code>// Cria pasta 'logs/2024/' automaticamente
File::put('logs/2024/erro.log', 'Conteúdo do log');

// Com permissões específicas (0755)
File::put('scripts/executavel.sh', '#!/bin/bash...', 0755);</code></pre>
                                </div>

                                {{-- Other Methods --}}
                                <div class="grid gap-4 md:grid-cols-3">
                                    <div class="rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-800 dark:bg-zinc-900/50">
                                        <h3 class="font-mono text-sm font-bold text-primary mb-1">File::delete($path)</h3>
                                        <p class="text-xs text-zinc-500">Remove ficheiro do sistema.</p>
                                    </div>
                                    <div class="rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-800 dark:bg-zinc-900/50">
                                        <h3 class="font-mono text-sm font-bold text-primary mb-1">File::fileExists($path)</h3>
                                        <p class="text-xs text-zinc-500">Verifica se existe (bool).</p>
                                    </div>
                                    <div class="rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-800 dark:bg-zinc-900/50">
                                        <h3 class="font-mono text-sm font-bold text-primary mb-1">File::copy($from, $to)</h3>
                                        <p class="text-xs text-zinc-500">Copia criando pastas destino.</p>
                                    </div>
                                </div>
                            </div>
                        </section>

                        {{-- Directories --}}
                        <section id="diretorios" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                <flux:icon.folder class="size-6 text-amber-500" />
                                Gestão de Diretórios
                            </h2>
                            <div class="grid gap-4 md:grid-cols-2">
                                <div class="rounded-xl bg-zinc-950 p-4">
                                    <code class="text-sm font-bold text-purple-400 block mb-2">File::ensureDirectoryExists($path)</code>
                                    <p class="text-xs text-zinc-400 mb-2">Garante existência, cria se necessário.</p>
                                    <pre class="text-xs text-zinc-500">File::ensureDirectoryExists('storage/uploads/2024');</pre>
                                </div>
                                <div class="rounded-xl bg-zinc-950 p-4">
                                    <code class="text-sm font-bold text-purple-400 block mb-2">File::makeDirectory($path, $mode, $recursive)</code>
                                    <p class="text-xs text-zinc-400 mb-2">Criação com controlo total.</p>
                                    <pre class="text-xs text-zinc-500">File::makeDirectory('a/b/c', 0755, true);</pre>
                                </div>
                            </div>
                        </section>

                        {{-- Streams --}}
                        <section id="streams" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.arrow-down-tray class="size-6 text-blue-500" />
                                    Streams e Downloads
                                </h2>
                                <p class="text-zinc-700 dark:text-zinc-300">
                                    Métodos otimizados para evitar carregar ficheiros grandes para a memória RAM.
                                </p>
                            </div>

                            <div class="rounded-xl bg-zinc-950 p-4 text-sm overflow-x-auto">
                                <pre class="language-php"><code>// 1. Escrever Stream em Disco (útil para uploads grandes)
$stream = fopen('php://temp', 'r+');
// ... escrever no stream ...
rewind($stream);
File::writeStream($stream, 'storage/big_file.dat');

// 2. Download para Browser via Stream (sem carregar tudo em memória)
public function export() {
    $stream = fopen('php://memory', 'r+');
    fputcsv($stream, ['ID', 'Nome']);
    rewind($stream);
    
    File::streamDownload('export.csv', $stream, 'text/csv');
}</code></pre>
                            </div>
                        </section>

                        {{-- Facade Reference --}}
                        <section id="facade" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                <flux:icon.table-cells class="size-6 text-zinc-500" />
                                Facade API
                            </h2>
                            <div class="overflow-hidden rounded-xl border border-zinc-200 dark:border-zinc-800 bg-white dark:bg-zinc-900/50">
                                <table class="min-w-full divide-y divide-zinc-200 dark:divide-zinc-800">
                                    <thead class="bg-zinc-50 dark:bg-zinc-900/80">
                                        <tr>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-zinc-500 uppercase tracking-wider">Método</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-zinc-500 uppercase tracking-wider">Retorno</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-zinc-500 uppercase tracking-wider">Descrição</th>
                                        </tr>
                                    </thead>
                                    <tbody class="divide-y divide-zinc-200 dark:divide-zinc-800">
                                        <tr>
                                            <td class="px-6 py-4 whitespace-nowrap font-mono text-xs text-purple-600 dark:text-purple-400">get($path)</td>
                                            <td class="px-6 py-4 whitespace-nowrap text-xs text-zinc-600 dark:text-zinc-400">string</td>
                                            <td class="px-6 py-4 text-xs text-zinc-600 dark:text-zinc-400">Conteúdo do ficheiro</td>
                                        </tr>
                                        <tr>
                                            <td class="px-6 py-4 whitespace-nowrap font-mono text-xs text-purple-600 dark:text-purple-400">put($path, $content)</td>
                                            <td class="px-6 py-4 whitespace-nowrap text-xs text-zinc-600 dark:text-zinc-400">bool</td>
                                            <td class="px-6 py-4 text-xs text-zinc-600 dark:text-zinc-400">Grava conteúdo (cria dirs auto)</td>
                                        </tr>
                                        <tr>
                                            <td class="px-6 py-4 whitespace-nowrap font-mono text-xs text-purple-600 dark:text-purple-400">delete($path)</td>
                                            <td class="px-6 py-4 whitespace-nowrap text-xs text-zinc-600 dark:text-zinc-400">bool</td>
                                            <td class="px-6 py-4 text-xs text-zinc-600 dark:text-zinc-400">Apaga ficheiro</td>
                                        </tr>
                                        <tr>
                                            <td class="px-6 py-4 whitespace-nowrap font-mono text-xs text-purple-600 dark:text-purple-400">ensureDirectoryExists</td>
                                            <td class="px-6 py-4 whitespace-nowrap text-xs text-zinc-600 dark:text-zinc-400">void</td>
                                            <td class="px-6 py-4 text-xs text-zinc-600 dark:text-zinc-400">Cria diretório se não existir</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </section>

                        {{-- Real Examples --}}
                        <section id="exemplos" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <div class="prose prose-zinc dark:prose-invert max-w-none">
                                <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                    <flux:icon.beaker class="size-6 text-amber-500" />
                                    Exemplos Práticos
                                </h2>
                            </div>

                            <div class="space-y-6">
                                {{-- Exemplo 1 --}}
                                <div class="rounded-xl border border-zinc-200 bg-white p-6 shadow-sm dark:border-zinc-800 dark:bg-zinc-900/50">
                                    <h4 class="font-semibold text-zinc-900 dark:text-white mb-2">1. Cache de Rotas (JSON)</h4>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400 mb-3">Leitura e escrita segura de JSON.</p>
                                    <pre class="text-xs bg-zinc-950 p-3 rounded-lg text-zinc-300 overflow-x-auto"><code>public function saveRouteCache(array $routes): void
{
    // Grava e subscreve o ficheiro de cache
    File::put('bootstrap/cache/routes.json', json_encode($routes));
}</code></pre>
                                </div>

                                {{-- Exemplo 2 --}}
                                <div class="rounded-xl border border-zinc-200 bg-white p-6 shadow-sm dark:border-zinc-800 dark:bg-zinc-900/50">
                                    <h4 class="font-semibold text-zinc-900 dark:text-white mb-2">2. Geração de Código (Stubs)</h4>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400 mb-3">Uso extensivo em comandos CLI.</p>
                                    <pre class="text-xs bg-zinc-950 p-3 rounded-lg text-zinc-300 overflow-x-auto"><code>if (File::fileExists($path)) {
    throw new \Exception("Action já existe!");
}

File::ensureDirectoryExists(dirname($path));
$stub = File::get(__DIR__.'/stubs/action.stub');
File::put($path, str_replace('@{{class}}', $name, $stub));</code></pre>
                                </div>

                                {{-- Exemplo 3 --}}
                                <div class="rounded-xl border border-zinc-200 bg-white p-6 shadow-sm dark:border-zinc-800 dark:bg-zinc-900/50">
                                    <h4 class="font-semibold text-zinc-900 dark:text-white mb-2">3. QueueMaster Crash Recovery</h4>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400 mb-3">Escrita de dumps de emergência.</p>
                                    <pre class="text-xs bg-zinc-950 p-3 rounded-lg text-zinc-300 overflow-x-auto"><code>// O método put encarrega-se de criar a pasta 'storage/crash_dumps/'
File::put('storage/crash_dumps/' . date('Y-m-d') . '.json', $json);</code></pre>
                                </div>
                            </div>
                        </section>

                        {{-- Navigation --}}
                        <div class="flex justify-between items-center pt-8 border-t border-zinc-200 dark:border-zinc-800">
                            <a href="{{ route('docs.show', 'cache') }}" class="inline-flex items-center gap-2 text-sm text-zinc-600 dark:text-zinc-400 hover:text-primary">
                                <flux:icon.arrow-left class="size-4" />
                                Cache
                            </a>
                            <a href="{{ route('docs.show', 'routing') }}" class="inline-flex items-center gap-2 text-sm font-medium text-primary hover:underline">
                                Routing
                                <flux:icon.arrow-right class="size-4" />
                            </a>
                        </div>
                    </div>

                </div>
            </div>

            {{-- Right Sidebar: Table of Contents --}}
            @include('docs.partials.toc', ['sections' => [
                'introducao' => 'Introdução',
                'arquitetura' => 'Arquitetura',
                'recuperar-guardar' => 'Recuperar e Guardar',
                'diretorios' => 'Diretórios',
                'streams' => 'Streams e Downloads',
                'facade' => 'Facade File',
                'exemplos' => 'Exemplos Práticos',
            ]])
        </div>
    </div>
@endsection
