@extends('layouts.docs')

@section('title', 'Helpers System - OG Framework')

@section('body')
    <div class="relative min-h-screen bg-transparent px-4 pb-12 pt-6 sm:px-6 lg:px-8">
        {{-- Floating shapes for styling --}}
        <div class="floating-blur cyan -left-10 -top-10 hidden lg:block"></div>
        <div class="floating-blur purple right-10 top-32 hidden lg:block"></div>

        <div class="mx-auto flex w-full max-w-7xl gap-8 bg-transparent">
            {{-- Left Sidebar: Navigation --}}
            @include('docs.partials.sidebar')

            {{-- Main Content --}}
            <div class="flex-1 min-w-0">
                <div class="relative overflow-hidden rounded-3xl border border-white/50 bg-white/85 p-8 shadow-xl shadow-primary/20 backdrop-blur dark:border-zinc-800 dark:bg-zinc-900/80">

                    {{-- Page Header --}}
                    <div class="mb-8">
                        <a href="{{ route('docs.index') }}" class="inline-flex items-center gap-1 text-sm text-primary hover:underline mb-4">
                            <flux:icon.arrow-left class="size-4" />
                            Voltar para Documentação
                        </a>
                        <p class="text-xs uppercase tracking-[0.3em] text-primary dark:text-blue-200">Core</p>
                        <h1 class="font-display text-4xl font-bold text-zinc-900 dark:text-white sm:text-5xl">Helpers System</h1>
                        <p class="mt-3 text-base text-zinc-700 dark:text-zinc-200 max-w-3xl">
                            O Framework OfficeGest fornece um ecossistema rico de funções auxiliares que aumentam a produtividade. Oferece funções globais e classes estáticas otimizadas para uso frequente em qualquer parte da aplicação.
                        </p>
                    </div>

                    <div class="space-y-10">

                        {{-- Introduction --}}
                        <section id="visao-geral" class="scroll-mt-28 space-y-4">
                            <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                <flux:icon.book-open class="size-6 text-orange-500" />
                                Visão Geral
                            </h2>
                            <p class="text-zinc-700 dark:text-zinc-300">
                                Os helpers encontram-se em <code>Modules/Common/Helpers/</code> e dividem-se em duas categorias:
                            </p>
                            <div class="grid gap-4 md:grid-cols-2">
                                <div class="rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-800 dark:bg-zinc-900/50">
                                    <h3 class="font-bold text-zinc-900 dark:text-white mb-2 flex items-center gap-2">
                                        <flux:icon.globe-alt class="size-5 text-pink-500" />
                                        Funções Globais
                                    </h3>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400">
                                        Disponíveis em qualquer lugar: <code>app()</code>, <code>config()</code>, <code>request()</code>, <code>route()</code>, <code>logger()</code>. Não precisam de import.
                                    </p>
                                </div>
                                <div class="rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-800 dark:bg-zinc-900/50">
                                    <h3 class="font-bold text-zinc-900 dark:text-white mb-2 flex items-center gap-2">
                                        <flux:icon.cube class="size-5 text-blue-500" />
                                        Classes Estáticas
                                    </h3>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400">
                                        Para operações complexas: <code>ArrayHelper</code>, <code>StringHelper</code>, <code>DataTableHelper</code>, <code>Response</code>. Requerem <code>use</code>.
                                    </p>
                                </div>
                            </div>
                        </section>

                        {{-- Global Functions --}}
                        <section id="funcoes-globais" class="scroll-mt-28 space-y-6 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                <flux:icon.globe-alt class="size-6 text-pink-500" />
                                Funções Globais
                            </h2>
                            <p class="text-zinc-700 dark:text-zinc-300">
                                Ficheiro: <code>Modules/Common/Helpers/Helpers.php</code>. Estas funções estão disponíveis em Controllers, Views, Classes, etc.
                            </p>

                            {{-- Application & Config --}}
                            <div class="space-y-4">
                                <h3 class="font-bold text-lg text-zinc-900 dark:text-white border-b border-zinc-200 dark:border-zinc-700 pb-2">
                                    Aplicação e Configuração
                                </h3>
                                <div class="rounded-xl bg-zinc-950 p-4 text-sm overflow-x-auto">
                                    <pre class="language-php"><code>// app() - Acede ao Service Container (Injeção de Dependência)
$container = app();
$service = app(ConfigurationService::class);

// config() - Obtém configuração com "dot notation"
$debug = config('app.debug');
$timezone = config('app.timezone', 'UTC'); // Com valor default

// envVar() - Variáveis de ambiente com tipagem inteligente
// Converte "true"/"false" strings para booleanos reais
$debug = envVar('APP_DEBUG', false);</code></pre>
                                </div>
                            </div>

                            {{-- Strings & Arrays --}}
                            <div class="space-y-4">
                                <h3 class="font-bold text-lg text-zinc-900 dark:text-white border-b border-zinc-200 dark:border-zinc-700 pb-2">
                                    Strings e Arrays
                                </h3>
                                <div class="grid gap-4 md:grid-cols-2">
                                    <div class="rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-800 dark:bg-zinc-900/50">
                                        <h4 class="font-semibold text-zinc-900 dark:text-white mb-2 text-sm">Conversão de Case</h4>
                                        <pre class="text-xs bg-zinc-950 p-3 rounded-lg text-zinc-300"><code>snakeCase('fooBar');   // 'foo_bar'
camelCase('foo_bar');  // 'fooBar'
kebabCase('fooBar');   // 'foo-bar'
studlyCase('foo_bar'); // 'FooBar'
titleCase('a new title'); // 'A New Title'</code></pre>
                                    </div>
                                    <div class="rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-800 dark:bg-zinc-900/50">
                                        <h4 class="font-semibold text-zinc-900 dark:text-white mb-2 text-sm">Validação e Encoding</h4>
                                        <pre class="text-xs bg-zinc-950 p-3 rounded-lg text-zinc-300"><code>isJson($payload);      // Valida JSON
randomString(32);      // Token alfanumérico
forceBoolean('true');  // Converte para bool
utf8Encode($legacy);   // ISO-8859-1 -> UTF-8</code></pre>
                                    </div>
                                </div>
                            </div>

                            {{-- URLs & Routes --}}
                            <div class="space-y-4">
                                <h3 class="font-bold text-lg text-zinc-900 dark:text-white border-b border-zinc-200 dark:border-zinc-700 pb-2">
                                    URLs e Rotas
                                </h3>
                                <div class="rounded-xl bg-zinc-950 p-4 text-sm overflow-x-auto">
                                    <pre class="language-php"><code>// route() - Gera URLs para rotas nomeadas
// ESSENCIAL para manter a aplicação desacoplada de URLs hardcoded
$url = route('users.edit', ['id' => 1]);

// websiteUrl() - URLs absolutas para assets públicos
$logo = websiteUrl('img/logo.png');

// sanitizeUrl() - Limpa e valida URLs
$clean = sanitizeUrl('www.google.com'); // 'http://www.google.com'</code></pre>
                                </div>
                            </div>

                            {{-- HTTP & Responses --}}
                            <div class="space-y-4">
                                <h3 class="font-bold text-lg text-zinc-900 dark:text-white border-b border-zinc-200 dark:border-zinc-700 pb-2">
                                    HTTP e Responses
                                </h3>
                                <div class="rounded-xl bg-zinc-950 p-4 text-sm overflow-x-auto">
                                    <pre class="language-php"><code>// request() - Acede ao Request atual
$request = request();
$name = request('name', 'Guest');

// response() - Cria resposta HTTP fluente
return response('Hello', 200, ['X-Custom' => 'Value']);

// abort() e variantes condicionais
abort(403, 'Forbidden');
abortIf(!Auth::user()->isAdmin(), 403);
abortUnless(Auth::check(), 401);

// csrf_token() - Token CSRF da sessão
&lt;input type="hidden" name="_token" value="&lt;?= csrf_token() ?&gt;"&gt;</code></pre>
                                </div>
                            </div>

                            {{-- Debug & Logging --}}
                            <div class="space-y-4">
                                <h3 class="font-bold text-lg text-zinc-900 dark:text-white border-b border-zinc-200 dark:border-zinc-700 pb-2">
                                    Debug e Logging
                                </h3>
                                <div class="rounded-xl border border-amber-200 bg-amber-50 p-4 dark:border-amber-900/50 dark:bg-amber-900/20">
                                    <pre class="text-xs bg-white dark:bg-black/20 p-2 rounded"><code>// logger() - Instância Monolog
logger()->info('Job started');

// loggerBatch() - Múltiplas entradas de uma só vez
// Útil para não "bombardear" o disco com múltiplas escritas
loggerBatch('error', 'Error occurred', ['ctx' => $data]);

// requestDebugger() - Despeja estado completo do request
// Extremamente útil para debugar webhooks de terceiros
requestDebugger();</code></pre>
                                </div>
                            </div>
                        </section>

                        {{-- ArrayHelper --}}
                        <section id="array-helper" class="scroll-mt-28 space-y-6 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                <flux:icon.list-bullet class="size-6 text-blue-500" />
                                ArrayHelper
                            </h2>
                            <p class="text-zinc-700 dark:text-zinc-300">
                                Classe: <code>Og\Modules\Common\Helpers\ArrayHelper</code><br>
                                Uma "Powerhouse" para manipulação de dados complexos com suporte completo a <strong>Dot Notation</strong>.
                            </p>

                            {{-- Dot Notation --}}
                            <div class="space-y-4">
                                <h3 class="font-bold text-lg text-zinc-900 dark:text-white border-b border-zinc-200 dark:border-zinc-700 pb-2">
                                    Dot Notation (Acesso Profundo)
                                </h3>
                                <div class="rounded-xl bg-zinc-950 p-4 text-sm overflow-x-auto">
                                    <pre class="language-php"><code>use Og\Modules\Common\Helpers\ArrayHelper;

$data = ['users' => ['john' => ['role' => 'admin']]];

// get() - Recupera valores aninhados com segurança
$role = ArrayHelper::get($data, 'users.john.role'); // 'admin'
$missing = ArrayHelper::get($data, 'users.pete.role', 'guest'); // 'guest'

// set() - Define valores em profundidade, criando estrutura
$data = [];
ArrayHelper::set($data, 'system.settings.dark_mode', true);
// Resultado: ['system' => ['settings' => ['dark_mode' => true]]]</code></pre>
                                </div>

                                <div class="rounded-xl border border-blue-200 bg-blue-50 p-4 dark:border-blue-900/50 dark:bg-blue-900/20">
                                    <h4 class="font-semibold text-blue-900 dark:text-blue-200 mb-2 text-sm flex items-center gap-2">
                                        <flux:icon.sparkles class="size-4" />
                                        Wildcards com dotSearch()
                                    </h4>
                                    <pre class="text-xs bg-white dark:bg-black/20 p-2 rounded"><code>$users = [
    ['id' => 1, 'name' => 'Ana', 'meta' => ['active' => true]],
    ['id' => 2, 'name' => 'Rui', 'meta' => ['active' => false]],
];

// Obter todos os nomes
$names = ArrayHelper::dotSearch('*.name', $users); // ['Ana', 'Rui']

// Obter status de todos
$actives = ArrayHelper::dotSearch('*.meta.active', $users); // [true, false]</code></pre>
                                </div>
                            </div>

                            {{-- Transformations --}}
                            <div class="space-y-4">
                                <h3 class="font-bold text-lg text-zinc-900 dark:text-white border-b border-zinc-200 dark:border-zinc-700 pb-2">
                                    Transformações
                                </h3>
                                <div class="grid gap-4 md:grid-cols-2">
                                    <div class="rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-800 dark:bg-zinc-900/50">
                                        <h4 class="font-semibold text-zinc-900 dark:text-white mb-2 text-sm">dot() e undot()</h4>
                                        <pre class="text-xs bg-zinc-950 p-3 rounded-lg text-zinc-300"><code>// Achata array em chaves com ponto
ArrayHelper::dot(['a' => ['b' => 'c']]);
// ['a.b' => 'c']

// Reverte o processo
ArrayHelper::undot(['a.b' => 'c']);
// ['a' => ['b' => 'c']]</code></pre>
                                    </div>
                                    <div class="rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-800 dark:bg-zinc-900/50">
                                        <h4 class="font-semibold text-zinc-900 dark:text-white mb-2 text-sm">map() e flatten()</h4>
                                        <pre class="text-xs bg-zinc-950 p-3 rounded-lg text-zinc-300"><code>// Map que preserva chaves
ArrayHelper::map($users, fn($u) => $u['name']);

// Achata multidimensional
ArrayHelper::flatten([1, [2, 3], [[4]]]);
// [1, 2, 3, 4]</code></pre>
                                    </div>
                                </div>
                            </div>

                            {{-- Filtering --}}
                            <div class="space-y-4">
                                <h3 class="font-bold text-lg text-zinc-900 dark:text-white border-b border-zinc-200 dark:border-zinc-700 pb-2">
                                    Filtragem e Pesquisa
                                </h3>
                                <div class="rounded-xl bg-zinc-950 p-4 text-sm overflow-x-auto">
                                    <pre class="language-php"><code>// where() - Filtra mantendo apenas matches
$adults = ArrayHelper::where($users, fn($u) => $u['age'] >= 18);

// firstWhere() - Primeiro elemento que satisfaz condição
$admin = ArrayHelper::firstWhere($users, fn($u) => $u['role'] === 'admin');

// only() e except() - Subconjuntos de chaves
$publicData = ArrayHelper::except($userData, ['password', 'token']);
$minimal = ArrayHelper::only($userData, ['id', 'name']);

// pluck() - Extrai lista de valores de uma chave
$ids = ArrayHelper::pluck($users, 'id'); // [1, 2]</code></pre>
                                </div>
                            </div>
                        </section>

                        {{-- StringHelper --}}
                        <section id="string-helper" class="scroll-mt-28 space-y-6 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                <flux:icon.language class="size-6 text-purple-500" />
                                StringHelper
                            </h2>
                            <p class="text-zinc-700 dark:text-zinc-300">
                                Classe: <code>Og\Modules\Common\Helpers\StringHelper</code><br>
                                Utilitários para manipulação avançada de strings.
                            </p>

                            <div class="grid gap-6 lg:grid-cols-2">
                                <div class="rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-800 dark:bg-zinc-900/50">
                                    <h3 class="font-bold text-zinc-900 dark:text-white mb-2 text-sm">Conversão de Case</h3>
                                    <pre class="text-xs bg-zinc-950 p-3 rounded-lg text-zinc-300"><code>StringHelper::toSnakeCase($str);
StringHelper::toCamelCase($str);
StringHelper::toPascalCase($str);
StringHelper::toKebabCase($str);

// Detecta automaticamente o formato
StringHelper::detectCase('userName');
// 'camelCase'</code></pre>
                                </div>

                                <div class="rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-800 dark:bg-zinc-900/50">
                                    <h3 class="font-bold text-zinc-900 dark:text-white mb-2 text-sm">Manipulação de Texto</h3>
                                    <pre class="text-xs bg-zinc-950 p-3 rounded-lg text-zinc-300"><code>// Slugs para URLs
StringHelper::slug('Café & Leite');
// 'cafe-leite'

// Truncar sem quebrar palavras
StringHelper::truncatePreserveWords(
    'Hello beautiful world', 10
); // "Hello..."

// Extrair apenas números
StringHelper::extractNumbers('12.50€');
// "12.50"</code></pre>
                                </div>
                            </div>
                        </section>

                        {{-- DataTableHelper --}}
                        <section id="datatable-helper" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                <flux:icon.table-cells class="size-6 text-green-500" />
                                DataTableHelper
                            </h2>
                            <p class="text-zinc-700 dark:text-zinc-300">
                                Classe: <code>Og\Modules\Common\Helpers\DataTableHelper</code><br>
                                Fundamental para integração com jQuery DataTables no backoffice. Gere a "tradução" entre o request complexo do DataTables e os parâmetros que os Services esperam.
                            </p>

                            <div class="rounded-xl border border-green-200 bg-green-50 p-4 dark:border-green-900/50 dark:bg-green-900/20">
                                <h3 class="font-semibold text-green-900 dark:text-green-200 mb-2 text-sm">Fluxo Padrão de Uso</h3>
                                <pre class="text-xs bg-white dark:bg-black/20 p-2 rounded"><code>public function listUsers() {
    // 1. Converter request do DataTables em parâmetros padronizados
    // (page, limit, order, search, filters)
    $params = DataTableHelper::prepareParams(request()->all());

    // 2. Obter dados do Service
    $result = $this->userService->list($params);

    // 3. Devolver JSON formatado para o DataTables
    return DataTableHelper::returnToDataTable(
        draw: (int)request('draw'),
        totalLines: $result['total'],
        data: $result['data']
    );
}</code></pre>
                            </div>
                        </section>

                        {{-- Response Helper --}}
                        <section id="response-helper" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                <flux:icon.server class="size-6 text-sky-500" />
                                Response Helper
                            </h2>
                            <p class="text-zinc-700 dark:text-zinc-300">
                                Classe: <code>Og\Modules\Common\Helpers\Response</code><br>
                                Métodos estáticos para respostas HTTP especializadas, além do helper global <code>response()</code>.
                            </p>

                            <div class="grid gap-4 md:grid-cols-2 lg:grid-cols-4">
                                <div class="rounded-xl bg-zinc-950 p-4 text-zinc-300">
                                    <p class="text-xs font-mono text-sky-400 mb-2">JSON</p>
                                    <pre class="text-xs">Response::json(
    $data,
    $status = 200
);</pre>
                                </div>
                                <div class="rounded-xl bg-zinc-950 p-4 text-zinc-300">
                                    <p class="text-xs font-mono text-green-400 mb-2">Download</p>
                                    <pre class="text-xs">Response::download(
    $path,
    $filename
);</pre>
                                </div>
                                <div class="rounded-xl bg-zinc-950 p-4 text-zinc-300">
                                    <p class="text-xs font-mono text-purple-400 mb-2">Stream (Large Files)</p>
                                    <pre class="text-xs">Response::streamDownload(
    $callback,
    $filename
);</pre>
                                </div>
                                <div class="rounded-xl bg-zinc-950 p-4 text-zinc-300">
                                    <p class="text-xs font-mono text-amber-400 mb-2">JSONP (Legacy)</p>
                                    <pre class="text-xs">Response::jsonp(
    $callback,
    $data
);</pre>
                                </div>
                            </div>
                        </section>

                        {{-- Quick Reference Table --}}
                        <section id="referencia" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                <flux:icon.clipboard-document-list class="size-6 text-zinc-500" />
                                Referência Rápida
                            </h2>
                            <div class="overflow-hidden rounded-xl border border-zinc-200 dark:border-zinc-800 bg-white dark:bg-zinc-900/50">
                                <table class="min-w-full divide-y divide-zinc-200 dark:divide-zinc-800">
                                    <thead class="bg-zinc-50 dark:bg-zinc-900/80">
                                        <tr>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-zinc-500 uppercase">Categoria</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-zinc-500 uppercase">Funções Principais</th>
                                        </tr>
                                    </thead>
                                    <tbody class="divide-y divide-zinc-200 dark:divide-zinc-800">
                                        <tr>
                                            <td class="px-6 py-3 font-semibold text-xs text-zinc-700 dark:text-zinc-300">Container</td>
                                            <td class="px-6 py-3 font-mono text-xs text-pink-600">app(), config(), envVar()</td>
                                        </tr>
                                        <tr>
                                            <td class="px-6 py-3 font-semibold text-xs text-zinc-700 dark:text-zinc-300">Request</td>
                                            <td class="px-6 py-3 font-mono text-xs text-pink-600">request(), abort(), abortIf()</td>
                                        </tr>
                                        <tr>
                                            <td class="px-6 py-3 font-semibold text-xs text-zinc-700 dark:text-zinc-300">Response</td>
                                            <td class="px-6 py-3 font-mono text-xs text-pink-600">response(), route(), url()</td>
                                        </tr>
                                        <tr>
                                            <td class="px-6 py-3 font-semibold text-xs text-zinc-700 dark:text-zinc-300">Logging</td>
                                            <td class="px-6 py-3 font-mono text-xs text-pink-600">logger(), loggerBatch(), requestDebugger()</td>
                                        </tr>
                                        <tr>
                                            <td class="px-6 py-3 font-semibold text-xs text-zinc-700 dark:text-zinc-300">Arrays</td>
                                            <td class="px-6 py-3 font-mono text-xs text-blue-600">ArrayHelper::get(), ::set(), ::pluck()</td>
                                        </tr>
                                        <tr>
                                            <td class="px-6 py-3 font-semibold text-xs text-zinc-700 dark:text-zinc-300">Strings</td>
                                            <td class="px-6 py-3 font-mono text-xs text-purple-600">StringHelper::slug(), ::toSnakeCase()</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </section>

                        {{-- Navigation --}}
                        <div class="flex justify-between items-center pt-8 border-t border-zinc-200 dark:border-zinc-800">
                            <a href="{{ route('docs.show', 'routing') }}" class="inline-flex items-center gap-2 text-sm text-zinc-600 dark:text-zinc-400 hover:text-primary">
                                <flux:icon.arrow-left class="size-4" />
                                Routing
                            </a>
                            <a href="{{ route('docs.show', 'cache') }}" class="inline-flex items-center gap-2 text-sm font-medium text-primary hover:underline">
                                Cache System
                                <flux:icon.arrow-right class="size-4" />
                            </a>
                        </div>
                    </div>

                </div>
            </div>

            {{-- Right Sidebar: Table of Contents --}}
            @include('docs.partials.toc', ['sections' => [
                'visao-geral' => 'Visão Geral',
                'funcoes-globais' => 'Funções Globais',
                'array-helper' => 'ArrayHelper',
                'string-helper' => 'StringHelper',
                'datatable-helper' => 'DataTableHelper',
                'response-helper' => 'Response Helper',
                'referencia' => 'Referência Rápida',
            ]])
        </div>
    </div>
@endsection
