@extends('layouts.docs')

@section('title', 'Documentação OG Framework')

@section('body')
    <div class="relative min-h-screen bg-transparent px-4 pb-12 pt-6 sm:px-6 lg:px-8">
        <div class="floating-blur blue -left-10 -top-10 hidden lg:block"></div>
        <div class="floating-blur amber right-10 top-32 hidden lg:block"></div>
        <div class="floating-blur teal left-1/3 bottom-10 hidden lg:block"></div>

        <div class="mx-auto flex w-full max-w-7xl flex-col gap-8 lg:flex-row bg-transparent">
            @include('docs.partials.sidebar')

            <div class="flex-1">
                {{-- Hero Section --}}
                <div class="relative overflow-hidden rounded-3xl border border-white/50 bg-white/85 p-8 shadow-xl shadow-primary/20 backdrop-blur dark:border-zinc-800 dark:bg-zinc-900/80">
                    <div class="relative z-10 space-y-4 max-w-3xl">
                        <p class="text-xs uppercase tracking-[0.3em] text-primary">Introdução</p>
                        <h1 class="font-display text-4xl font-bold text-zinc-900 dark:text-white sm:text-5xl">OG Framework — visão geral.</h1>
                        <p class="text-base text-zinc-700 dark:text-zinc-200">
                            O OG Framework é a camada moderna do ERP: DI, rotas, filas e CLI convivendo com o legado. Aqui você encontra como a arquitetura funciona, como inicializar o stack, e o que cada subsistema oferece para construir módulos sem quebrar o core existente.
                        </p>
                    </div>
                </div>

                {{-- Quick Start Cards --}}
                <div class="mt-8 space-y-6">
                    <div>
                        <h2 class="text-xl font-semibold text-zinc-900 dark:text-white mb-4">Arquitetura</h2>
                        <div class="grid gap-4 md:grid-cols-2 lg:grid-cols-4">
                            <a href="{{ route('docs.show', 'bootstrap') }}" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-amber-100 dark:bg-amber-900/30">
                                        <flux:icon.bolt class="size-5 text-amber-600 dark:text-amber-400" />
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Bootstrap</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">Inicialização</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Pontos de entrada, bootstrappers, ciclo de vida.
                                </p>
                            </a>

                            <a href="{{ route('docs.show', 'container') }}" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-blue-100 dark:bg-blue-900/30">
                                        <flux:icon.cube class="size-5 text-blue-600 dark:text-blue-400" />
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Container</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">DI & Bindings</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Facades, auto-wiring, código testável.
                                </p>
                            </a>

                            <a href="{{ route('docs.show', 'service-providers') }}" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-purple-100 dark:bg-purple-900/30">
                                        <flux:icon.puzzle-piece class="size-5 text-purple-600 dark:text-purple-400" />
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Service Providers</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">Configuração</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Registro de serviços, 16 providers, lifecycle.
                                </p>
                            </a>

                            <a href="{{ route('docs.show', 'auth') }}" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-red-100 dark:bg-red-900/30">
                                        <flux:icon.shield-check class="size-5 text-red-600 dark:text-red-400" />
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Autenticação</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">Segurança</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    AuthManager, Policies, Impersonation.
                                </p>
                            </a>

                            <a href="{{ route('docs.show', 'facades') }}" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-cyan-100 dark:bg-cyan-900/30">
                                        <flux:icon.window class="size-5 text-cyan-600 dark:text-cyan-400" />
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Facades</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">Syntax Sugar</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Interface estática para serviços, 11 facades.
                                </p>
                            </a>

                            <a href="{{ route('docs.show', 'cache') }}" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-orange-100 dark:bg-orange-900/30">
                                        <flux:icon.circle-stack class="size-5 text-orange-600 dark:text-orange-400" />
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Cache</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">Performance</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Drivers Redis/File e estratégias de cache.
                                </p>
                            </a>

                            <a href="{{ route('docs.show', 'filesystem') }}" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-purple-100 dark:bg-purple-900/30">
                                        <flux:icon.folder class="size-5 text-purple-600 dark:text-purple-400" />
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Filesystem</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">Storage</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Gestão de I/O, downloads e streams.
                                </p>
                            </a>

                            <a href="{{ route('docs.show', 'routing') }}" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-green-100 dark:bg-green-900/30">
                                        <flux:icon.map class="size-5 text-green-600 dark:text-green-400" />
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Routing</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">HTTP</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Rotas, grupos, middleware e dispatching.
                                </p>
                            </a>

                            <a href="{{ route('docs.show', 'helpers') }}" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-pink-100 dark:bg-pink-900/30">
                                        <flux:icon.code-bracket class="size-5 text-pink-600 dark:text-pink-400" />
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Helpers</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">Utilities</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Arrays, Strings e funções globais.
                                </p>
                            </a>

                            <a href="{{ route('docs.show', 'resources') }}" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-indigo-100 dark:bg-indigo-900/30">
                                        <flux:icon.arrows-right-left class="size-5 text-indigo-600 dark:text-indigo-400" />
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Resources (DTOs)</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">API</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Serialização JSON com campos condicionais.
                                </p>
                            </a>

                            <a href="{{ route('docs.show', 'notifications') }}" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-amber-100 dark:bg-amber-900/30">
                                        <flux:icon.bell class="size-5 text-amber-600 dark:text-amber-400" />
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Notificações</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">Comunicação</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Multi-canal: Database, Email, Mattermost.
                                </p>
                            </a>

                            <a href="{{ route('docs.show', 'validation') }}" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-rose-100 dark:bg-rose-900/30">
                                        <flux:icon.check-badge class="size-5 text-rose-600 dark:text-rose-400" />
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Validação</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">Forms & Data</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Rules, BaseRequest, Custom validation.
                                </p>
                            </a>

                            <a href="{{ route('docs.show', 'web-layer') }}" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-cyan-100 dark:bg-cyan-900/30">
                                        <flux:icon.globe-alt class="size-5 text-cyan-600 dark:text-cyan-400" />
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Web Layer</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">HTTP & API</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Controllers, Request, Response, Routing.
                                </p>
                            </a>
                        </div>
                    </div>

                    {{-- Coming Soon --}}
                    <div>
                        <h2 class="text-xl font-semibold text-zinc-900 dark:text-white mb-4">Em breve</h2>
                        <div class="grid gap-4 md:grid-cols-2">
                            <div class="feature-card opacity-60 cursor-not-allowed">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-zinc-100 dark:bg-zinc-800">
                                        <flux:icon.queue-list class="size-5 text-zinc-400" />
                                    </span>
                                    <p class="font-semibold text-zinc-500">Filas</p>
                                </div>
                                <p class="text-sm text-zinc-500">Jobs, workers, e QueueMaster.</p>
                            </div>
                        </div>
                    </div>

                    {{-- Concepts Overview --}}
                    <div class="rounded-3xl border border-white/50 bg-white/85 p-8 shadow-lg backdrop-blur dark:border-zinc-800 dark:bg-zinc-900/80">
                        <h2 class="text-xl font-semibold text-zinc-900 dark:text-white mb-4">Conceitos Fundamentais</h2>

                        <div class="grid gap-4 md:grid-cols-2">
                            <div class="flex items-start gap-3">
                                <flux:icon.bolt class="size-5 text-amber-500 mt-0.5" />
                                <div>
                                    <p class="font-semibold text-zinc-900 dark:text-white">Service Providers</p>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400">Porta de entrada para registrar serviços. Métodos <code>register()</code> e <code>boot()</code>.</p>
                                </div>
                            </div>
                            <div class="flex items-start gap-3">
                                <flux:icon.arrows-right-left class="size-5 text-blue-500 mt-0.5" />
                                <div>
                                    <p class="font-semibold text-zinc-900 dark:text-white">Middleware Pipeline</p>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400">Requests passam por cadeia de middlewares antes do controller.</p>
                                </div>
                            </div>
                            <div class="flex items-start gap-3">
                                <flux:icon.queue-list class="size-5 text-green-500 mt-0.5" />
                                <div>
                                    <p class="font-semibold text-zinc-900 dark:text-white">Filas & Jobs</p>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400">Processamento em background com Redis/RabbitMQ, retries e batches.</p>
                                </div>
                            </div>
                            <div class="flex items-start gap-3">
                                <flux:icon.shield-check class="size-5 text-purple-500 mt-0.5" />
                                <div>
                                    <p class="font-semibold text-zinc-900 dark:text-white">Autenticação Híbrida</p>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400">Sessão legacy + tokens API (estilo Sanctum) com guards unificados.</p>
                                </div>
                            </div>
                        </div>

                        <div class="mt-6 rounded-xl border-l-4 border-amber-500 bg-amber-50 dark:bg-amber-900/20 p-4">
                            <div class="flex items-center gap-2 mb-1">
                                <flux:icon.light-bulb class="size-5 text-amber-600 dark:text-amber-400" />
                                <p class="font-semibold text-amber-800 dark:text-amber-200">Integração com Código Legado</p>
                            </div>
                            <p class="text-sm text-amber-900 dark:text-amber-100">
                                O framework expõe <strong>facades</strong> e <strong>bridges</strong> que permitem ao código em <code>_ajax/</code> e <code>_files/</code> acessar serviços modernos. Migre gradualmente sem quebrar o que já funciona.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
