@extends('layouts.docs')

@section('title', 'Sistema de Notificações - OG Framework')

@section('body')
    <div class="relative min-h-screen bg-transparent px-4 pb-12 pt-6 sm:px-6 lg:px-8">
        {{-- Floating shapes for styling --}}
        <div class="floating-blur cyan -left-10 -top-10 hidden lg:block"></div>
        <div class="floating-blur purple right-10 top-32 hidden lg:block"></div>

        <div class="mx-auto flex w-full max-w-7xl gap-8 bg-transparent">
            {{-- Left Sidebar: Navigation --}}
            @include('docs.partials.sidebar')

            {{-- Main Content --}}
            <div class="flex-1 min-w-0">
                <div class="relative overflow-hidden rounded-3xl border border-white/50 bg-white/85 p-8 shadow-xl shadow-primary/20 backdrop-blur dark:border-zinc-800 dark:bg-zinc-900/80">

                    {{-- Page Header --}}
                    <div class="mb-8">
                        <a href="{{ route('docs.index') }}" class="inline-flex items-center gap-1 text-sm text-primary hover:underline mb-4">
                            <flux:icon.arrow-left class="size-4" />
                            Voltar para Documentação
                        </a>
                        <p class="text-xs uppercase tracking-[0.3em] text-primary dark:text-blue-200">Comunicação</p>
                        <h1 class="font-display text-4xl font-bold text-zinc-900 dark:text-white sm:text-5xl">Sistema de Notificações</h1>
                        <p class="mt-3 text-base text-zinc-700 dark:text-zinc-200 max-w-3xl">
                            Sistema robusto e extensível para envio de notificações através de múltiplos canais. Construído sobre os padrões <strong>Strategy</strong>, <strong>Observer</strong> e <strong>Service Provider</strong>.
                        </p>
                    </div>

                    <div class="space-y-10">

                        {{-- Architecture SVG Diagram --}}
                        <section id="arquitectura" class="scroll-mt-28 space-y-4">
                            <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                <flux:icon.cube-transparent class="size-6 text-sky-500" />
                                Arquitectura
                            </h2>

                            {{-- SVG: Notification Flow --}}
                            <div class="rounded-xl border border-zinc-200 bg-white p-6 dark:border-zinc-800 dark:bg-zinc-900/50 overflow-x-auto">
                                <svg viewBox="0 0 750 180" class="w-full max-w-3xl mx-auto" xmlns="http://www.w3.org/2000/svg">
                                    {{-- Input Sources --}}
                                    <g transform="translate(10,20)">
                                        <rect x="0" y="0" width="130" height="140" rx="10" fill="#fef3c7" stroke="#f59e0b" stroke-width="1.5"/>
                                        <text x="65" y="20" text-anchor="middle" class="text-[10px] font-semibold" fill="#92400e">Origem</text>
                                        
                                        <rect x="10" y="35" width="110" height="28" rx="4" fill="#ffffff" stroke="#fcd34d"/>
                                        <text x="65" y="53" text-anchor="middle" class="text-[9px]" fill="#78350f">Código da Aplicação</text>
                                        
                                        <rect x="10" y="70" width="110" height="28" rx="4" fill="#ffffff" stroke="#fcd34d"/>
                                        <text x="65" y="88" text-anchor="middle" class="text-[9px]" fill="#78350f">CLI / Worker</text>
                                        
                                        <rect x="10" y="105" width="110" height="28" rx="4" fill="#ffffff" stroke="#fcd34d"/>
                                        <text x="65" y="123" text-anchor="middle" class="text-[9px]" fill="#78350f">Helper notify()</text>
                                    </g>
                                    
                                    {{-- Arrow --}}
                                    <path d="M150,90 L220,90" stroke="#94a3b8" stroke-width="2" marker-end="url(#arrowhead2)"/>
                                    
                                    {{-- Notification Service --}}
                                    <g transform="translate(230,25)">
                                        <rect x="0" y="0" width="200" height="130" rx="12" fill="#e0f2fe" stroke="#0284c7" stroke-width="2"/>
                                        <text x="100" y="25" text-anchor="middle" class="text-sm font-bold" fill="#0369a1">NotificationService</text>
                                        
                                        <rect x="15" y="40" width="170" height="75" rx="6" fill="#ffffff" stroke="#bae6fd"/>
                                        <text x="100" y="60" text-anchor="middle" class="text-[10px] font-semibold" fill="#0c4a6e">Fluent API</text>
                                        <text x="100" y="78" text-anchor="middle" class="text-[9px]" fill="#64748b">• using(Channel::class)</text>
                                        <text x="100" y="93" text-anchor="middle" class="text-[9px]" fill="#64748b">• debugging()</text>
                                        <text x="100" y="108" text-anchor="middle" class="text-[9px]" fill="#64748b">• send($notification)</text>
                                    </g>
                                    
                                    {{-- Arrow --}}
                                    <path d="M440,90 L510,90" stroke="#94a3b8" stroke-width="2" marker-end="url(#arrowhead2)"/>
                                    
                                    {{-- Channels --}}
                                    <g transform="translate(520,15)">
                                        <rect x="0" y="0" width="210" height="150" rx="10" fill="#f0fdf4" stroke="#22c55e" stroke-width="1.5"/>
                                        <text x="105" y="20" text-anchor="middle" class="text-[10px] font-semibold" fill="#166534">Canais</text>
                                        
                                        {{-- Database --}}
                                        <ellipse cx="50" cy="55" rx="35" ry="20" fill="#dbeafe" stroke="#3b82f6" stroke-width="1.2"/>
                                        <text x="50" y="60" text-anchor="middle" class="text-[8px]" fill="#1e40af">Database</text>
                                        
                                        {{-- Email --}}
                                        <rect x="95" y="38" width="60" height="34" rx="4" fill="#fef3c7" stroke="#f59e0b" stroke-width="1.2"/>
                                        <text x="125" y="60" text-anchor="middle" class="text-[8px]" fill="#92400e">Email</text>
                                        
                                        {{-- Mattermost --}}
                                        <rect x="165" y="38" width="35" height="34" rx="4" fill="#f3e8ff" stroke="#a855f7" stroke-width="1.2"/>
                                        <text x="182" y="60" text-anchor="middle" class="text-[7px]" fill="#7e22ce">MM</text>
                                        
                                        {{-- Labels --}}
                                        <text x="50" y="100" text-anchor="middle" class="text-[7px]" fill="#64748b">CentroMensagens</text>
                                        <text x="125" y="100" text-anchor="middle" class="text-[7px]" fill="#64748b">SMTP</text>
                                        <text x="182" y="100" text-anchor="middle" class="text-[7px]" fill="#64748b">API v4</text>
                                    </g>
                                    
                                    {{-- Arrowhead --}}
                                    <defs>
                                        <marker id="arrowhead2" markerWidth="10" markerHeight="7" refX="9" refY="3.5" orient="auto">
                                            <polygon points="0 0, 10 3.5, 0 7" fill="#94a3b8"/>
                                        </marker>
                                    </defs>
                                </svg>
                            </div>
                        </section>

                        {{-- Facade Usage --}}
                        <section id="facade" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                <flux:icon.paper-airplane class="size-6 text-blue-500" />
                                Facade Notification
                            </h2>
                            <p class="text-zinc-700 dark:text-zinc-300">
                                A facade <code>Notification</code> fornece acesso fluente ao <code>NotificationService</code>:
                            </p>

                            <div class="grid gap-6 lg:grid-cols-2">
                                <div class="rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-800 dark:bg-zinc-900/50">
                                    <h3 class="font-bold text-zinc-900 dark:text-white mb-2 text-sm">Envio Simples</h3>
                                    <pre class="text-xs bg-zinc-950 p-3 rounded-lg text-zinc-300"><code>use Notification;

// Usa canal padrão: DatabaseChannel
Notification::send([
    'text' => 'Operação concluída!',
    'subject' => 'Sistema',
    'color' => 'success'
]);</code></pre>
                                </div>

                                <div class="rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-800 dark:bg-zinc-900/50">
                                    <h3 class="font-bold text-zinc-900 dark:text-white mb-2 text-sm">Especificar Canal</h3>
                                    <pre class="text-xs bg-zinc-950 p-3 rounded-lg text-zinc-300"><code>use MattermostChannel;

Notification::using(MattermostChannel::class)
    ->send([
        'text' => 'Alerta crítico!',
        'color' => 'danger'
    ]);</code></pre>
                                </div>
                            </div>

                            <div class="rounded-xl border border-purple-200 bg-purple-50 p-4 dark:border-purple-900/50 dark:bg-purple-900/20">
                                <h3 class="font-semibold text-purple-900 dark:text-purple-200 mb-2 text-sm">Múltiplos Canais</h3>
                                <pre class="text-xs bg-white dark:bg-black/20 p-2 rounded"><code>Notification::using([
    MattermostChannel::class,
    EmailChannel::class
])->send([
    'text' => 'Sistema actualizado',
    'to' => 'admin@empresa.com',
    'subject' => 'Actualização',
    'body' => '&lt;p&gt;O sistema foi actualizado.&lt;/p&gt;'
]);</code></pre>
                            </div>
                        </section>

                        {{-- Helper notify() --}}
                        <section id="helper-notify" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                <flux:icon.bell class="size-6 text-amber-500" />
                                Helper Global: notify()
                            </h2>
                            <p class="text-zinc-700 dark:text-zinc-300">
                                Interface simplificada para notificações rápidas:
                            </p>

                            <div class="rounded-xl bg-zinc-950 p-4 text-sm overflow-x-auto">
                                <pre class="language-php"><code>function notify(
    string $message,              // Corpo da mensagem
    ?string $subject = null,      // Assunto
    ?int $userId = null,          // Destinatário (null = utilizador actual)
    null|string|Carbon $date = null,  // Data do alerta
    ?string $url = null,          // URL associado
    string $type = 'success',     // success, warning, error, info
    array $options = []           // Opções adicionais
): void</code></pre>
                            </div>

                            <div class="grid gap-4 md:grid-cols-2">
                                <div class="rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-800 dark:bg-zinc-900/50">
                                    <h3 class="font-bold text-zinc-900 dark:text-white mb-2 text-sm">Exemplos Básicos</h3>
                                    <pre class="text-xs bg-zinc-950 p-3 rounded-lg text-zinc-300"><code>// Simples
notify('Documento guardado!');

// Com destinatário
notify(
    message: 'Nova tarefa',
    subject: 'Tarefas',
    userId: 42
);

// Com URL de acção
notify(
    message: 'Novo pedido #12345',
    url: '/pedidos/ver/12345',
    type: 'info'
);</code></pre>
                                </div>

                                <div class="rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-800 dark:bg-zinc-900/50">
                                    <h3 class="font-bold text-zinc-900 dark:text-white mb-2 text-sm">Com Options</h3>
                                    <pre class="text-xs bg-zinc-950 p-3 rounded-lg text-zinc-300"><code>// Especificar canais
notify(
    message: 'Manutenção',
    type: 'warning',
    options: [
        'channels' => [
            MattermostChannel::class
        ]
    ]
);

// Formato legacy
notify(
    message: 'Alerta',
    options: [
        'mattermost' => true,
        'database' => false
    ]
);</code></pre>
                                </div>
                            </div>
                        </section>

                        {{-- Channels --}}
                        <section id="canais" class="scroll-mt-28 space-y-6 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                <flux:icon.signal class="size-6 text-green-500" />
                                Canais de Notificação
                            </h2>

                            {{-- DatabaseChannel --}}
                            <div class="rounded-xl border border-blue-200 bg-blue-50 p-4 dark:border-blue-900/50 dark:bg-blue-900/20">
                                <h3 class="font-semibold text-blue-900 dark:text-blue-200 mb-2 text-sm flex items-center gap-2">
                                    <span class="inline-flex size-6 items-center justify-center rounded bg-blue-200 dark:bg-blue-800">
                                        <flux:icon.circle-stack class="size-4" />
                                    </span>
                                    DatabaseChannel
                                </h3>
                                <p class="text-xs text-blue-800 dark:text-blue-300 mb-2">
                                    Integra com o sistema legacy <code>CentroMensagens</code> para notificações internas.
                                </p>
                                <div class="overflow-x-auto">
                                    <table class="min-w-full text-xs">
                                        <thead>
                                            <tr class="text-left text-blue-700 dark:text-blue-300">
                                                <th class="pr-4 py-1">Campo</th>
                                                <th class="pr-4 py-1">Tipo</th>
                                                <th class="py-1">Descrição</th>
                                            </tr>
                                        </thead>
                                        <tbody class="text-blue-800 dark:text-blue-200">
                                            <tr><td class="pr-4 py-1 font-mono">text</td><td class="pr-4">string</td><td>Corpo da mensagem</td></tr>
                                            <tr><td class="pr-4 py-1 font-mono">subject</td><td class="pr-4">string</td><td>Assunto/título</td></tr>
                                            <tr><td class="pr-4 py-1 font-mono">codempr</td><td class="pr-4">int</td><td>ID do destinatário</td></tr>
                                            <tr><td class="pr-4 py-1 font-mono">color</td><td class="pr-4">string</td><td>success, warning, error, info</td></tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            {{-- EmailChannel --}}
                            <div class="rounded-xl border border-amber-200 bg-amber-50 p-4 dark:border-amber-900/50 dark:bg-amber-900/20">
                                <h3 class="font-semibold text-amber-900 dark:text-amber-200 mb-2 text-sm flex items-center gap-2">
                                    <span class="inline-flex size-6 items-center justify-center rounded bg-amber-200 dark:bg-amber-800">
                                        <flux:icon.envelope class="size-4" />
                                    </span>
                                    EmailChannel
                                </h3>
                                <p class="text-xs text-amber-800 dark:text-amber-300 mb-2">
                                    Classe readonly para envio de emails. Suporta múltiplos destinatários (array ou string separada por vírgulas).
                                </p>
                                <pre class="text-xs bg-white dark:bg-black/20 p-2 rounded"><code>// Campos obrigatórios: to, subject, body
Notification::using(EmailChannel::class)->send([
    'to' => ['admin@empresa.com', 'manager@empresa.com'],
    'subject' => 'Relatório Mensal',
    'body' => '&lt;p&gt;Segue o relatório...&lt;/p&gt;',
    'from' => ['name' => 'Sistema', 'email' => 'noreply@empresa.com']
]);</code></pre>
                            </div>

                            {{-- MattermostChannel --}}
                            <div class="rounded-xl border border-purple-200 bg-purple-50 p-4 dark:border-purple-900/50 dark:bg-purple-900/20">
                                <h3 class="font-semibold text-purple-900 dark:text-purple-200 mb-2 text-sm flex items-center gap-2">
                                    <span class="inline-flex size-6 items-center justify-center rounded bg-purple-200 dark:bg-purple-800">
                                        <flux:icon.chat-bubble-left-right class="size-4" />
                                    </span>
                                    MattermostChannel
                                </h3>
                                <p class="text-xs text-purple-800 dark:text-purple-300 mb-2">
                                    Integração completa com Mattermost API v4, incluindo rich formatting e attachments.
                                </p>
                                <pre class="text-xs bg-white dark:bg-black/20 p-2 rounded"><code>Notification::using(MattermostChannel::class)->send([
    'text' => 'Deploy concluído',
    'subject' => 'Produção Actualizada',
    'formatted_text' => "### Detalhes\n- Branch: main\n- Commit: abc123",
    'color' => 'success',
    'mattermost_mentions' => ['@devops', '@backend'],
    'fields' => [
        ['title' => 'Versão', 'value' => '2.1.0', 'short' => true],
        ['title' => 'Ambiente', 'value' => 'production', 'short' => true],
    ]
]);</code></pre>
                            </div>
                        </section>

                        {{-- CliNotifier --}}
                        <section id="cli-notifier" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                <flux:icon.command-line class="size-6 text-slate-500" />
                                CliNotifier
                            </h2>
                            <p class="text-zinc-700 dark:text-zinc-300">
                                Componente especializado para notificações em ambiente CLI (workers, commands, cron jobs). Oferece <strong>40+ métodos</strong> específicos para debugging.
                            </p>

                            {{-- SVG: CliNotifier Levels --}}
                            <div class="rounded-xl border border-zinc-200 bg-white p-6 dark:border-zinc-800 dark:bg-zinc-900/50 overflow-x-auto">
                                <svg viewBox="0 0 500 180" class="w-full max-w-xl mx-auto" xmlns="http://www.w3.org/2000/svg">
                                    {{-- Debug Group --}}
                                    <g transform="translate(20,20)">
                                        <rect x="0" y="0" width="180" height="100" rx="10" fill="#fef3c7" stroke="#f59e0b" stroke-width="1.5"/>
                                        <text x="90" y="20" text-anchor="middle" class="text-[10px] font-semibold" fill="#92400e">Debug (Condicional)</text>
                                        
                                        <rect x="15" y="35" width="150" height="25" rx="4" fill="#ffffff" stroke="#fcd34d"/>
                                        <text x="90" y="52" text-anchor="middle" class="text-[10px] font-mono" fill="#78350f">debug()</text>
                                        
                                        <rect x="15" y="65" width="150" height="25" rx="4" fill="#ffffff" stroke="#fcd34d"/>
                                        <text x="90" y="82" text-anchor="middle" class="text-[10px] font-mono" fill="#78350f">warning()</text>
                                    </g>
                                    
                                    {{-- Critical Group --}}
                                    <g transform="translate(20,130)">
                                        <rect x="0" y="0" width="180" height="40" rx="10" fill="#fee2e2" stroke="#ef4444" stroke-width="1.5"/>
                                        <text x="90" y="15" text-anchor="middle" class="text-[10px] font-semibold" fill="#991b1b">Crítico (Sempre Enviado)</text>
                                        <text x="90" y="32" text-anchor="middle" class="text-[10px] font-mono" fill="#b91c1c">critical()</text>
                                    </g>
                                    
                                    {{-- Arrows --}}
                                    <path d="M210,70 Q280,70 280,90 L280,90 Q280,110 350,110" stroke="#f59e0b" stroke-width="2" fill="none" marker-end="url(#arrowhead3)"/>
                                    <path d="M210,150 L350,150" stroke="#ef4444" stroke-width="2" marker-end="url(#arrowhead3)"/>
                                    
                                    {{-- Labels --}}
                                    <text x="280" y="65" text-anchor="middle" class="text-[8px]" fill="#f59e0b">NOTIFICATION_DEBUG=true</text>
                                    <text x="280" y="145" text-anchor="middle" class="text-[8px]" fill="#ef4444">Sempre</text>
                                    
                                    {{-- Mattermost --}}
                                    <g transform="translate(360,90)">
                                        <ellipse cx="60" cy="40" rx="55" ry="35" fill="#f3e8ff" stroke="#a855f7" stroke-width="1.5"/>
                                        <text x="60" y="35" text-anchor="middle" class="text-[10px] font-semibold" fill="#7e22ce">Mattermost</text>
                                        <text x="60" y="50" text-anchor="middle" class="text-[8px]" fill="#9333ea">Channel</text>
                                    </g>
                                    
                                    <defs>
                                        <marker id="arrowhead3" markerWidth="10" markerHeight="7" refX="9" refY="3.5" orient="auto">
                                            <polygon points="0 0, 10 3.5, 0 7" fill="#94a3b8"/>
                                        </marker>
                                    </defs>
                                </svg>
                            </div>

                            <div class="grid gap-4 md:grid-cols-2">
                                <div class="rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-800 dark:bg-zinc-900/50">
                                    <h3 class="font-bold text-zinc-900 dark:text-white mb-2 text-sm">Métodos Base</h3>
                                    <pre class="text-xs bg-zinc-950 p-3 rounded-lg text-zinc-300"><code>use CliNotifier;

CliNotifier::debug('Processamento iniciado', [
    'batch_size' => 100
]);

CliNotifier::warning('Memória elevada', [
    'usage' => '450MB'
]);

// SEMPRE enviado em CLI
CliNotifier::critical('Falha crítica', [
    'error' => 'DB connection lost'
]);</code></pre>
                                </div>

                                <div class="rounded-xl border border-zinc-200 bg-white p-4 dark:border-zinc-800 dark:bg-zinc-900/50">
                                    <h3 class="font-bold text-zinc-900 dark:text-white mb-2 text-sm">Notificações Específicas</h3>
                                    <pre class="text-xs bg-zinc-950 p-3 rounded-lg text-zinc-300"><code>// Bootstrap
CliNotifier::databaseConnected(45.2, 'MySQL');
CliNotifier::addonLoaded('saft_ao');

// Queue/Jobs
CliNotifier::queueJobPopped('default', 'found');
CliNotifier::queueJobFailed($jobId, $class, $e);
CliNotifier::memoryWarning(450.5, 512.0);

// Email
CliNotifier::emailSentSuccessfully('invoice', 'cli@ex');
CliNotifier::emailSendingFailed('invoice', 'cli@ex', 'Timeout');</code></pre>
                                </div>
                            </div>
                        </section>

                        {{-- Configuration --}}
                        <section id="configuracao" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                <flux:icon.cog-6-tooth class="size-6 text-zinc-500" />
                                Configuração
                            </h2>
                            <p class="text-zinc-700 dark:text-zinc-300">
                                Ficheiro: <code>Modules/Common/Config/notifications.php</code>
                            </p>

                            <div class="overflow-hidden rounded-xl border border-zinc-200 dark:border-zinc-800 bg-white dark:bg-zinc-900/50">
                                <table class="min-w-full divide-y divide-zinc-200 dark:divide-zinc-800">
                                    <thead class="bg-zinc-50 dark:bg-zinc-900/80">
                                        <tr>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-zinc-500 uppercase">Variável</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-zinc-500 uppercase">Descrição</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-zinc-500 uppercase">Default</th>
                                        </tr>
                                    </thead>
                                    <tbody class="divide-y divide-zinc-200 dark:divide-zinc-800">
                                        <tr>
                                            <td class="px-6 py-3 font-mono text-xs">NOTIFICATION_DEFAULT_CHANNEL</td>
                                            <td class="px-6 py-3 text-xs text-zinc-600 dark:text-zinc-400">Canal padrão</td>
                                            <td class="px-6 py-3 font-mono text-xs">database</td>
                                        </tr>
                                        <tr>
                                            <td class="px-6 py-3 font-mono text-xs">NOTIFICATION_DEBUG</td>
                                            <td class="px-6 py-3 text-xs text-zinc-600 dark:text-zinc-400">Habilita modo debug</td>
                                            <td class="px-6 py-3 font-mono text-xs">false</td>
                                        </tr>
                                        <tr>
                                            <td class="px-6 py-3 font-mono text-xs">MATTERMOST_NOTIFICATIONS_ENABLED</td>
                                            <td class="px-6 py-3 text-xs text-zinc-600 dark:text-zinc-400">Activa Mattermost</td>
                                            <td class="px-6 py-3 font-mono text-xs">false</td>
                                        </tr>
                                        <tr>
                                            <td class="px-6 py-3 font-mono text-xs">MATTERMOST_NOTIFICATIONS_URL</td>
                                            <td class="px-6 py-3 text-xs text-zinc-600 dark:text-zinc-400">URL da API</td>
                                            <td class="px-6 py-3 font-mono text-xs">-</td>
                                        </tr>
                                        <tr>
                                            <td class="px-6 py-3 font-mono text-xs">MATTERMOST_TOKEN</td>
                                            <td class="px-6 py-3 text-xs text-zinc-600 dark:text-zinc-400">Token de autenticação</td>
                                            <td class="px-6 py-3 font-mono text-xs">-</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </section>

                        {{-- Extensibility --}}
                        <section id="extensibilidade" class="scroll-mt-28 space-y-4 border-t border-zinc-200 dark:border-zinc-800 pt-8">
                            <h2 class="text-2xl font-semibold text-zinc-900 dark:text-white flex items-center gap-2">
                                <flux:icon.puzzle-piece class="size-6 text-indigo-500" />
                                Extensibilidade
                            </h2>
                            <p class="text-zinc-700 dark:text-zinc-300">
                                Adicionar novos canais é simples através da interface <code>NotificationChannelInterface</code>:
                            </p>

                            <div class="rounded-xl bg-zinc-950 p-4 text-sm overflow-x-auto">
                                <pre class="language-php"><code>class SlackChannel implements NotificationChannelInterface
{
    public function __construct(
        private string $webhookUrl,
        private string $defaultChannel = '#general'
    ) {}

    public function send(array $notification): bool
    {
        try {
            $response = $this->client->post($this->webhookUrl, [
                'json' => [
                    'channel' => $notification['slack_channel'] ?? $this->defaultChannel,
                    'text' => $notification['text'],
                    'attachments' => [[
                        'color' => $this->getColor($notification['color'] ?? 'good'),
                        'title' => $notification['subject'] ?? '',
                    ]]
                ]
            ]);
            return $response->getStatusCode() === 200;
        } catch (\Throwable $e) {
            return false;
        }
    }

    public function shouldSend(array $notification): bool
    {
        return ($notification['slack'] ?? false) === true;
    }
}

// Registar no ServiceProvider
$service->addChannel(new SlackChannel($webhookUrl));</code></pre>
                            </div>
                        </section>

                        {{-- Navigation --}}
                        <div class="flex justify-between items-center pt-8 border-t border-zinc-200 dark:border-zinc-800">
                            <a href="{{ route('docs.show', 'resources') }}" class="inline-flex items-center gap-2 text-sm text-zinc-600 dark:text-zinc-400 hover:text-primary">
                                <flux:icon.arrow-left class="size-4" />
                                Resources (DTOs)
                            </a>
                            <a href="{{ route('docs.show', 'cache') }}" class="inline-flex items-center gap-2 text-sm font-medium text-primary hover:underline">
                                Cache System
                                <flux:icon.arrow-right class="size-4" />
                            </a>
                        </div>
                    </div>

                </div>
            </div>

            {{-- Right Sidebar: Table of Contents --}}
            @include('docs.partials.toc', ['sections' => [
                'arquitectura' => 'Arquitectura',
                'facade' => 'Facade Notification',
                'helper-notify' => 'Helper notify()',
                'canais' => 'Canais',
                'cli-notifier' => 'CliNotifier',
                'configuracao' => 'Configuração',
                'extensibilidade' => 'Extensibilidade',
            ]])
        </div>
    </div>
@endsection
