{{-- Sidebar Navigation --}}
<aside class="hidden lg:sticky lg:top-28 lg:block lg:w-64 lg:shrink-0 lg:self-start">
    <div class="rounded-2xl border border-white/30 bg-gradient-to-br from-[#00527a] via-[#0a6d97] to-[#0b4060] p-4 text-white shadow-xl shadow-[#00527a]/20 backdrop-blur dark:border-zinc-800 dark:from-[#0f1b27] dark:via-[#0f2a3a] dark:to-[#0c2230]">
        <p class="mb-3 text-xs uppercase tracking-[0.3em] text-white/80">Navegação</p>
        <nav class="space-y-1 text-sm">
            @php
                $currentRoute = request()->route()->getName();
                $currentSlug = request()->route('slug');
            @endphp

            <a class="side-link text-white {{ $currentRoute === 'docs.index' ? 'bg-white/20' : '' }}" href="{{ route('docs.index') }}">
                <span class="inline-flex size-6 items-center justify-center rounded-lg bg-white/15"><flux:icon.home class="size-4" /></span>
                <span>Visão Geral</span>
            </a>
            <a class="side-link text-white {{ $currentSlug === 'bootstrap' ? 'bg-white/20' : '' }}" href="{{ route('docs.show', 'bootstrap') }}">
                <span class="inline-flex size-6 items-center justify-center rounded-lg bg-white/15"><flux:icon.bolt class="size-4" /></span>
                <span>Bootstrap</span>
            </a>
            <a class="side-link text-white {{ $currentSlug === 'container' ? 'bg-white/20' : '' }}" href="{{ route('docs.show', 'container') }}">
                <span class="inline-flex size-6 items-center justify-center rounded-lg bg-white/15"><flux:icon.cube class="size-4" /></span>
                <span>Container</span>
            </a>
            <a class="side-link text-white {{ $currentSlug === 'service-providers' ? 'bg-white/20' : '' }}" href="{{ route('docs.show', 'service-providers') }}">
                <span class="inline-flex size-6 items-center justify-center rounded-lg bg-white/15"><flux:icon.puzzle-piece class="size-4" /></span>
                <span>Service Providers</span>
            </a>
            <a class="side-link text-white {{ $currentSlug === 'auth' ? 'bg-white/20' : '' }}" href="{{ route('docs.show', 'auth') }}">
                <span class="inline-flex size-6 items-center justify-center rounded-lg bg-white/15"><flux:icon.shield-check class="size-4" /></span>
                <span>Autenticação</span>
            </a>
            <a class="side-link text-white {{ $currentSlug === 'facades' ? 'bg-white/20' : '' }}" href="{{ route('docs.show', 'facades') }}">
                <span class="inline-flex size-6 items-center justify-center rounded-lg bg-white/15"><flux:icon.window class="size-4" /></span>
                <span>Facades</span>
            </a>
            <a class="side-link text-white {{ $currentSlug === 'cache' ? 'bg-white/20' : '' }}" href="{{ route('docs.show', 'cache') }}">
                <span class="inline-flex size-6 items-center justify-center rounded-lg bg-white/15"><flux:icon.circle-stack class="size-4" /></span>
                <span>Cache</span>
            </a>
            <a class="side-link text-white {{ $currentSlug === 'database' ? 'bg-white/20' : '' }}" href="{{ route('docs.show', 'database') }}">
                <span class="inline-flex size-6 items-center justify-center rounded-lg bg-white/15"><flux:icon.server class="size-4" /></span>
                <span>Database</span>
            </a>
            <a class="side-link text-white {{ $currentSlug === 'filesystem' ? 'bg-white/20' : '' }}" href="{{ route('docs.show', 'filesystem') }}">
                <span class="inline-flex size-6 items-center justify-center rounded-lg bg-white/15"><flux:icon.folder class="size-4" /></span>
                <span>Filesystem</span>
            </a>
            <a class="side-link text-white {{ $currentSlug === 'routing' ? 'bg-white/20' : '' }}" href="{{ route('docs.show', 'routing') }}">
                <span class="inline-flex size-6 items-center justify-center rounded-lg bg-white/15"><flux:icon.map class="size-4" /></span>
                <span>Routing</span>
            </a>
            <a class="side-link text-white {{ $currentSlug === 'helpers' ? 'bg-white/20' : '' }}" href="{{ route('docs.show', 'helpers') }}">
                <span class="inline-flex size-6 items-center justify-center rounded-lg bg-white/15"><flux:icon.code-bracket class="size-4" /></span>
                <span>Helpers</span>
            </a>
            <a class="side-link text-white {{ $currentSlug === 'resources' ? 'bg-white/20' : '' }}" href="{{ route('docs.show', 'resources') }}">
                <span class="inline-flex size-6 items-center justify-center rounded-lg bg-white/15"><flux:icon.arrows-right-left class="size-4" /></span>
                <span>Resources (DTOs)</span>
            </a>
            <a class="side-link text-white {{ $currentSlug === 'notifications' ? 'bg-white/20' : '' }}" href="{{ route('docs.show', 'notifications') }}">
                <span class="inline-flex size-6 items-center justify-center rounded-lg bg-white/15"><flux:icon.bell class="size-4" /></span>
                <span>Notificações</span>
            </a>
            <a class="side-link text-white {{ $currentSlug === 'validation' ? 'bg-white/20' : '' }}" href="{{ route('docs.show', 'validation') }}">
                <span class="inline-flex size-6 items-center justify-center rounded-lg bg-white/15"><flux:icon.check-badge class="size-4" /></span>
                <span>Validação</span>
            </a>
            <a class="side-link text-white {{ $currentSlug === 'web-layer' ? 'bg-white/20' : '' }}" href="{{ route('docs.show', 'web-layer') }}">
                <span class="inline-flex size-6 items-center justify-center rounded-lg bg-white/15"><flux:icon.globe-alt class="size-4" /></span>
                <span>Web Layer</span>
            </a>

            <p class="mb-2 mt-4 text-xs uppercase tracking-[0.3em] text-white/60">Em breve</p>
            <span class="side-link text-white/50 cursor-not-allowed">
                <span class="inline-flex size-6 items-center justify-center rounded-lg bg-white/10"><flux:icon.queue-list class="size-4" /></span>
                <span>Filas</span>
            </span>
        </nav>
    </div>
</aside>
