{{-- Table of Contents - Right Sidebar with Alpine.js Scroll Spy --}}
@props(['sections' => []])

<aside class="hidden xl:sticky xl:top-28 xl:block xl:w-56 xl:shrink-0 xl:self-start">
    <div class="rounded-xl border border-zinc-200/50 bg-white/60 p-4 backdrop-blur dark:border-zinc-800 dark:bg-zinc-900/60"
         x-data="{
             activeSection: '{{ array_key_first($sections) }}',
             init() {
                 this.observeSections();
             },
             observeSections() {
                 const sections = @js(array_keys($sections));
                 const observer = new IntersectionObserver((entries) => {
                     entries.forEach(entry => {
                         if (entry.isIntersecting) {
                             this.activeSection = entry.target.id;
                         }
                     });
                 }, {
                     rootMargin: '-20% 0px -70% 0px',
                     threshold: 0
                 });

                 sections.forEach(id => {
                     const el = document.getElementById(id);
                     if (el) observer.observe(el);
                 });
             },
             scrollTo(id) {
                 const el = document.getElementById(id);
                 if (el) {
                     el.scrollIntoView({ behavior: 'smooth', block: 'start' });
                     this.activeSection = id;
                 }
             }
         }">
        <p class="mb-3 text-xs font-semibold uppercase tracking-[0.2em] text-zinc-500 dark:text-zinc-400">Nesta página</p>
        <nav class="space-y-1 text-sm">
            @foreach($sections as $id => $title)
                <button type="button"
                        @click="scrollTo('{{ $id }}')"
                        class="group flex w-full items-center gap-2 rounded-lg px-2 py-1.5 text-left transition-all duration-200"
                        :class="activeSection === '{{ $id }}'
                            ? 'text-primary font-medium bg-primary/5 dark:text-blue-400 dark:bg-blue-400/10'
                            : 'text-zinc-600 hover:bg-zinc-100 hover:text-primary dark:text-zinc-400 dark:hover:bg-zinc-800'">
                    <span class="size-1.5 rounded-full transition-all duration-200"
                          :class="activeSection === '{{ $id }}'
                              ? 'bg-primary dark:bg-blue-400 scale-125'
                              : 'bg-zinc-300 dark:bg-zinc-600 group-hover:bg-primary dark:group-hover:bg-blue-400'"></span>
                    <span class="truncate">{{ $title }}</span>
                </button>
            @endforeach
        </nav>
    </div>
</aside>
