<!DOCTYPE html>
<html lang="pt-BR" class="h-full">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@yield('title', $title ?? 'Documentação')</title>
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=manrope:400,500,600,700|space-grotesk:500,600,700&display=swap" rel="stylesheet" />
    {{-- Detect system dark mode preference immediately to prevent flash --}}
    <script>
        (function() {
            const fluxAppearance = localStorage.getItem('flux-appearance');
            const prefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches;
            
            // If Flux has a stored preference
            if (fluxAppearance === 'dark' || (fluxAppearance === 'system' && prefersDark) || (!fluxAppearance && prefersDark)) {
                document.documentElement.classList.add('dark');
            } else if (fluxAppearance === 'light') {
                document.documentElement.classList.remove('dark');
            }
        })();
    </script>
    @fluxAppearance
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link id="prism-light" rel="stylesheet" href="https://cdn.jsdelivr.net/npm/prismjs@1.29.0/themes/prism.css">
    <link id="prism-dark" rel="stylesheet" href="https://cdn.jsdelivr.net/npm/prismjs@1.29.0/themes/prism-okaidia.css" disabled>
    @livewireStyles
    @stack('head')
</head>
<body class="min-h-full bg-white text-zinc-900 antialiased dark:bg-zinc-950 dark:text-zinc-100">
    <header class="sticky top-0 z-40 border-b border-[#00527a]/10 bg-white/95 backdrop-blur-md shadow-sm dark:border-[#66c2ff]/15 dark:bg-zinc-950/90">
        <div class="mx-auto flex max-w-6xl items-center gap-4 px-4 py-3 sm:px-6 lg:px-8">
            <a href="{{ route('docs.index') }}" class="flex items-center gap-2 text-zinc-900 dark:text-zinc-50 group">
                <div class="flex w-100 items-center justify-center overflow-hidden rounded-md transition-transform duration-200 group-hover:scale-105">
                    <img src="{{ asset('images/logo_light.png') }}" alt="OG Framework" />
                </div>
                <div class="flex flex-col leading-tight">
                    <span class="text-sm font-semibold tracking-tight text-[#00527a] dark:text-[#66c2ff]">OG Framework</span>
                    <span class="text-xs text-zinc-500 dark:text-zinc-400">Documentação</span>
                </div>
            </a>

            <div class="flex-1">
                <livewire:search-docs />
            </div>

            <div class="flex items-center gap-2">
                <flux:button
                    variant="ghost"
                    size="xs"
                    x-data
                    x-on:click="$flux.dark = ! $flux.dark"
                    aria-label="Toggle dark mode"
                >
                    <flux:icon.sun x-show="$flux.dark" variant="mini" class="size-4" />
                    <flux:icon.moon x-show="! $flux.dark" variant="mini" class="size-4" />
                </flux:button>
            </div>
        </div>
    </header>

    <main>
        <div class="pt-4 pb-10 px-4 sm:px-6 lg:px-8">
            @yield('body')
        </div>
    </main>

    <script src="https://cdn.jsdelivr.net/npm/prismjs@1.29.0/prism.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/prismjs@1.29.0/components/prism-markup-templating.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/prismjs@1.29.0/components/prism-php.min.js"></script>
    @fluxScripts
    @stack('scripts')
</body>
</html>
