<div class="relative w-full" x-data="{ open: @entangle('showResults') }">
    <div class="relative">
        <flux:icon.magnifying-glass class="absolute left-3 top-1/2 -translate-y-1/2 size-4 text-zinc-400" />
        <input
            type="text"
            wire:model.live.debounce.300ms="query"
            wire:keydown.arrow-down.prevent="selectNext"
            wire:keydown.arrow-up.prevent="selectPrevious"
            wire:keydown.enter.prevent="goToSelected"
            wire:keydown.escape="hideResults"
            @focus="open = $wire.query.length >= 2"
            @click.outside="open = false"
            placeholder="Buscar na documentação..."
            class="w-full rounded-lg border border-zinc-200 bg-white py-2 pl-10 pr-4 text-sm text-zinc-900 placeholder-zinc-400 transition focus:border-primary focus:outline-none focus:ring-2 focus:ring-primary/20 dark:border-zinc-700 dark:bg-zinc-800 dark:text-zinc-100 dark:placeholder-zinc-500 dark:focus:border-[#66c2ff] dark:focus:ring-[#66c2ff]/20"
        />
        <div wire:loading wire:target="query" class="absolute right-3 top-1/2 -translate-y-1/2">
            <flux:icon.arrow-path class="size-4 text-zinc-400 animate-spin" />
        </div>
    </div>

    @if($showResults)
        <div
            x-show="open"
            x-transition:enter="transition ease-out duration-200"
            x-transition:enter-start="opacity-0 translate-y-1"
            x-transition:enter-end="opacity-100 translate-y-0"
            x-transition:leave="transition ease-in duration-150"
            x-transition:leave-start="opacity-100 translate-y-0"
            x-transition:leave-end="opacity-0 translate-y-1"
            class="absolute z-50 mt-2 w-full overflow-hidden rounded-xl border border-zinc-200 bg-white shadow-xl dark:border-zinc-700 dark:bg-zinc-800"
        >
            @if(count($this->results) > 0)
                <ul class="divide-y divide-zinc-100 dark:divide-zinc-700 max-h-96 overflow-y-auto">
                    @foreach($this->results as $index => $result)
                        <li>
                            <a
                                href="{{ $result['url'] }}"
                                class="block px-4 py-3 transition hover:bg-zinc-50 dark:hover:bg-zinc-700/50 {{ $selectedIndex === $index ? 'bg-zinc-50 dark:bg-zinc-700/50' : '' }}"
                            >
                                <div class="flex items-center gap-2">
                                    <flux:icon.document-text class="size-4 text-primary dark:text-[#66c2ff]" />
                                    <span class="font-medium text-zinc-900 dark:text-zinc-100">{{ $result['title'] }}</span>
                                    @if($result['section'])
                                        <span class="text-xs text-zinc-400 dark:text-zinc-500">{{ $result['section'] }}</span>
                                    @endif
                                </div>
                                @if($result['description'])
                                    <p class="mt-1 text-sm text-zinc-600 dark:text-zinc-400 line-clamp-2">
                                        {{ $result['description'] }}
                                    </p>
                                @endif
                            </a>
                        </li>
                    @endforeach
                </ul>
                <div class="border-t border-zinc-100 bg-zinc-50 px-4 py-2 text-xs text-zinc-500 dark:border-zinc-700 dark:bg-zinc-800/50 dark:text-zinc-400">
                    <span class="flex items-center gap-2">
                        <kbd class="rounded bg-zinc-200 px-1.5 py-0.5 font-mono text-[10px] dark:bg-zinc-700">↑↓</kbd>
                        <span>navegar</span>
                        <kbd class="rounded bg-zinc-200 px-1.5 py-0.5 font-mono text-[10px] dark:bg-zinc-700">Enter</kbd>
                        <span>selecionar</span>
                        <kbd class="rounded bg-zinc-200 px-1.5 py-0.5 font-mono text-[10px] dark:bg-zinc-700">Esc</kbd>
                        <span>fechar</span>
                    </span>
                </div>
            @else
                <div class="px-4 py-6 text-center">
                    <flux:icon.magnifying-glass class="mx-auto size-8 text-zinc-300 dark:text-zinc-600" />
                    <p class="mt-2 text-sm text-zinc-500 dark:text-zinc-400">
                        Nenhum resultado para "<span class="font-medium text-zinc-700 dark:text-zinc-300">{{ $query }}</span>"
                    </p>
                </div>
            @endif
        </div>
    @endif
</div>
