<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DocsController;

Route::get('/', function () {
    return redirect()->route('docs.index');
});

Route::get('/docs', [DocsController::class, 'show'])
    ->name('docs.index');

Route::get('/docs/{slug}', function (string $slug) {
    $validPages = ['bootstrap', 'container', 'service-providers', 'auth', 'facades', 'cache', 'database', 'filesystem', 'routing', 'helpers', 'resources', 'notifications', 'validation', 'web-layer', 'queue'];

    if (!in_array($slug, $validPages)) {
        abort(404);
    }

    return view("docs.{$slug}");
})->name('docs.show');
