<?php $__env->startSection('title', 'Documentação OG Framework'); ?>

<?php $__env->startSection('body'); ?>
    <div class="relative min-h-screen bg-transparent px-4 pb-12 pt-6 sm:px-6 lg:px-8">
        <div class="floating-blur blue -left-10 -top-10 hidden lg:block"></div>
        <div class="floating-blur amber right-10 top-32 hidden lg:block"></div>
        <div class="floating-blur teal left-1/3 bottom-10 hidden lg:block"></div>

        <div class="mx-auto flex w-full max-w-7xl flex-col gap-8 lg:flex-row bg-transparent">
            <?php echo $__env->make('docs.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <div class="flex-1">
                
                <div class="relative overflow-hidden rounded-3xl border border-white/50 bg-white/85 p-8 shadow-xl shadow-primary/20 backdrop-blur dark:border-zinc-800 dark:bg-zinc-900/80">
                    <div class="relative z-10 space-y-4 max-w-3xl">
                        <p class="text-xs uppercase tracking-[0.3em] text-primary">Introdução</p>
                        <h1 class="font-display text-4xl font-bold text-zinc-900 dark:text-white sm:text-5xl">OG Framework — visão geral.</h1>
                        <p class="text-base text-zinc-700 dark:text-zinc-200">
                            O OG Framework é a camada moderna do ERP: DI, rotas, filas e CLI convivendo com o legado. Aqui você encontra como a arquitetura funciona, como inicializar o stack, e o que cada subsistema oferece para construir módulos sem quebrar o core existente.
                        </p>
                    </div>
                </div>

                
                <div class="mt-8 space-y-6">
                    <div>
                        <h2 class="text-xl font-semibold text-zinc-900 dark:text-white mb-4">Arquitetura</h2>
                        <div class="grid gap-4 md:grid-cols-2 lg:grid-cols-4">
                            <a href="<?php echo e(route('docs.show', 'bootstrap')); ?>" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-amber-100 dark:bg-amber-900/30">
                                        <?php if (isset($component)) { $__componentOriginale0a0c12575af25a71f941c8515365d96 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale0a0c12575af25a71f941c8515365d96 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.bolt','data' => ['class' => 'size-5 text-amber-600 dark:text-amber-400']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.bolt'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5 text-amber-600 dark:text-amber-400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale0a0c12575af25a71f941c8515365d96)): ?>
<?php $attributes = $__attributesOriginale0a0c12575af25a71f941c8515365d96; ?>
<?php unset($__attributesOriginale0a0c12575af25a71f941c8515365d96); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale0a0c12575af25a71f941c8515365d96)): ?>
<?php $component = $__componentOriginale0a0c12575af25a71f941c8515365d96; ?>
<?php unset($__componentOriginale0a0c12575af25a71f941c8515365d96); ?>
<?php endif; ?>
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Bootstrap</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">Inicialização</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Pontos de entrada, bootstrappers, ciclo de vida.
                                </p>
                            </a>

                            <a href="<?php echo e(route('docs.show', 'container')); ?>" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-blue-100 dark:bg-blue-900/30">
                                        <?php if (isset($component)) { $__componentOriginald5dcfefa1bd397da70b3e8652c3e12ee = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald5dcfefa1bd397da70b3e8652c3e12ee = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.cube','data' => ['class' => 'size-5 text-blue-600 dark:text-blue-400']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.cube'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5 text-blue-600 dark:text-blue-400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald5dcfefa1bd397da70b3e8652c3e12ee)): ?>
<?php $attributes = $__attributesOriginald5dcfefa1bd397da70b3e8652c3e12ee; ?>
<?php unset($__attributesOriginald5dcfefa1bd397da70b3e8652c3e12ee); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald5dcfefa1bd397da70b3e8652c3e12ee)): ?>
<?php $component = $__componentOriginald5dcfefa1bd397da70b3e8652c3e12ee; ?>
<?php unset($__componentOriginald5dcfefa1bd397da70b3e8652c3e12ee); ?>
<?php endif; ?>
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Container</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">DI & Bindings</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Facades, auto-wiring, código testável.
                                </p>
                            </a>

                            <a href="<?php echo e(route('docs.show', 'service-providers')); ?>" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-purple-100 dark:bg-purple-900/30">
                                        <?php if (isset($component)) { $__componentOriginalc1db47ab9e30c89dff257cdf419f2b12 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc1db47ab9e30c89dff257cdf419f2b12 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.puzzle-piece','data' => ['class' => 'size-5 text-purple-600 dark:text-purple-400']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.puzzle-piece'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5 text-purple-600 dark:text-purple-400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc1db47ab9e30c89dff257cdf419f2b12)): ?>
<?php $attributes = $__attributesOriginalc1db47ab9e30c89dff257cdf419f2b12; ?>
<?php unset($__attributesOriginalc1db47ab9e30c89dff257cdf419f2b12); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc1db47ab9e30c89dff257cdf419f2b12)): ?>
<?php $component = $__componentOriginalc1db47ab9e30c89dff257cdf419f2b12; ?>
<?php unset($__componentOriginalc1db47ab9e30c89dff257cdf419f2b12); ?>
<?php endif; ?>
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Service Providers</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">Configuração</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Registro de serviços, 16 providers, lifecycle.
                                </p>
                            </a>

                            <a href="<?php echo e(route('docs.show', 'auth')); ?>" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-red-100 dark:bg-red-900/30">
                                        <?php if (isset($component)) { $__componentOriginalf870514c33bb1b53395ba02235f60146 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf870514c33bb1b53395ba02235f60146 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.shield-check','data' => ['class' => 'size-5 text-red-600 dark:text-red-400']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.shield-check'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5 text-red-600 dark:text-red-400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf870514c33bb1b53395ba02235f60146)): ?>
<?php $attributes = $__attributesOriginalf870514c33bb1b53395ba02235f60146; ?>
<?php unset($__attributesOriginalf870514c33bb1b53395ba02235f60146); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf870514c33bb1b53395ba02235f60146)): ?>
<?php $component = $__componentOriginalf870514c33bb1b53395ba02235f60146; ?>
<?php unset($__componentOriginalf870514c33bb1b53395ba02235f60146); ?>
<?php endif; ?>
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Autenticação</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">Segurança</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    AuthManager, Policies, Impersonation.
                                </p>
                            </a>

                            <a href="<?php echo e(route('docs.show', 'facades')); ?>" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-cyan-100 dark:bg-cyan-900/30">
                                        <?php if (isset($component)) { $__componentOriginal2f88c48393921ad5fc647fd6b777b971 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal2f88c48393921ad5fc647fd6b777b971 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.window','data' => ['class' => 'size-5 text-cyan-600 dark:text-cyan-400']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.window'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5 text-cyan-600 dark:text-cyan-400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal2f88c48393921ad5fc647fd6b777b971)): ?>
<?php $attributes = $__attributesOriginal2f88c48393921ad5fc647fd6b777b971; ?>
<?php unset($__attributesOriginal2f88c48393921ad5fc647fd6b777b971); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal2f88c48393921ad5fc647fd6b777b971)): ?>
<?php $component = $__componentOriginal2f88c48393921ad5fc647fd6b777b971; ?>
<?php unset($__componentOriginal2f88c48393921ad5fc647fd6b777b971); ?>
<?php endif; ?>
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Facades</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">Syntax Sugar</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Interface estática para serviços, 11 facades.
                                </p>
                            </a>

                            <a href="<?php echo e(route('docs.show', 'cache')); ?>" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-orange-100 dark:bg-orange-900/30">
                                        <?php if (isset($component)) { $__componentOriginal0e2cb4f314af8d2c8dd885a7f5b99cf1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal0e2cb4f314af8d2c8dd885a7f5b99cf1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.circle-stack','data' => ['class' => 'size-5 text-orange-600 dark:text-orange-400']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.circle-stack'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5 text-orange-600 dark:text-orange-400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal0e2cb4f314af8d2c8dd885a7f5b99cf1)): ?>
<?php $attributes = $__attributesOriginal0e2cb4f314af8d2c8dd885a7f5b99cf1; ?>
<?php unset($__attributesOriginal0e2cb4f314af8d2c8dd885a7f5b99cf1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal0e2cb4f314af8d2c8dd885a7f5b99cf1)): ?>
<?php $component = $__componentOriginal0e2cb4f314af8d2c8dd885a7f5b99cf1; ?>
<?php unset($__componentOriginal0e2cb4f314af8d2c8dd885a7f5b99cf1); ?>
<?php endif; ?>
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Cache</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">Performance</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Drivers Redis/File e estratégias de cache.
                                </p>
                            </a>

                            <a href="<?php echo e(route('docs.show', 'filesystem')); ?>" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-purple-100 dark:bg-purple-900/30">
                                        <?php if (isset($component)) { $__componentOriginal9d976d16d2d40e73349b791bdc546089 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9d976d16d2d40e73349b791bdc546089 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.folder','data' => ['class' => 'size-5 text-purple-600 dark:text-purple-400']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.folder'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5 text-purple-600 dark:text-purple-400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9d976d16d2d40e73349b791bdc546089)): ?>
<?php $attributes = $__attributesOriginal9d976d16d2d40e73349b791bdc546089; ?>
<?php unset($__attributesOriginal9d976d16d2d40e73349b791bdc546089); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9d976d16d2d40e73349b791bdc546089)): ?>
<?php $component = $__componentOriginal9d976d16d2d40e73349b791bdc546089; ?>
<?php unset($__componentOriginal9d976d16d2d40e73349b791bdc546089); ?>
<?php endif; ?>
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Filesystem</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">Storage</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Gestão de I/O, downloads e streams.
                                </p>
                            </a>

                            <a href="<?php echo e(route('docs.show', 'routing')); ?>" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-green-100 dark:bg-green-900/30">
                                        <?php if (isset($component)) { $__componentOriginal95555ebe3f8ddd05e3a83f35fc62cf74 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal95555ebe3f8ddd05e3a83f35fc62cf74 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.map','data' => ['class' => 'size-5 text-green-600 dark:text-green-400']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.map'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5 text-green-600 dark:text-green-400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal95555ebe3f8ddd05e3a83f35fc62cf74)): ?>
<?php $attributes = $__attributesOriginal95555ebe3f8ddd05e3a83f35fc62cf74; ?>
<?php unset($__attributesOriginal95555ebe3f8ddd05e3a83f35fc62cf74); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal95555ebe3f8ddd05e3a83f35fc62cf74)): ?>
<?php $component = $__componentOriginal95555ebe3f8ddd05e3a83f35fc62cf74; ?>
<?php unset($__componentOriginal95555ebe3f8ddd05e3a83f35fc62cf74); ?>
<?php endif; ?>
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Routing</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">HTTP</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Rotas, grupos, middleware e dispatching.
                                </p>
                            </a>

                            <a href="<?php echo e(route('docs.show', 'helpers')); ?>" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-pink-100 dark:bg-pink-900/30">
                                        <?php if (isset($component)) { $__componentOriginal0b9090dbc825cd3c1739a67277493948 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal0b9090dbc825cd3c1739a67277493948 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.code-bracket','data' => ['class' => 'size-5 text-pink-600 dark:text-pink-400']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.code-bracket'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5 text-pink-600 dark:text-pink-400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal0b9090dbc825cd3c1739a67277493948)): ?>
<?php $attributes = $__attributesOriginal0b9090dbc825cd3c1739a67277493948; ?>
<?php unset($__attributesOriginal0b9090dbc825cd3c1739a67277493948); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal0b9090dbc825cd3c1739a67277493948)): ?>
<?php $component = $__componentOriginal0b9090dbc825cd3c1739a67277493948; ?>
<?php unset($__componentOriginal0b9090dbc825cd3c1739a67277493948); ?>
<?php endif; ?>
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Helpers</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">Utilities</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Arrays, Strings e funções globais.
                                </p>
                            </a>

                            <a href="<?php echo e(route('docs.show', 'resources')); ?>" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-indigo-100 dark:bg-indigo-900/30">
                                        <?php if (isset($component)) { $__componentOriginalda6e47aecf1695047ea823532321ccd7 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalda6e47aecf1695047ea823532321ccd7 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.arrows-right-left','data' => ['class' => 'size-5 text-indigo-600 dark:text-indigo-400']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.arrows-right-left'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5 text-indigo-600 dark:text-indigo-400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalda6e47aecf1695047ea823532321ccd7)): ?>
<?php $attributes = $__attributesOriginalda6e47aecf1695047ea823532321ccd7; ?>
<?php unset($__attributesOriginalda6e47aecf1695047ea823532321ccd7); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalda6e47aecf1695047ea823532321ccd7)): ?>
<?php $component = $__componentOriginalda6e47aecf1695047ea823532321ccd7; ?>
<?php unset($__componentOriginalda6e47aecf1695047ea823532321ccd7); ?>
<?php endif; ?>
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Resources (DTOs)</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">API</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Serialização JSON com campos condicionais.
                                </p>
                            </a>

                            <a href="<?php echo e(route('docs.show', 'notifications')); ?>" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-amber-100 dark:bg-amber-900/30">
                                        <?php if (isset($component)) { $__componentOriginal2357204bbfb73ef228c684f3b7e8f9fa = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal2357204bbfb73ef228c684f3b7e8f9fa = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.bell','data' => ['class' => 'size-5 text-amber-600 dark:text-amber-400']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.bell'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5 text-amber-600 dark:text-amber-400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal2357204bbfb73ef228c684f3b7e8f9fa)): ?>
<?php $attributes = $__attributesOriginal2357204bbfb73ef228c684f3b7e8f9fa; ?>
<?php unset($__attributesOriginal2357204bbfb73ef228c684f3b7e8f9fa); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal2357204bbfb73ef228c684f3b7e8f9fa)): ?>
<?php $component = $__componentOriginal2357204bbfb73ef228c684f3b7e8f9fa; ?>
<?php unset($__componentOriginal2357204bbfb73ef228c684f3b7e8f9fa); ?>
<?php endif; ?>
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Notificações</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">Comunicação</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Multi-canal: Database, Email, Mattermost.
                                </p>
                            </a>

                            <a href="<?php echo e(route('docs.show', 'validation')); ?>" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-rose-100 dark:bg-rose-900/30">
                                        <?php if (isset($component)) { $__componentOriginaldb480e8d5d7476402b0c7e6f30ee2bdb = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaldb480e8d5d7476402b0c7e6f30ee2bdb = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.check-badge','data' => ['class' => 'size-5 text-rose-600 dark:text-rose-400']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.check-badge'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5 text-rose-600 dark:text-rose-400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaldb480e8d5d7476402b0c7e6f30ee2bdb)): ?>
<?php $attributes = $__attributesOriginaldb480e8d5d7476402b0c7e6f30ee2bdb; ?>
<?php unset($__attributesOriginaldb480e8d5d7476402b0c7e6f30ee2bdb); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldb480e8d5d7476402b0c7e6f30ee2bdb)): ?>
<?php $component = $__componentOriginaldb480e8d5d7476402b0c7e6f30ee2bdb; ?>
<?php unset($__componentOriginaldb480e8d5d7476402b0c7e6f30ee2bdb); ?>
<?php endif; ?>
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Validação</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">Forms & Data</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Rules, BaseRequest, Custom validation.
                                </p>
                            </a>

                            <a href="<?php echo e(route('docs.show', 'web-layer')); ?>" class="feature-card group">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-cyan-100 dark:bg-cyan-900/30">
                                        <?php if (isset($component)) { $__componentOriginale02ab0f625e6b2501fa40e35388d0046 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale02ab0f625e6b2501fa40e35388d0046 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.globe-alt','data' => ['class' => 'size-5 text-cyan-600 dark:text-cyan-400']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.globe-alt'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5 text-cyan-600 dark:text-cyan-400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale02ab0f625e6b2501fa40e35388d0046)): ?>
<?php $attributes = $__attributesOriginale02ab0f625e6b2501fa40e35388d0046; ?>
<?php unset($__attributesOriginale02ab0f625e6b2501fa40e35388d0046); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale02ab0f625e6b2501fa40e35388d0046)): ?>
<?php $component = $__componentOriginale02ab0f625e6b2501fa40e35388d0046; ?>
<?php unset($__componentOriginale02ab0f625e6b2501fa40e35388d0046); ?>
<?php endif; ?>
                                    </span>
                                    <div>
                                        <p class="font-semibold text-zinc-900 dark:text-white group-hover:text-primary transition-colors">Web Layer</p>
                                        <p class="text-xs text-zinc-500 dark:text-zinc-400">HTTP & API</p>
                                    </div>
                                </div>
                                <p class="text-sm text-zinc-700 dark:text-zinc-300">
                                    Controllers, Request, Response, Routing.
                                </p>
                            </a>
                        </div>
                    </div>

                    
                    <div>
                        <h2 class="text-xl font-semibold text-zinc-900 dark:text-white mb-4">Em breve</h2>
                        <div class="grid gap-4 md:grid-cols-2">
                            <div class="feature-card opacity-60 cursor-not-allowed">
                                <div class="flex items-center gap-3 mb-2">
                                    <span class="inline-flex size-10 items-center justify-center rounded-xl bg-zinc-100 dark:bg-zinc-800">
                                        <?php if (isset($component)) { $__componentOriginal7060d3090e71064d97cc826295a8c670 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal7060d3090e71064d97cc826295a8c670 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.queue-list','data' => ['class' => 'size-5 text-zinc-400']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.queue-list'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5 text-zinc-400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal7060d3090e71064d97cc826295a8c670)): ?>
<?php $attributes = $__attributesOriginal7060d3090e71064d97cc826295a8c670; ?>
<?php unset($__attributesOriginal7060d3090e71064d97cc826295a8c670); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal7060d3090e71064d97cc826295a8c670)): ?>
<?php $component = $__componentOriginal7060d3090e71064d97cc826295a8c670; ?>
<?php unset($__componentOriginal7060d3090e71064d97cc826295a8c670); ?>
<?php endif; ?>
                                    </span>
                                    <p class="font-semibold text-zinc-500">Filas</p>
                                </div>
                                <p class="text-sm text-zinc-500">Jobs, workers, e QueueMaster.</p>
                            </div>
                        </div>
                    </div>

                    
                    <div class="rounded-3xl border border-white/50 bg-white/85 p-8 shadow-lg backdrop-blur dark:border-zinc-800 dark:bg-zinc-900/80">
                        <h2 class="text-xl font-semibold text-zinc-900 dark:text-white mb-4">Conceitos Fundamentais</h2>

                        <div class="grid gap-4 md:grid-cols-2">
                            <div class="flex items-start gap-3">
                                <?php if (isset($component)) { $__componentOriginale0a0c12575af25a71f941c8515365d96 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale0a0c12575af25a71f941c8515365d96 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.bolt','data' => ['class' => 'size-5 text-amber-500 mt-0.5']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.bolt'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5 text-amber-500 mt-0.5']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale0a0c12575af25a71f941c8515365d96)): ?>
<?php $attributes = $__attributesOriginale0a0c12575af25a71f941c8515365d96; ?>
<?php unset($__attributesOriginale0a0c12575af25a71f941c8515365d96); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale0a0c12575af25a71f941c8515365d96)): ?>
<?php $component = $__componentOriginale0a0c12575af25a71f941c8515365d96; ?>
<?php unset($__componentOriginale0a0c12575af25a71f941c8515365d96); ?>
<?php endif; ?>
                                <div>
                                    <p class="font-semibold text-zinc-900 dark:text-white">Service Providers</p>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400">Porta de entrada para registrar serviços. Métodos <code>register()</code> e <code>boot()</code>.</p>
                                </div>
                            </div>
                            <div class="flex items-start gap-3">
                                <?php if (isset($component)) { $__componentOriginalda6e47aecf1695047ea823532321ccd7 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalda6e47aecf1695047ea823532321ccd7 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.arrows-right-left','data' => ['class' => 'size-5 text-blue-500 mt-0.5']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.arrows-right-left'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5 text-blue-500 mt-0.5']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalda6e47aecf1695047ea823532321ccd7)): ?>
<?php $attributes = $__attributesOriginalda6e47aecf1695047ea823532321ccd7; ?>
<?php unset($__attributesOriginalda6e47aecf1695047ea823532321ccd7); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalda6e47aecf1695047ea823532321ccd7)): ?>
<?php $component = $__componentOriginalda6e47aecf1695047ea823532321ccd7; ?>
<?php unset($__componentOriginalda6e47aecf1695047ea823532321ccd7); ?>
<?php endif; ?>
                                <div>
                                    <p class="font-semibold text-zinc-900 dark:text-white">Middleware Pipeline</p>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400">Requests passam por cadeia de middlewares antes do controller.</p>
                                </div>
                            </div>
                            <div class="flex items-start gap-3">
                                <?php if (isset($component)) { $__componentOriginal7060d3090e71064d97cc826295a8c670 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal7060d3090e71064d97cc826295a8c670 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.queue-list','data' => ['class' => 'size-5 text-green-500 mt-0.5']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.queue-list'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5 text-green-500 mt-0.5']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal7060d3090e71064d97cc826295a8c670)): ?>
<?php $attributes = $__attributesOriginal7060d3090e71064d97cc826295a8c670; ?>
<?php unset($__attributesOriginal7060d3090e71064d97cc826295a8c670); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal7060d3090e71064d97cc826295a8c670)): ?>
<?php $component = $__componentOriginal7060d3090e71064d97cc826295a8c670; ?>
<?php unset($__componentOriginal7060d3090e71064d97cc826295a8c670); ?>
<?php endif; ?>
                                <div>
                                    <p class="font-semibold text-zinc-900 dark:text-white">Filas & Jobs</p>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400">Processamento em background com Redis/RabbitMQ, retries e batches.</p>
                                </div>
                            </div>
                            <div class="flex items-start gap-3">
                                <?php if (isset($component)) { $__componentOriginalf870514c33bb1b53395ba02235f60146 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf870514c33bb1b53395ba02235f60146 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.shield-check','data' => ['class' => 'size-5 text-purple-500 mt-0.5']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.shield-check'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5 text-purple-500 mt-0.5']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf870514c33bb1b53395ba02235f60146)): ?>
<?php $attributes = $__attributesOriginalf870514c33bb1b53395ba02235f60146; ?>
<?php unset($__attributesOriginalf870514c33bb1b53395ba02235f60146); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf870514c33bb1b53395ba02235f60146)): ?>
<?php $component = $__componentOriginalf870514c33bb1b53395ba02235f60146; ?>
<?php unset($__componentOriginalf870514c33bb1b53395ba02235f60146); ?>
<?php endif; ?>
                                <div>
                                    <p class="font-semibold text-zinc-900 dark:text-white">Autenticação Híbrida</p>
                                    <p class="text-sm text-zinc-600 dark:text-zinc-400">Sessão legacy + tokens API (estilo Sanctum) com guards unificados.</p>
                                </div>
                            </div>
                        </div>

                        <div class="mt-6 rounded-xl border-l-4 border-amber-500 bg-amber-50 dark:bg-amber-900/20 p-4">
                            <div class="flex items-center gap-2 mb-1">
                                <?php if (isset($component)) { $__componentOriginal7dbc05838c17e1e397a9753ab5f157f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal7dbc05838c17e1e397a9753ab5f157f6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.light-bulb','data' => ['class' => 'size-5 text-amber-600 dark:text-amber-400']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.light-bulb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-5 text-amber-600 dark:text-amber-400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal7dbc05838c17e1e397a9753ab5f157f6)): ?>
<?php $attributes = $__attributesOriginal7dbc05838c17e1e397a9753ab5f157f6; ?>
<?php unset($__attributesOriginal7dbc05838c17e1e397a9753ab5f157f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal7dbc05838c17e1e397a9753ab5f157f6)): ?>
<?php $component = $__componentOriginal7dbc05838c17e1e397a9753ab5f157f6; ?>
<?php unset($__componentOriginal7dbc05838c17e1e397a9753ab5f157f6); ?>
<?php endif; ?>
                                <p class="font-semibold text-amber-800 dark:text-amber-200">Integração com Código Legado</p>
                            </div>
                            <p class="text-sm text-amber-900 dark:text-amber-100">
                                O framework expõe <strong>facades</strong> e <strong>bridges</strong> que permitem ao código em <code>_ajax/</code> e <code>_files/</code> acessar serviços modernos. Migre gradualmente sem quebrar o que já funciona.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.docs', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/paulo/www/guisoft/og-framework-documentation/resources/views/docs/index.blade.php ENDPATH**/ ?>