\
    {{-- resources/views/layouts/docs.blade.php --}}
    <!doctype html>
    <html lang="pt-BR">
    <head>
        <meta charset="utf-8">
        <title>{{ $title ?? 'Documentação' }}</title>

        {{-- Assets da aplicação (Tailwind, JS, etc.) --}}
        @vite(['resources/css/app.css', 'resources/js/app.js'])

        {{-- Gerencia tema claro/escuro do Flux --}}
        @fluxAppearance
    </head>
    <body class="min-h-screen bg-zinc-950 text-zinc-50 antialiased">

        {{-- SIDEBAR (layout de documentação) --}}
        <flux:sidebar
            sticky
            collapsible="mobile"
            class="bg-zinc-950 border-r border-zinc-800"
        >
            <flux:sidebar.header class="px-4 py-4">
                <flux:brand
                    href="{{ route('docs.index') }}"
                    name="Meu Framework"
                    slogan="Documentação"
                    class="text-left"
                >
                    {{-- Logo / marca --}}
                    <div class="flex items-center gap-2">
                        <div class="size-8 rounded-lg bg-emerald-500 flex items-center justify-center">
                            <flux:icon.bolt variant="solid" class="size-5 text-emerald-50" />
                        </div>
                        <div class="flex flex-col leading-tight">
                            <span class="font-semibold text-zinc-50 text-sm tracking-tight">
                                Meu Framework
                            </span>
                            <span class="text-xs text-zinc-400">
                                Documentação
                            </span>
                        </div>
                    </div>
                </flux:brand>

                <flux:sidebar.collapse class="lg:hidden" />
            </flux:sidebar.header>

            {{-- Busca de documentação (pode ser ligada a Livewire) --}}
            <div class="px-4 pb-3">
                <flux:input
                    icon="magnifying-glass"
                    placeholder="Buscar na documentação..."
                    size="sm"
                    class="w-full"
                    {{-- Exemplo de binding Livewire: wire:model.live="search" --}}
                />
            </div>

            {{-- Navegação principal --}}
            <flux:sidebar.nav class="px-2 pb-4 space-y-4">

                <flux:sidebar.group heading="Começando">
                    <flux:sidebar.item
                        href="{{ route('docs.show', 'introducao') }}"
                        icon="sparkles"
                        :current="request()->routeIs('docs.show') && request('slug') === 'introducao'"
                    >
                        Introdução
                    </flux:sidebar.item>

                    <flux:sidebar.item
                        href="{{ route('docs.show', 'instalacao') }}"
                        icon="arrow-down-tray"
                        :current="request('slug') === 'instalacao'"
                    >
                        Instalação
                    </flux:sidebar.item>

                    <flux:sidebar.item
                        href="{{ route('docs.show', 'primeiros-passos') }}"
                        icon="rocket-launch"
                        :current="request('slug') === 'primeiros-passos'"
                    >
                        Primeiros passos
                    </flux:sidebar.item>
                </flux:sidebar.group>

                <flux:sidebar.group heading="Guia">
                    <flux:sidebar.item
                        href="{{ route('docs.show', 'roteamento') }}"
                        icon="cursor-arrow-rays"
                        :current="request('slug') === 'roteamento'"
                    >
                        Roteamento
                    </flux:sidebar.item>

                    <flux:sidebar.item
                        href="{{ route('docs.show', 'middlewares') }}"
                        icon="shield-check"
                        :current="request('slug') === 'middlewares'"
                    >
                        Middlewares
                    </flux:sidebar.item>

                    <flux:sidebar.item
                        href="{{ route('docs.show', 'respostas') }}"
                        icon="arrow-path"
                        :current="request('slug') === 'respostas'"
                    >
                        Respostas
                    </flux:sidebar.item>
                </flux:sidebar.group>

                <flux:sidebar.group heading="Referência">
                    <flux:sidebar.item
                        href="{{ route('docs.show', 'config') }}"
                        icon="cog-6-tooth"
                        :current="request('slug') === 'config'"
                    >
                        Configuração
                    </flux:sidebar.item>

                    <flux:sidebar.item
                        href="{{ route('docs.show', 'helpers') }}"
                        icon="wrench-screwdriver"
                        :current="request('slug') === 'helpers'"
                    >
                        Helpers
                    </flux:sidebar.item>

                    <flux:sidebar.item
                        href="{{ route('docs.show', 'cli') }}"
                        icon="command-line"
                        :current="request('slug') === 'cli'"
                    >
                        CLI
                    </flux:sidebar.item>
                </flux:sidebar.group>
            </flux:sidebar.nav>

            <flux:sidebar.spacer />

            {{-- Rodapé da sidebar --}}
            <div class="px-4 py-4 border-t border-zinc-800 space-y-2">
                <flux:button
                    href="https://github.com/seu-usuario/seu-framework"
                    variant="ghost"
                    size="xs"
                    icon="code-bracket-square"
                    class="w-full justify-start text-zinc-300"
                >
                    GitHub
                </flux:button>

                <flux:button
                    href="{{ route('changelog') }}"
                    variant="ghost"
                    size="xs"
                    icon="clock"
                    class="w-full justify-start text-zinc-300"
                >
                    Changelog
                </flux:button>
            </div>
        </flux:sidebar>

        {{-- HEADER (topbar) --}}
        <flux:header class="lg:ms-64 border-b border-zinc-800 bg-zinc-950/80 backdrop-blur">
            <flux:header.section class="gap-2">
                <flux:sidebar.toggle class="lg:hidden" icon="bars-3" inset="left" />

                <flux:heading size="sm" class="truncate">
                    {{ $pageTitle ?? $title ?? 'Documentação' }}
                </flux:heading>
            </flux:header.section>

            <flux:header.section align="end" class="gap-2">
                <flux:button
                    variant="ghost"
                    size="xs"
                    icon="magnifying-glass"
                    class="hidden sm:inline-flex"
                />

                {{-- Alternar tema claro/escuro --}}
                <flux:button
                    variant="ghost"
                    size="xs"
                    icon="sun"
                    icon:variant="outline"
                    x-data
                    x-on:click="$dispatch('flux-toggle-theme')"
                />

                <flux:button
                    href="https://github.com/seu-usuario/seu-framework"
                    variant="outline"
                    size="xs"
                    icon="rocket-launch"
                    class="hidden sm:inline-flex"
                >
                    Star
                </flux:button>
            </flux:header.section>
        </flux:header>

        {{-- CONTEÚDO PRINCIPAL --}}
        <flux:main class="lg:ms-64">
            <flux:main.container class="py-10">
                {{ $slot }}
            </flux:main.container>
        </flux:main>

        @fluxScripts
    </body>
    </html>
